/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class FilterQueryOperation
implements QueryOperation {
    private final ResolvedExpression condition;
    private final QueryOperation child;

    public FilterQueryOperation(ResolvedExpression condition, QueryOperation child) {
        this.condition = condition;
        this.child = child;
    }

    public ResolvedExpression getCondition() {
        return this.condition;
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.child.getResolvedSchema();
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("condition", this.condition);
        return OperationUtils.formatWithChildren("Filter", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public String asSerializableString() {
        return String.format("SELECT %s FROM (%s\n) WHERE %s", OperationUtils.formatSelectColumns(this.getResolvedSchema()), OperationUtils.indent(this.child.asSerializableString()), this.condition.asSerializableString());
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.singletonList(this.child);
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

