/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonFormatOptions;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;

@Internal
public class JsonFormatOptionsUtil {
    public static final String SQL = "SQL";
    public static final String ISO_8601 = "ISO-8601";
    public static final Set<String> TIMESTAMP_FORMAT_ENUM = new HashSet<String>(Arrays.asList("SQL", "ISO-8601"));
    public static final String JSON_MAP_NULL_KEY_MODE_FAIL = "FAIL";
    public static final String JSON_MAP_NULL_KEY_MODE_DROP = "DROP";
    public static final String JSON_MAP_NULL_KEY_MODE_LITERAL = "LITERAL";

    public static TimestampFormat getTimestampFormat(ReadableConfig config) {
        String timestampFormat;
        switch (timestampFormat = (String)config.get(JsonFormatOptions.TIMESTAMP_FORMAT)) {
            case "SQL": {
                return TimestampFormat.SQL;
            }
            case "ISO-8601": {
                return TimestampFormat.ISO_8601;
            }
        }
        throw new TableException(String.format("Unsupported timestamp format '%s'. Validator should have checked that.", timestampFormat));
    }

    public static JsonFormatOptions.MapNullKeyMode getMapNullKeyMode(ReadableConfig config) {
        String mapNullKeyMode = (String)config.get(JsonFormatOptions.MAP_NULL_KEY_MODE);
        switch (mapNullKeyMode.toUpperCase()) {
            case "FAIL": {
                return JsonFormatOptions.MapNullKeyMode.FAIL;
            }
            case "DROP": {
                return JsonFormatOptions.MapNullKeyMode.DROP;
            }
            case "LITERAL": {
                return JsonFormatOptions.MapNullKeyMode.LITERAL;
            }
        }
        throw new TableException(String.format("Unsupported map null key handling mode '%s'. Validator should have checked that.", mapNullKeyMode));
    }

    public static void validateDecodingFormatOptions(ReadableConfig tableOptions) {
        boolean failOnMissingField = (Boolean)tableOptions.get(JsonFormatOptions.FAIL_ON_MISSING_FIELD);
        boolean ignoreParseErrors = (Boolean)tableOptions.get(JsonFormatOptions.IGNORE_PARSE_ERRORS);
        if (ignoreParseErrors && failOnMissingField) {
            throw new ValidationException(JsonFormatOptions.FAIL_ON_MISSING_FIELD.key() + " and " + JsonFormatOptions.IGNORE_PARSE_ERRORS.key() + " shouldn't both be true.");
        }
        JsonFormatOptionsUtil.validateTimestampFormat(tableOptions);
    }

    public static void validateEncodingFormatOptions(ReadableConfig tableOptions) {
        Set nullKeyModes = Arrays.stream(JsonFormatOptions.MapNullKeyMode.values()).map(Objects::toString).collect(Collectors.toSet());
        if (!nullKeyModes.contains(((String)tableOptions.get(JsonFormatOptions.MAP_NULL_KEY_MODE)).toUpperCase())) {
            throw new ValidationException(String.format("Unsupported value '%s' for option %s. Supported values are %s.", tableOptions.get(JsonFormatOptions.MAP_NULL_KEY_MODE), JsonFormatOptions.MAP_NULL_KEY_MODE.key(), nullKeyModes));
        }
        JsonFormatOptionsUtil.validateTimestampFormat(tableOptions);
    }

    static void validateTimestampFormat(ReadableConfig tableOptions) {
        String timestampFormat = (String)tableOptions.get(JsonFormatOptions.TIMESTAMP_FORMAT);
        if (!TIMESTAMP_FORMAT_ENUM.contains(timestampFormat)) {
            throw new ValidationException(String.format("Unsupported value '%s' for %s. Supported values are [SQL, ISO-8601].", timestampFormat, JsonFormatOptions.TIMESTAMP_FORMAT.key()));
        }
    }

    private JsonFormatOptionsUtil() {
    }
}

