/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.querybuilder;

import java.util.ArrayList;
import java.util.List;
import org.influxdb.querybuilder.Ordering;
import org.influxdb.querybuilder.Select;
import org.influxdb.querybuilder.SelectCoreImpl;
import org.influxdb.querybuilder.Where;
import org.influxdb.querybuilder.WhereNested;
import org.influxdb.querybuilder.clauses.AndConjunction;
import org.influxdb.querybuilder.clauses.Clause;
import org.influxdb.querybuilder.clauses.ConjunctionClause;
import org.influxdb.querybuilder.clauses.OrConjunction;

public class WhereCoreImpl<T extends Select>
implements Select,
Where {
    private final List<ConjunctionClause> clauses = new ArrayList<ConjunctionClause>();
    private final T statement;

    WhereCoreImpl(T statement) {
        this.statement = statement;
    }

    public WhereCoreImpl and(Clause clause) {
        this.clauses.add(new AndConjunction(clause));
        return this;
    }

    public WhereCoreImpl or(Clause clause) {
        this.clauses.add(new OrConjunction(clause));
        return this;
    }

    public WhereCoreImpl where() {
        return (WhereCoreImpl)this.statement.where();
    }

    public WhereCoreImpl where(Clause clause) {
        return (WhereCoreImpl)this.statement.where(clause);
    }

    public WhereCoreImpl where(String text) {
        return (WhereCoreImpl)this.statement.where(text);
    }

    @Override
    public List<ConjunctionClause> getClauses() {
        return this.clauses;
    }

    @Override
    public WhereNested andNested() {
        return new WhereNested<WhereCoreImpl>(this, false);
    }

    @Override
    public WhereNested orNested() {
        return new WhereNested<WhereCoreImpl>(this, true);
    }

    public SelectCoreImpl orderBy(Ordering orderings) {
        return (SelectCoreImpl)this.statement.orderBy(orderings);
    }

    public SelectCoreImpl groupBy(Object ... columns) {
        return (SelectCoreImpl)this.statement.groupBy(columns);
    }

    public SelectCoreImpl fill(Number value) {
        return (SelectCoreImpl)this.statement.fill(value);
    }

    public SelectCoreImpl fill(String value) {
        return (SelectCoreImpl)this.statement.fill(value);
    }

    public SelectCoreImpl limit(int limit) {
        return (SelectCoreImpl)this.statement.limit(limit);
    }

    public SelectCoreImpl limit(int limit, long offSet) {
        return (SelectCoreImpl)this.statement.limit(limit, offSet);
    }

    public SelectCoreImpl sLimit(int sLimit) {
        return (SelectCoreImpl)this.statement.sLimit(sLimit);
    }

    public SelectCoreImpl sLimit(int sLimit, long sOffSet) {
        return (SelectCoreImpl)this.statement.sLimit(sLimit, sOffSet);
    }

    public SelectCoreImpl tz(String timezone) {
        return (SelectCoreImpl)this.statement.tz(timezone);
    }
}

