/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.collector.ListenableCollector;
import org.apache.flink.table.runtime.generated.FilterCondition;
import org.apache.flink.table.runtime.generated.GeneratedCollector;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.operators.join.lookup.LookupJoinRunner;
import org.apache.flink.util.Collector;

public class LookupJoinWithCalcRunner
extends LookupJoinRunner {
    private static final long serialVersionUID = 5277183384939603386L;
    private final GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedCalc;
    private transient FlatMapFunction<RowData, RowData> calc;
    private transient Collector<RowData> calcCollector;

    public LookupJoinWithCalcRunner(GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedFetcher, GeneratedFunction<FlatMapFunction<RowData, RowData>> generatedCalc, GeneratedCollector<ListenableCollector<RowData>> generatedCollector, GeneratedFunction<FilterCondition> generatedFilterCondition, boolean isLeftOuterJoin, int tableFieldsCount) {
        super(generatedFetcher, generatedCollector, generatedFilterCondition, isLeftOuterJoin, tableFieldsCount);
        this.generatedCalc = generatedCalc;
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        this.calc = (FlatMapFunction)this.generatedCalc.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        FunctionUtils.setFunctionRuntimeContext(this.calc, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.calc, (OpenContext)openContext);
        this.calcCollector = new CalcCollector(this.collector);
    }

    @Override
    public void close() throws Exception {
        super.close();
        FunctionUtils.closeFunction(this.calc);
    }

    @Override
    public Collector<RowData> getFetcherCollector() {
        return this.calcCollector;
    }

    private class CalcCollector
    implements Collector<RowData> {
        private final Collector<RowData> delegate;

        private CalcCollector(Collector<RowData> delegate) {
            this.delegate = delegate;
        }

        public void collect(RowData record) {
            try {
                LookupJoinWithCalcRunner.this.calc.flatMap((Object)record, this.delegate);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            this.delegate.close();
        }
    }
}

