/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window.processors;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.TimeZone;
import java.util.function.Supplier;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.dataview.PerWindowStateDataViewStore;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.window.tvf.common.ClockService;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowTimerService;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigners;
import org.apache.flink.table.runtime.operators.window.tvf.state.WindowValueState;
import org.apache.flink.util.Preconditions;

public abstract class AbstractWindowAggProcessor<W>
implements WindowProcessor<W> {
    private static final long serialVersionUID = 1L;
    protected final GeneratedNamespaceAggsHandleFunction<W> genAggsHandler;
    protected final TypeSerializer<RowData> accSerializer;
    protected final boolean isEventTime;
    protected final ZoneId shiftTimeZone;
    protected final boolean useDayLightSaving;
    protected final WindowIsEmptySupplier emptySupplier;
    protected transient long currentProgress;
    protected transient WindowProcessor.Context<W> ctx;
    protected transient ClockService clockService;
    protected transient WindowTimerService<W> windowTimerService;
    protected transient NamespaceAggsHandleFunction<W> aggregator;
    protected transient WindowValueState<W> windowState;
    protected transient JoinedRowData reuseOutput;

    public AbstractWindowAggProcessor(GeneratedNamespaceAggsHandleFunction<W> genAggsHandler, WindowAssigner sliceAssigner, TypeSerializer<RowData> accSerializer, boolean isEventTime, int indexOfCountStar, ZoneId shiftTimeZone) {
        this.genAggsHandler = genAggsHandler;
        this.accSerializer = accSerializer;
        this.isEventTime = isEventTime;
        this.shiftTimeZone = shiftTimeZone;
        this.useDayLightSaving = TimeZone.getTimeZone(shiftTimeZone).useDaylightTime();
        this.emptySupplier = new WindowIsEmptySupplier(indexOfCountStar, sliceAssigner);
    }

    @Override
    public void open(WindowProcessor.Context<W> context) throws Exception {
        this.ctx = context;
        TypeSerializer namespaceSerializer = this.createWindowSerializer();
        ValueState state = (ValueState)this.ctx.getKeyedStateBackend().getOrCreateKeyedState(namespaceSerializer, (StateDescriptor)new ValueStateDescriptor("window-aggs", this.accSerializer));
        this.windowState = new WindowValueState((InternalValueState)state);
        this.clockService = ClockService.of(this.ctx.getTimerService());
        this.aggregator = (NamespaceAggsHandleFunction)this.genAggsHandler.newInstance(this.ctx.getRuntimeContext().getUserCodeClassLoader());
        this.aggregator.open(new PerWindowStateDataViewStore(this.ctx.getKeyedStateBackend(), namespaceSerializer, this.ctx.getRuntimeContext()));
        this.reuseOutput = new JoinedRowData();
        this.currentProgress = Long.MIN_VALUE;
        this.windowTimerService = this.getWindowTimerService();
    }

    protected abstract WindowTimerService<W> getWindowTimerService();

    @Override
    public void initializeWatermark(long watermark) {
        if (this.isEventTime) {
            this.currentProgress = watermark;
        }
    }

    @Override
    public void close() throws Exception {
        if (this.aggregator != null) {
            this.aggregator.close();
        }
    }

    protected void collect(RowData aggResult) {
        this.reuseOutput.replace((RowData)this.ctx.getKeyedStateBackend().getCurrentKey(), aggResult);
        this.ctx.output((RowData)this.reuseOutput);
    }

    protected final class WindowIsEmptySupplier
    implements Supplier<Boolean>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int indexOfCountStar;

        private WindowIsEmptySupplier(int indexOfCountStar, WindowAssigner assigner) {
            if (assigner instanceof SliceAssigners.HoppingSliceAssigner) {
                Preconditions.checkArgument((indexOfCountStar >= 0 ? 1 : 0) != 0, (Object)"Hopping window requires a COUNT(*) in the aggregate functions.");
            }
            this.indexOfCountStar = indexOfCountStar;
        }

        @Override
        public Boolean get() {
            if (this.indexOfCountStar < 0) {
                return false;
            }
            try {
                RowData acc = AbstractWindowAggProcessor.this.aggregator.getAccumulators();
                return acc == null || acc.getLong(this.indexOfCountStar) == 0L;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

