/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window;

import java.time.ZoneId;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.aggregate.window.buffers.RecordsWindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.window.buffers.WindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.window.combines.AggCombiner;
import org.apache.flink.table.runtime.operators.aggregate.window.combines.GlobalAggCombiner;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.AbstractSliceWindowAggProcessor;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.SliceSharedWindowAggProcessor;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.SliceUnsharedWindowAggProcessor;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.UnsliceWindowAggProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.combines.RecordsCombiner;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAggOperator;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceSharedAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SliceUnsharedAssigner;
import org.apache.flink.table.runtime.operators.window.tvf.slicing.SlicingWindowProcessor;
import org.apache.flink.table.runtime.operators.window.tvf.unslicing.UnsliceAssigner;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.util.Preconditions;

public class WindowAggOperatorBuilder {
    private WindowAssigner assigner;
    private AbstractRowDataSerializer<RowData> inputSerializer;
    private PagedTypeSerializer<RowData> keySerializer;
    private AbstractRowDataSerializer<RowData> accSerializer;
    private GeneratedNamespaceAggsHandleFunction<?> generatedAggregateFunction;
    private GeneratedNamespaceAggsHandleFunction<?> localGeneratedAggregateFunction;
    private GeneratedNamespaceAggsHandleFunction<?> globalGeneratedAggregateFunction;
    private int indexOfCountStart = -1;
    private ZoneId shiftTimeZone;

    public static WindowAggOperatorBuilder builder() {
        return new WindowAggOperatorBuilder();
    }

    public WindowAggOperatorBuilder inputSerializer(AbstractRowDataSerializer<RowData> inputSerializer) {
        this.inputSerializer = inputSerializer;
        return this;
    }

    public WindowAggOperatorBuilder shiftTimeZone(ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
        return this;
    }

    public WindowAggOperatorBuilder keySerializer(PagedTypeSerializer<RowData> keySerializer) {
        this.keySerializer = keySerializer;
        return this;
    }

    public WindowAggOperatorBuilder assigner(WindowAssigner assigner) {
        this.assigner = assigner;
        return this;
    }

    public WindowAggOperatorBuilder aggregate(GeneratedNamespaceAggsHandleFunction<?> generatedAggregateFunction, AbstractRowDataSerializer<RowData> accSerializer) {
        this.generatedAggregateFunction = generatedAggregateFunction;
        this.accSerializer = accSerializer;
        return this;
    }

    public WindowAggOperatorBuilder globalAggregate(GeneratedNamespaceAggsHandleFunction<?> localGeneratedAggregateFunction, GeneratedNamespaceAggsHandleFunction<?> globalGeneratedAggregateFunction, GeneratedNamespaceAggsHandleFunction<?> stateGeneratedAggregateFunction, AbstractRowDataSerializer<RowData> accSerializer) {
        this.localGeneratedAggregateFunction = localGeneratedAggregateFunction;
        this.globalGeneratedAggregateFunction = globalGeneratedAggregateFunction;
        this.generatedAggregateFunction = stateGeneratedAggregateFunction;
        this.accSerializer = accSerializer;
        return this;
    }

    public WindowAggOperatorBuilder countStarIndex(int indexOfCountStart) {
        this.indexOfCountStart = indexOfCountStart;
        return this;
    }

    public WindowAggOperator<RowData, ?> build() {
        Preconditions.checkNotNull((Object)this.assigner);
        Preconditions.checkNotNull(this.inputSerializer);
        Preconditions.checkNotNull(this.keySerializer);
        Preconditions.checkNotNull(this.accSerializer);
        Preconditions.checkNotNull(this.generatedAggregateFunction);
        WindowProcessor<Long> windowProcessor = this.assigner instanceof SliceAssigner ? this.buildSlicingWindowProcessor() : this.buildUnslicingWindowProcessor();
        return new WindowAggOperator(windowProcessor, this.assigner.isEventTime());
    }

    private SlicingWindowProcessor<Long> buildSlicingWindowProcessor() {
        AbstractSliceWindowAggProcessor windowProcessor;
        boolean isGlobalAgg = this.localGeneratedAggregateFunction != null && this.globalGeneratedAggregateFunction != null;
        RecordsCombiner.Factory combinerFactory = isGlobalAgg ? new GlobalAggCombiner.Factory(this.localGeneratedAggregateFunction, this.globalGeneratedAggregateFunction) : new AggCombiner.Factory(this.generatedAggregateFunction);
        RecordsWindowBuffer.Factory bufferFactory = new RecordsWindowBuffer.Factory(this.keySerializer, this.inputSerializer, combinerFactory);
        if (this.assigner instanceof SliceSharedAssigner) {
            windowProcessor = new SliceSharedWindowAggProcessor(this.generatedAggregateFunction, (WindowBuffer.Factory)bufferFactory, (SliceSharedAssigner)this.assigner, this.accSerializer, this.indexOfCountStart, this.shiftTimeZone);
        } else if (this.assigner instanceof SliceUnsharedAssigner) {
            windowProcessor = new SliceUnsharedWindowAggProcessor(this.generatedAggregateFunction, (WindowBuffer.Factory)bufferFactory, (SliceUnsharedAssigner)this.assigner, this.accSerializer, this.indexOfCountStart, this.shiftTimeZone);
        } else {
            throw new IllegalArgumentException("assigner must be instance of SliceUnsharedAssigner or SliceSharedAssigner.");
        }
        return windowProcessor;
    }

    private UnsliceWindowAggProcessor buildUnslicingWindowProcessor() {
        return new UnsliceWindowAggProcessor(this.generatedAggregateFunction, (UnsliceAssigner)this.assigner, this.accSerializer, this.indexOfCountStart, this.shiftTimeZone);
    }
}

