/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.ValidationException;

@Experimental
public interface PartitionCommitPolicy {
    public static final String METASTORE = "metastore";
    public static final String SUCCESS_FILE = "success-file";
    public static final String CUSTOM = "custom";

    public void commit(Context var1) throws Exception;

    public static void validatePolicyChain(boolean isEmptyMetastore, String policyKind) {
        if (policyKind != null) {
            String[] policyStrings;
            for (String policy : policyStrings = policyKind.split(",")) {
                if (!isEmptyMetastore || !METASTORE.equalsIgnoreCase(policy)) continue;
                throw new ValidationException("Can not configure a 'metastore' partition commit policy for a file system table. You can only configure 'metastore' partition commit policy for a hive table.");
            }
        }
    }

    public static interface Context {
        public String catalogName();

        public String databaseName();

        public String tableName();

        public List<String> partitionKeys();

        public List<String> partitionValues();

        public Path partitionPath();

        default public LinkedHashMap<String, String> partitionSpec() {
            LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
            for (int i = 0; i < this.partitionKeys().size(); ++i) {
                res.put(this.partitionKeys().get(i), this.partitionValues().get(i));
            }
            return res;
        }
    }
}

