/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.compactor.operator;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.connector.file.sink.compactor.FileCompactStrategy;
import org.apache.flink.connector.file.sink.compactor.operator.CompactCoordinator;
import org.apache.flink.connector.file.sink.compactor.operator.CompactorRequest;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.util.function.SerializableSupplierWithException;

@Internal
public class CompactCoordinatorFactory
extends AbstractStreamOperatorFactory<CompactorRequest>
implements OneInputStreamOperatorFactory<CommittableMessage<FileSinkCommittable>, CompactorRequest> {
    private final FileCompactStrategy strategy;
    private final SerializableSupplierWithException<SimpleVersionedSerializer<FileSinkCommittable>, IOException> committableSerializerSupplier;

    public CompactCoordinatorFactory(FileCompactStrategy strategy, SerializableSupplierWithException<SimpleVersionedSerializer<FileSinkCommittable>, IOException> committableSerializerSupplier) {
        this.strategy = strategy;
        this.committableSerializerSupplier = committableSerializerSupplier;
    }

    public <T extends StreamOperator<CompactorRequest>> T createStreamOperator(StreamOperatorParameters<CompactorRequest> parameters) {
        try {
            CompactCoordinator compactOperator = new CompactCoordinator(this.strategy, (SimpleVersionedSerializer<FileSinkCommittable>)((SimpleVersionedSerializer)this.committableSerializerSupplier.get()));
            compactOperator.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
            return (T)((Object)compactOperator);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create commit operator for " + parameters.getStreamConfig().getOperatorName(), e);
        }
    }

    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return CompactCoordinator.class;
    }
}

