/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.source.reader.fetcher;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.connector.base.source.reader.fetcher.SplitFetcherTask;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class PauseOrResumeSplitsTask<SplitT extends SourceSplit>
implements SplitFetcherTask {
    private static final Logger LOG = LoggerFactory.getLogger(PauseOrResumeSplitsTask.class);
    private final SplitReader<?, SplitT> splitReader;
    private final Collection<SplitT> splitsToPause;
    private final Collection<SplitT> splitsToResume;
    private final boolean allowUnalignedSourceSplits;

    PauseOrResumeSplitsTask(SplitReader<?, SplitT> splitReader, Collection<SplitT> splitsToPause, Collection<SplitT> splitsToResume, boolean allowUnalignedSourceSplits) {
        this.splitReader = (SplitReader)Preconditions.checkNotNull(splitReader);
        this.splitsToPause = (Collection)Preconditions.checkNotNull(splitsToPause);
        this.splitsToResume = (Collection)Preconditions.checkNotNull(splitsToResume);
        this.allowUnalignedSourceSplits = allowUnalignedSourceSplits;
    }

    @Override
    public boolean run() throws IOException {
        block2: {
            try {
                this.splitReader.pauseOrResumeSplits(this.splitsToPause, this.splitsToResume);
            }
            catch (UnsupportedOperationException e) {
                if (this.allowUnalignedSourceSplits) break block2;
                throw e;
            }
        }
        return true;
    }

    @Override
    public void wakeUp() {
    }

    public String toString() {
        return "PauseOrResumeSplitsTask{splitsToResume=" + this.splitsToResume + ", splitsToPause=" + this.splitsToPause + '}';
    }
}

