/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.mxml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flex.compiler.internal.mxml.MXMLUnitData;
import org.apache.flex.compiler.mxml.IMXMLInstructionData;
import org.apache.flex.compiler.parsing.IMXMLToken;

public class MXMLInstructionData
extends MXMLUnitData
implements IMXMLInstructionData {
    private static Pattern WHITESPACE = Pattern.compile("[ \t\r\n]+");
    private String instructionText;
    private int targetEndIndex;
    private int contentStartIndex;

    MXMLInstructionData(IMXMLToken token) {
        this.instructionText = token.getText();
        Matcher m = WHITESPACE.matcher(this.instructionText);
        if (m.find()) {
            this.targetEndIndex = m.start();
            this.contentStartIndex = m.end();
        } else {
            this.targetEndIndex = this.instructionText.length() - 2;
            this.contentStartIndex = this.instructionText.length() - 2;
        }
        this.setOffsets(token.getStart(), token.getEnd());
        this.setColumn(token.getColumn());
        this.setLine(token.getLine());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('|');
        sb.append(this.getInstructionText());
        sb.append('|');
        sb.append(' ');
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public String toDumpString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toDumpString());
        sb.append('\t');
        sb.append('\"');
        sb.append(this.getInstructionText());
        sb.append('\"');
        return sb.toString();
    }

    @Override
    public String getInstructionText() {
        return this.instructionText;
    }

    @Override
    public String getTarget() {
        return this.instructionText.substring(2, this.targetEndIndex);
    }

    @Override
    public String getContent() {
        return this.instructionText.substring(this.contentStartIndex, this.instructionText.length() - 2);
    }
}

