/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.css;

import com.google.common.base.Joiner;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.apache.flex.compiler.css.ICSSMediaQueryCondition;
import org.apache.flex.compiler.css.ICSSPropertyValue;
import org.apache.flex.compiler.internal.css.CSSKeywordPropertyValue;
import org.apache.flex.compiler.internal.css.CSSModelTreeType;
import org.apache.flex.compiler.internal.css.CSSNodeBase;
import org.apache.flex.compiler.internal.css.CSSPropertyValue;

public class CSSMediaQueryCondition
extends CSSNodeBase
implements ICSSMediaQueryCondition {
    private final CSSPropertyValue value;
    private final String key;

    protected CSSMediaQueryCondition(CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.MEDIA_QUERY_CONDITION);
        this.value = new CSSKeywordPropertyValue(tree, tokenStream);
        this.key = null;
    }

    protected CSSMediaQueryCondition(String key, CSSPropertyValue value, CommonTree tree, TokenStream tokenStream) {
        super(tree, tokenStream, CSSModelTreeType.MEDIA_QUERY_CONDITION);
        assert (value != null) : "Do not create empty media query condition.";
        this.value = value;
        this.key = key;
    }

    @Override
    public ICSSPropertyValue getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        if (this.key == null) {
            return this.value.toString();
        }
        return Joiner.on((String)"").join((Object)"(", (Object)this.key, new Object[]{":", this.value.toString(), ")"});
    }

    @Override
    public String getKey() {
        return this.key;
    }
}

