/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.forks.batik.ext.awt.image.renderable;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.flex.forks.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.flex.forks.batik.ext.awt.image.GraphicsUtil;
import org.apache.flex.forks.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.flex.forks.batik.ext.awt.image.renderable.Filter;
import org.apache.flex.forks.batik.ext.awt.image.rendered.CachableRed;
import org.apache.flex.forks.batik.ext.awt.image.rendered.ProfileRed;

public class ProfileRable
extends AbstractRable {
    private ICCColorSpaceExt colorSpace;

    public ProfileRable(Filter src, ICCColorSpaceExt colorSpace) {
        super(src);
        this.colorSpace = colorSpace;
    }

    public void setSource(Filter src) {
        this.init(src, null);
    }

    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    public void setColorSpace(ICCColorSpaceExt colorSpace) {
        this.touch();
        this.colorSpace = colorSpace;
    }

    public ICCColorSpaceExt getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public RenderedImage createRendering(RenderContext rc) {
        RenderedImage srcRI = this.getSource().createRendering(rc);
        if (srcRI == null) {
            return null;
        }
        CachableRed srcCR = GraphicsUtil.wrap(srcRI);
        return new ProfileRed(srcCR, this.colorSpace);
    }
}

