package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.GetSelfLoansLoanIdChargesResponse;
import org.apache.fineract.client.models.GetSelfLoansLoanIdResponse;
import org.apache.fineract.client.models.GetSelfLoansLoanIdTransactionsTransactionIdResponse;
import org.apache.fineract.client.models.GetSelfLoansTemplateResponse;
import org.apache.fineract.client.models.GuarantorData;
import org.apache.fineract.client.models.PostSelfLoansLoanIdRequest;
import org.apache.fineract.client.models.PostSelfLoansLoanIdResponse;
import org.apache.fineract.client.models.PostSelfLoansRequest;
import org.apache.fineract.client.models.PostSelfLoansResponse;
import org.apache.fineract.client.models.PutSelfLoansLoanIdRequest;
import org.apache.fineract.client.models.PutSelfLoansLoanIdResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface SelfLoansApi {
    /**
    * Calculate Loan Repayment Schedule | Submit a new Loan Application
    * Calculate Loan Repayment Schedule:  Calculates Loan Repayment Schedule  Mandatory Fields: productId, principal, loanTermFrequency, loanTermFrequencyType, numberOfRepayments, repaymentEvery, repaymentFrequencyType, interestRatePerPeriod, amortizationType, interestType, interestCalculationPeriodType, expectedDisbursementDate, transactionProcessingStrategyCode  Submit a new Loan Application:  Mandatory Fields: clientId, productId, principal, loanTermFrequency, loanTermFrequencyType, loanType, numberOfRepayments, repaymentEvery, repaymentFrequencyType, interestRatePerPeriod, amortizationType, interestType, interestCalculationPeriodType, transactionProcessingStrategyCode, expectedDisbursementDate, submittedOnDate, loanType  Additional Mandatory Fields if interest recalculation is enabled for product and Rest frequency not same as repayment period: recalculationRestFrequencyDate  Additional Mandatory Fields if interest recalculation with interest/fee compounding is enabled for product and compounding frequency not same as repayment period: recalculationCompoundingFrequencyDate  Additional Mandatory Field if Entity-Datatable Check is enabled for the entity of type loan: datatables  Optional Fields: graceOnPrincipalPayment, graceOnInterestPayment, graceOnInterestCharged, linkAccountId, allowPartialPeriodInterestCalcualtion, fixedEmiAmount, maxOutstandingLoanBalance, disbursementData, graceOnArrearsAgeing, createStandingInstructionAtDisbursement (requires linkedAccountId if set to true)  Showing request/response for &#39;Submit a new Loan Application&#39;
        * @param postSelfLoansRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostSelfLoansResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/self/loans")
    Call<PostSelfLoansResponse> calculateLoanScheduleOrSubmitLoanApplication1(@retrofit2.http.Body PostSelfLoansRequest postSelfLoansRequest, @retrofit2.http.Query("command") String command);

    /**
    * Update a Loan Application
    * Loan application can only be modified when in &#39;Submitted and pending approval&#39; state. Once the application is approved, the details cannot be changed using this method.
        * @param loanId loanId (required)
        * @param putSelfLoansLoanIdRequest  (required)
    * @return Call&lt;PutSelfLoansLoanIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/self/loans/{loanId}")
    Call<PutSelfLoansLoanIdResponse> modifyLoanApplication2(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PutSelfLoansLoanIdRequest putSelfLoansLoanIdRequest);

    /**
    * List Loan Charges
    * Lists loan Charges  Example Requests:  self/loans/1/charges   self/loans/1/charges?fields&#x3D;name,amountOrPercentage
        * @param loanId loanId (required)
    * @return Call&lt;List&lt;GetSelfLoansLoanIdChargesResponse&gt;&gt;
    */
    @GET("v1/self/loans/{loanId}/charges")
    Call<List<GetSelfLoansLoanIdChargesResponse>> retrieveAllLoanCharges2(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * 
    * 
        * @param loanId  (required)
    * @return Call&lt;List&lt;GuarantorData&gt;&gt;
    */
    @GET("v1/self/loans/{loanId}/guarantors")
    Call<List<GuarantorData>> retrieveGuarantorDetails2(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * Retrieve a Loan
    * Retrieves a Loan  Example Requests:  self/loans/1   self/loans/1?fields&#x3D;id,principal,annualInterestRate   self/loans/1?fields&#x3D;id,principal,annualInterestRate&amp;associations&#x3D;repaymentSchedule,transactions
        * @param loanId loanId (required)
    * @return Call&lt;GetSelfLoansLoanIdResponse&gt;
    */
    @GET("v1/self/loans/{loanId}")
    Call<GetSelfLoansLoanIdResponse> retrieveLoan2(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * Retrieve a Loan Charge
    * Retrieves a Loan Charge  Example Requests:  self/loans/1/charges/1   self/loans/1/charges/1?fields&#x3D;name,amountOrPercentage
        * @param loanId loanId (required)
        * @param chargeId chargeId (required)
    * @return Call&lt;GetSelfLoansLoanIdChargesResponse&gt;
    */
    @GET("v1/self/loans/{loanId}/charges/{chargeId}")
    Call<GetSelfLoansLoanIdChargesResponse> retrieveLoanCharge4(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("chargeId") Long chargeId);

    /**
    * Retrieve a Loan Transaction Details
    * Retrieves a Loan Transaction DetailsExample Request:  self/loans/5/transactions/3
        * @param loanId loanId (required)
        * @param transactionId transactionId (required)
        * @param fields Optional Loan Transaction attribute list to be in the response (optional)
    * @return Call&lt;GetSelfLoansLoanIdTransactionsTransactionIdResponse&gt;
    */
    @GET("v1/self/loans/{loanId}/transactions/{transactionId}")
    Call<GetSelfLoansLoanIdTransactionsTransactionIdResponse> retrieveTransaction1(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Query("fields") String fields);

    /**
    * Applicant Withdraws from Loan Application
    * Applicant Withdraws from Loan Application  Mandatory Fields: withdrawnOnDate
        * @param loanId loanId (required)
        * @param postSelfLoansLoanIdRequest  (required)
        * @param command command (optional)
    * @return Call&lt;PostSelfLoansLoanIdResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/self/loans/{loanId}")
    Call<PostSelfLoansLoanIdResponse> stateTransitions2(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PostSelfLoansLoanIdRequest postSelfLoansLoanIdRequest, @retrofit2.http.Query("command") String command);

    /**
    * Retrieve Loan Details Template
    * Retrieves Loan Details Template  This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:  Field Defaults Allowed description Lists  Example Requests:  self/loans/template?templateType&#x3D;individual&amp;clientId&#x3D;1   self/loans/template?templateType&#x3D;individual&amp;clientId&#x3D;1&amp;productId&#x3D;1
        * @param clientId clientId (optional)
        * @param productId productId (optional)
        * @param templateType templateType (optional)
    * @return Call&lt;GetSelfLoansTemplateResponse&gt;
    */
    @GET("v1/self/loans/template")
    Call<GetSelfLoansTemplateResponse> template17(@retrofit2.http.Query("clientId") Long clientId, @retrofit2.http.Query("productId") Long productId, @retrofit2.http.Query("templateType") String templateType);



        /**
        * Calculate Loan Repayment Schedule | Submit a new Loan Application
        * Calculate Loan Repayment Schedule:  Calculates Loan Repayment Schedule  Mandatory Fields: productId, principal, loanTermFrequency, loanTermFrequencyType, numberOfRepayments, repaymentEvery, repaymentFrequencyType, interestRatePerPeriod, amortizationType, interestType, interestCalculationPeriodType, expectedDisbursementDate, transactionProcessingStrategyCode  Submit a new Loan Application:  Mandatory Fields: clientId, productId, principal, loanTermFrequency, loanTermFrequencyType, loanType, numberOfRepayments, repaymentEvery, repaymentFrequencyType, interestRatePerPeriod, amortizationType, interestType, interestCalculationPeriodType, transactionProcessingStrategyCode, expectedDisbursementDate, submittedOnDate, loanType  Additional Mandatory Fields if interest recalculation is enabled for product and Rest frequency not same as repayment period: recalculationRestFrequencyDate  Additional Mandatory Fields if interest recalculation with interest/fee compounding is enabled for product and compounding frequency not same as repayment period: recalculationCompoundingFrequencyDate  Additional Mandatory Field if Entity-Datatable Check is enabled for the entity of type loan: datatables  Optional Fields: graceOnPrincipalPayment, graceOnInterestPayment, graceOnInterestCharged, linkAccountId, allowPartialPeriodInterestCalcualtion, fixedEmiAmount, maxOutstandingLoanBalance, disbursementData, graceOnArrearsAgeing, createStandingInstructionAtDisbursement (requires linkedAccountId if set to true)  Showing request/response for &#39;Submit a new Loan Application&#39;
            * @param postSelfLoansRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostSelfLoansResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/self/loans")
    Call<PostSelfLoansResponse> calculateLoanScheduleOrSubmitLoanApplication1(@retrofit2.http.Body PostSelfLoansRequest postSelfLoansRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Update a Loan Application
        * Loan application can only be modified when in &#39;Submitted and pending approval&#39; state. Once the application is approved, the details cannot be changed using this method.
            * @param loanId loanId (required)
            * @param putSelfLoansLoanIdRequest  (required)
        * @return Call&lt;PutSelfLoansLoanIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/self/loans/{loanId}")
    Call<PutSelfLoansLoanIdResponse> modifyLoanApplication2(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PutSelfLoansLoanIdRequest putSelfLoansLoanIdRequest, @HeaderMap Map<String, String> headers);

        /**
        * List Loan Charges
        * Lists loan Charges  Example Requests:  self/loans/1/charges   self/loans/1/charges?fields&#x3D;name,amountOrPercentage
            * @param loanId loanId (required)
        * @return Call&lt;List&lt;GetSelfLoansLoanIdChargesResponse&gt;&gt;
        */
    @GET("v1/self/loans/{loanId}/charges")
    Call<List<GetSelfLoansLoanIdChargesResponse>> retrieveAllLoanCharges2(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param loanId  (required)
        * @return Call&lt;List&lt;GuarantorData&gt;&gt;
        */
    @GET("v1/self/loans/{loanId}/guarantors")
    Call<List<GuarantorData>> retrieveGuarantorDetails2(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Loan
        * Retrieves a Loan  Example Requests:  self/loans/1   self/loans/1?fields&#x3D;id,principal,annualInterestRate   self/loans/1?fields&#x3D;id,principal,annualInterestRate&amp;associations&#x3D;repaymentSchedule,transactions
            * @param loanId loanId (required)
        * @return Call&lt;GetSelfLoansLoanIdResponse&gt;
        */
    @GET("v1/self/loans/{loanId}")
    Call<GetSelfLoansLoanIdResponse> retrieveLoan2(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Loan Charge
        * Retrieves a Loan Charge  Example Requests:  self/loans/1/charges/1   self/loans/1/charges/1?fields&#x3D;name,amountOrPercentage
            * @param loanId loanId (required)
            * @param chargeId chargeId (required)
        * @return Call&lt;GetSelfLoansLoanIdChargesResponse&gt;
        */
    @GET("v1/self/loans/{loanId}/charges/{chargeId}")
    Call<GetSelfLoansLoanIdChargesResponse> retrieveLoanCharge4(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("chargeId") Long chargeId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a Loan Transaction Details
        * Retrieves a Loan Transaction DetailsExample Request:  self/loans/5/transactions/3
            * @param loanId loanId (required)
            * @param transactionId transactionId (required)
            * @param fields Optional Loan Transaction attribute list to be in the response (optional)
        * @return Call&lt;GetSelfLoansLoanIdTransactionsTransactionIdResponse&gt;
        */
    @GET("v1/self/loans/{loanId}/transactions/{transactionId}")
    Call<GetSelfLoansLoanIdTransactionsTransactionIdResponse> retrieveTransaction1(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Query("fields") String fields, @HeaderMap Map<String, String> headers);

        /**
        * Applicant Withdraws from Loan Application
        * Applicant Withdraws from Loan Application  Mandatory Fields: withdrawnOnDate
            * @param loanId loanId (required)
            * @param postSelfLoansLoanIdRequest  (required)
            * @param command command (optional)
        * @return Call&lt;PostSelfLoansLoanIdResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/self/loans/{loanId}")
    Call<PostSelfLoansLoanIdResponse> stateTransitions2(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Body PostSelfLoansLoanIdRequest postSelfLoansLoanIdRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve Loan Details Template
        * Retrieves Loan Details Template  This is a convenience resource. It can be useful when building maintenance user interface screens for client applications. The template data returned consists of any or all of:  Field Defaults Allowed description Lists  Example Requests:  self/loans/template?templateType&#x3D;individual&amp;clientId&#x3D;1   self/loans/template?templateType&#x3D;individual&amp;clientId&#x3D;1&amp;productId&#x3D;1
            * @param clientId clientId (optional)
            * @param productId productId (optional)
            * @param templateType templateType (optional)
        * @return Call&lt;GetSelfLoansTemplateResponse&gt;
        */
    @GET("v1/self/loans/template")
    Call<GetSelfLoansTemplateResponse> template17(@retrofit2.http.Query("clientId") Long clientId, @retrofit2.http.Query("productId") Long productId, @retrofit2.http.Query("templateType") String templateType, @HeaderMap Map<String, String> headers);


}
