package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.CapitalizedIncomeDetails;
import org.apache.fineract.client.models.LoanAmortizationAllocationResponse;
import org.apache.fineract.client.models.LoanCapitalizedIncomeData;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface LoanCapitalizedIncomeApi {
    /**
    * Fetch the Capitalized Income related informations
    * 
        * @param loanId loanId (required)
    * @return Call&lt;List&lt;CapitalizedIncomeDetails&gt;&gt;
    */
    @GET("v1/loans/{loanId}/capitalized-incomes")
    Call<List<CapitalizedIncomeDetails>> fetchCapitalizedIncomeDetails(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * Get the amortization details of Capitalized Income for a loan by external ID
    * 
        * @param loanExternalId loanExternalId (required)
    * @return Call&lt;List&lt;CapitalizedIncomeDetails&gt;&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/capitalized-incomes")
    Call<List<CapitalizedIncomeDetails>> fetchCapitalizedIncomeDetailsByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId);

    /**
    * Fetch the Capitalized Income related informations
    * 
        * @param loanId loanId (required)
    * @return Call&lt;LoanCapitalizedIncomeData&gt;
        * @deprecated
    */
        @Deprecated
    @GET("v1/loans/{loanId}/deferredincome")
    Call<LoanCapitalizedIncomeData> fetchLoanCapitalizedIncomeData(@retrofit2.http.Path("loanId") Long loanId);

    /**
    * Get the amortization details of Capitalized Income for a loan by external ID
    * 
        * @param loanExternalId loanExternalId (required)
    * @return Call&lt;LoanCapitalizedIncomeData&gt;
        * @deprecated
    */
        @Deprecated
    @GET("v1/loans/external-id/{loanExternalId}/deferredincome")
    Call<LoanCapitalizedIncomeData> fetchLoanCapitalizedIncomeDataByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId);

    /**
    * Retrieve a capitalized income allocation data
    * Retrieves capitalized income allocation data according to the Loan external ID and Loan Transaction external IDExample Requests:  /loans/external-id/1/capitalized-incomes/1   /loans/external-id/1/capitalized-incomes/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
        * @param loanExternalId loanExternalId (required)
        * @param loanTransactionExternalId loanTransactionExternalId (required)
    * @return Call&lt;LoanAmortizationAllocationResponse&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/capitalized-incomes/external-id/{loanTransactionExternalId}")
    Call<LoanAmortizationAllocationResponse> getCapitalizedIncomeAllocationDataByExternalIds(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanTransactionExternalId") String loanTransactionExternalId);

    /**
    * Retrieve a capitalized income allocation data
    * Retrieves capitalized income allocation data according to the Loan external ID and Loan Transaction IDExample Requests:  /loans/external-id/1/capitalized-incomes/1   /loans/external-id/1/capitalized-incomes/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
        * @param loanExternalId loanExternalId (required)
        * @param loanTransactionId loanTransactionId (required)
    * @return Call&lt;LoanAmortizationAllocationResponse&gt;
    */
    @GET("v1/loans/external-id/{loanExternalId}/capitalized-incomes/{loanTransactionId}")
    Call<LoanAmortizationAllocationResponse> getCapitalizedIncomeAllocationDataByLoanExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanTransactionId") Long loanTransactionId);

    /**
    * Retrieve a capitalized income allocation data
    * Retrieves capitalized income allocation data according to the Loan ID and Loan Transaction external IDExample Requests:  /loans/1/capitalized-incomes/external-id/1   /loans/1/capitalized-incomes/external-id/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
        * @param loanId loanId (required)
        * @param loanTransactionExternalId loanTransactionExternalId (required)
    * @return Call&lt;LoanAmortizationAllocationResponse&gt;
    */
    @GET("v1/loans/{loanId}/capitalized-incomes/external-id/{loanTransactionExternalId}")
    Call<LoanAmortizationAllocationResponse> getCapitalizedIncomeAllocationDataByTransactionExternalId(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanTransactionExternalId") String loanTransactionExternalId);

    /**
    * Retrieve a capitalized income allocation data
    * Retrieves capitalized income allocation data according to the Loan ID and Loan Transaction IDExample Requests:  /loans/1/capitalized-incomes/1   /loans/1/capitalized-incomes/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
        * @param loanId loanId (required)
        * @param loanTransactionId loanTransactionId (required)
    * @return Call&lt;LoanAmortizationAllocationResponse&gt;
    */
    @GET("v1/loans/{loanId}/capitalized-incomes/{loanTransactionId}")
    Call<LoanAmortizationAllocationResponse> retrieveCapitalizedIncomeAllocationData(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanTransactionId") Long loanTransactionId);



        /**
        * Fetch the Capitalized Income related informations
        * 
            * @param loanId loanId (required)
        * @return Call&lt;List&lt;CapitalizedIncomeDetails&gt;&gt;
        */
    @GET("v1/loans/{loanId}/capitalized-incomes")
    Call<List<CapitalizedIncomeDetails>> fetchCapitalizedIncomeDetails(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * Get the amortization details of Capitalized Income for a loan by external ID
        * 
            * @param loanExternalId loanExternalId (required)
        * @return Call&lt;List&lt;CapitalizedIncomeDetails&gt;&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/capitalized-incomes")
    Call<List<CapitalizedIncomeDetails>> fetchCapitalizedIncomeDetailsByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Fetch the Capitalized Income related informations
        * 
            * @param loanId loanId (required)
        * @return Call&lt;LoanCapitalizedIncomeData&gt;
            * @deprecated
        */
            @Deprecated
    @GET("v1/loans/{loanId}/deferredincome")
    Call<LoanCapitalizedIncomeData> fetchLoanCapitalizedIncomeData(@retrofit2.http.Path("loanId") Long loanId, @HeaderMap Map<String, String> headers);

        /**
        * Get the amortization details of Capitalized Income for a loan by external ID
        * 
            * @param loanExternalId loanExternalId (required)
        * @return Call&lt;LoanCapitalizedIncomeData&gt;
            * @deprecated
        */
            @Deprecated
    @GET("v1/loans/external-id/{loanExternalId}/deferredincome")
    Call<LoanCapitalizedIncomeData> fetchLoanCapitalizedIncomeDataByExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a capitalized income allocation data
        * Retrieves capitalized income allocation data according to the Loan external ID and Loan Transaction external IDExample Requests:  /loans/external-id/1/capitalized-incomes/1   /loans/external-id/1/capitalized-incomes/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
            * @param loanExternalId loanExternalId (required)
            * @param loanTransactionExternalId loanTransactionExternalId (required)
        * @return Call&lt;LoanAmortizationAllocationResponse&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/capitalized-incomes/external-id/{loanTransactionExternalId}")
    Call<LoanAmortizationAllocationResponse> getCapitalizedIncomeAllocationDataByExternalIds(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanTransactionExternalId") String loanTransactionExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a capitalized income allocation data
        * Retrieves capitalized income allocation data according to the Loan external ID and Loan Transaction IDExample Requests:  /loans/external-id/1/capitalized-incomes/1   /loans/external-id/1/capitalized-incomes/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
            * @param loanExternalId loanExternalId (required)
            * @param loanTransactionId loanTransactionId (required)
        * @return Call&lt;LoanAmortizationAllocationResponse&gt;
        */
    @GET("v1/loans/external-id/{loanExternalId}/capitalized-incomes/{loanTransactionId}")
    Call<LoanAmortizationAllocationResponse> getCapitalizedIncomeAllocationDataByLoanExternalId(@retrofit2.http.Path("loanExternalId") String loanExternalId, @retrofit2.http.Path("loanTransactionId") Long loanTransactionId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a capitalized income allocation data
        * Retrieves capitalized income allocation data according to the Loan ID and Loan Transaction external IDExample Requests:  /loans/1/capitalized-incomes/external-id/1   /loans/1/capitalized-incomes/external-id/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
            * @param loanId loanId (required)
            * @param loanTransactionExternalId loanTransactionExternalId (required)
        * @return Call&lt;LoanAmortizationAllocationResponse&gt;
        */
    @GET("v1/loans/{loanId}/capitalized-incomes/external-id/{loanTransactionExternalId}")
    Call<LoanAmortizationAllocationResponse> getCapitalizedIncomeAllocationDataByTransactionExternalId(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanTransactionExternalId") String loanTransactionExternalId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a capitalized income allocation data
        * Retrieves capitalized income allocation data according to the Loan ID and Loan Transaction IDExample Requests:  /loans/1/capitalized-incomes/1   /loans/1/capitalized-incomes/1?fields&#x3D;baseLoanTransaction,unrecognizedAmount
            * @param loanId loanId (required)
            * @param loanTransactionId loanTransactionId (required)
        * @return Call&lt;LoanAmortizationAllocationResponse&gt;
        */
    @GET("v1/loans/{loanId}/capitalized-incomes/{loanTransactionId}")
    Call<LoanAmortizationAllocationResponse> retrieveCapitalizedIncomeAllocationData(@retrofit2.http.Path("loanId") Long loanId, @retrofit2.http.Path("loanTransactionId") Long loanTransactionId, @HeaderMap Map<String, String> headers);


}
