package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.DeleteDelinquencyBucketResponse;
import org.apache.fineract.client.models.DeleteDelinquencyRangeResponse;
import org.apache.fineract.client.models.DelinquencyBucketData;
import org.apache.fineract.client.models.DelinquencyBucketRequest;
import org.apache.fineract.client.models.DelinquencyRangeData;
import org.apache.fineract.client.models.DelinquencyRangeRequest;
import org.apache.fineract.client.models.PostDelinquencyBucketResponse;
import org.apache.fineract.client.models.PostDelinquencyRangeResponse;
import org.apache.fineract.client.models.PutDelinquencyBucketResponse;
import org.apache.fineract.client.models.PutDelinquencyRangeResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface DelinquencyRangeAndBucketsManagementApi {
    /**
    * Create Delinquency Bucket
    * 
        * @param delinquencyBucketRequest  (required)
    * @return Call&lt;PostDelinquencyBucketResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/delinquency/buckets")
    Call<PostDelinquencyBucketResponse> createDelinquencyBucket(@retrofit2.http.Body DelinquencyBucketRequest delinquencyBucketRequest);

    /**
    * Create Delinquency Range
    * 
        * @param delinquencyRangeRequest  (required)
    * @return Call&lt;PostDelinquencyRangeResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/delinquency/ranges")
    Call<PostDelinquencyRangeResponse> createDelinquencyRange(@retrofit2.http.Body DelinquencyRangeRequest delinquencyRangeRequest);

    /**
    * Delete Delinquency Bucket based on the Id
    * 
        * @param delinquencyBucketId delinquencyBucketId (required)
    * @return Call&lt;DeleteDelinquencyBucketResponse&gt;
    */
    @DELETE("v1/delinquency/buckets/{delinquencyBucketId}")
    Call<DeleteDelinquencyBucketResponse> deleteDelinquencyBucket(@retrofit2.http.Path("delinquencyBucketId") Long delinquencyBucketId);

    /**
    * Update Delinquency Range based on the Id
    * 
        * @param delinquencyRangeId delinquencyRangeId (required)
    * @return Call&lt;DeleteDelinquencyRangeResponse&gt;
    */
    @DELETE("v1/delinquency/ranges/{delinquencyRangeId}")
    Call<DeleteDelinquencyRangeResponse> deleteDelinquencyRange(@retrofit2.http.Path("delinquencyRangeId") Long delinquencyRangeId);

    /**
    * Retrieve a specific Delinquency Bucket based on the Id
    * 
        * @param delinquencyBucketId delinquencyBucketId (required)
    * @return Call&lt;DelinquencyBucketData&gt;
    */
    @GET("v1/delinquency/buckets/{delinquencyBucketId}")
    Call<DelinquencyBucketData> getDelinquencyBucket(@retrofit2.http.Path("delinquencyBucketId") Long delinquencyBucketId);

    /**
    * List all Delinquency Buckets
    * 
    * @return Call&lt;List&lt;DelinquencyBucketData&gt;&gt;
    */
    @GET("v1/delinquency/buckets")
    Call<List<DelinquencyBucketData>> getDelinquencyBuckets();

    /**
    * Retrieve a specific Delinquency Range based on the Id
    * 
        * @param delinquencyRangeId delinquencyRangeId (required)
    * @return Call&lt;DelinquencyRangeData&gt;
    */
    @GET("v1/delinquency/ranges/{delinquencyRangeId}")
    Call<DelinquencyRangeData> getDelinquencyRange(@retrofit2.http.Path("delinquencyRangeId") Long delinquencyRangeId);

    /**
    * List all Delinquency Ranges
    * 
    * @return Call&lt;List&lt;DelinquencyRangeData&gt;&gt;
    */
    @GET("v1/delinquency/ranges")
    Call<List<DelinquencyRangeData>> getDelinquencyRanges();

    /**
    * Update Delinquency Bucket based on the Id
    * 
        * @param delinquencyBucketId delinquencyBucketId (required)
        * @param delinquencyBucketRequest  (required)
    * @return Call&lt;PutDelinquencyBucketResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/delinquency/buckets/{delinquencyBucketId}")
    Call<PutDelinquencyBucketResponse> updateDelinquencyBucket(@retrofit2.http.Path("delinquencyBucketId") Long delinquencyBucketId, @retrofit2.http.Body DelinquencyBucketRequest delinquencyBucketRequest);

    /**
    * Update Delinquency Range based on the Id
    * 
        * @param delinquencyRangeId delinquencyRangeId (required)
        * @param delinquencyRangeRequest  (required)
    * @return Call&lt;PutDelinquencyRangeResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/delinquency/ranges/{delinquencyRangeId}")
    Call<PutDelinquencyRangeResponse> updateDelinquencyRange(@retrofit2.http.Path("delinquencyRangeId") Long delinquencyRangeId, @retrofit2.http.Body DelinquencyRangeRequest delinquencyRangeRequest);



        /**
        * Create Delinquency Bucket
        * 
            * @param delinquencyBucketRequest  (required)
        * @return Call&lt;PostDelinquencyBucketResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/delinquency/buckets")
    Call<PostDelinquencyBucketResponse> createDelinquencyBucket(@retrofit2.http.Body DelinquencyBucketRequest delinquencyBucketRequest, @HeaderMap Map<String, String> headers);

        /**
        * Create Delinquency Range
        * 
            * @param delinquencyRangeRequest  (required)
        * @return Call&lt;PostDelinquencyRangeResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/delinquency/ranges")
    Call<PostDelinquencyRangeResponse> createDelinquencyRange(@retrofit2.http.Body DelinquencyRangeRequest delinquencyRangeRequest, @HeaderMap Map<String, String> headers);

        /**
        * Delete Delinquency Bucket based on the Id
        * 
            * @param delinquencyBucketId delinquencyBucketId (required)
        * @return Call&lt;DeleteDelinquencyBucketResponse&gt;
        */
    @DELETE("v1/delinquency/buckets/{delinquencyBucketId}")
    Call<DeleteDelinquencyBucketResponse> deleteDelinquencyBucket(@retrofit2.http.Path("delinquencyBucketId") Long delinquencyBucketId, @HeaderMap Map<String, String> headers);

        /**
        * Update Delinquency Range based on the Id
        * 
            * @param delinquencyRangeId delinquencyRangeId (required)
        * @return Call&lt;DeleteDelinquencyRangeResponse&gt;
        */
    @DELETE("v1/delinquency/ranges/{delinquencyRangeId}")
    Call<DeleteDelinquencyRangeResponse> deleteDelinquencyRange(@retrofit2.http.Path("delinquencyRangeId") Long delinquencyRangeId, @HeaderMap Map<String, String> headers);

        /**
        * Retrieve a specific Delinquency Bucket based on the Id
        * 
            * @param delinquencyBucketId delinquencyBucketId (required)
        * @return Call&lt;DelinquencyBucketData&gt;
        */
    @GET("v1/delinquency/buckets/{delinquencyBucketId}")
    Call<DelinquencyBucketData> getDelinquencyBucket(@retrofit2.http.Path("delinquencyBucketId") Long delinquencyBucketId, @HeaderMap Map<String, String> headers);

        /**
        * List all Delinquency Buckets
        * 
        * @return Call&lt;List&lt;DelinquencyBucketData&gt;&gt;
        */
    @GET("v1/delinquency/buckets")
    Call<List<DelinquencyBucketData>> getDelinquencyBuckets(@HeaderMap Map<String, String> headers);

        /**
        * Retrieve a specific Delinquency Range based on the Id
        * 
            * @param delinquencyRangeId delinquencyRangeId (required)
        * @return Call&lt;DelinquencyRangeData&gt;
        */
    @GET("v1/delinquency/ranges/{delinquencyRangeId}")
    Call<DelinquencyRangeData> getDelinquencyRange(@retrofit2.http.Path("delinquencyRangeId") Long delinquencyRangeId, @HeaderMap Map<String, String> headers);

        /**
        * List all Delinquency Ranges
        * 
        * @return Call&lt;List&lt;DelinquencyRangeData&gt;&gt;
        */
    @GET("v1/delinquency/ranges")
    Call<List<DelinquencyRangeData>> getDelinquencyRanges(@HeaderMap Map<String, String> headers);

        /**
        * Update Delinquency Bucket based on the Id
        * 
            * @param delinquencyBucketId delinquencyBucketId (required)
            * @param delinquencyBucketRequest  (required)
        * @return Call&lt;PutDelinquencyBucketResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/delinquency/buckets/{delinquencyBucketId}")
    Call<PutDelinquencyBucketResponse> updateDelinquencyBucket(@retrofit2.http.Path("delinquencyBucketId") Long delinquencyBucketId, @retrofit2.http.Body DelinquencyBucketRequest delinquencyBucketRequest, @HeaderMap Map<String, String> headers);

        /**
        * Update Delinquency Range based on the Id
        * 
            * @param delinquencyRangeId delinquencyRangeId (required)
            * @param delinquencyRangeRequest  (required)
        * @return Call&lt;PutDelinquencyRangeResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/delinquency/ranges/{delinquencyRangeId}")
    Call<PutDelinquencyRangeResponse> updateDelinquencyRange(@retrofit2.http.Path("delinquencyRangeId") Long delinquencyRangeId, @retrofit2.http.Body DelinquencyRangeRequest delinquencyRangeRequest, @HeaderMap Map<String, String> headers);


}
