package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.ClientFamilyMemberRequest;
import org.apache.fineract.client.models.ClientFamilyMembersData;
import org.apache.fineract.client.models.CommandProcessingResult;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ClientFamilyMemberApi {
    /**
    * 
    * 
        * @param clientId  (required)
        * @param clientFamilyMemberRequest  (optional)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/clients/{clientId}/familymembers")
    Call<CommandProcessingResult> addClientFamilyMembers(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Body ClientFamilyMemberRequest clientFamilyMemberRequest);

    /**
    * 
    * 
        * @param familyMemberId  (required)
        * @param clientId clientId (required)
    * @return Call&lt;CommandProcessingResult&gt;
    */
    @DELETE("v1/clients/{clientId}/familymembers/{familyMemberId}")
    Call<CommandProcessingResult> deleteClientFamilyMembers(@retrofit2.http.Path("familyMemberId") Long familyMemberId, @retrofit2.http.Path("clientId") Long clientId);

    /**
    * 
    * 
        * @param familyMemberId  (required)
        * @param clientId clientId (required)
    * @return Call&lt;ClientFamilyMembersData&gt;
    */
    @GET("v1/clients/{clientId}/familymembers/{familyMemberId}")
    Call<ClientFamilyMembersData> getFamilyMember(@retrofit2.http.Path("familyMemberId") Long familyMemberId, @retrofit2.http.Path("clientId") Long clientId);

    /**
    * 
    * 
        * @param clientId  (required)
    * @return Call&lt;List&lt;ClientFamilyMembersData&gt;&gt;
    */
    @GET("v1/clients/{clientId}/familymembers")
    Call<List<ClientFamilyMembersData>> getFamilyMembers(@retrofit2.http.Path("clientId") Long clientId);

    /**
    * 
    * 
        * @param clientId  (required)
    * @return Call&lt;ClientFamilyMembersData&gt;
    */
    @GET("v1/clients/{clientId}/familymembers/template")
    Call<ClientFamilyMembersData> getTemplate2(@retrofit2.http.Path("clientId") Long clientId);

    /**
    * 
    * 
        * @param familyMemberId  (required)
        * @param clientId clientId (required)
        * @param clientFamilyMemberRequest  (optional)
    * @return Call&lt;CommandProcessingResult&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/clients/{clientId}/familymembers/{familyMemberId}")
    Call<CommandProcessingResult> updateClientFamilyMembers(@retrofit2.http.Path("familyMemberId") Long familyMemberId, @retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Body ClientFamilyMemberRequest clientFamilyMemberRequest);


        /**
        * 
        * 
            * @param clientId  (required)
            * @param clientFamilyMemberRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/clients/{clientId}/familymembers")
    Call<CommandProcessingResult> addClientFamilyMembers(@retrofit2.http.Path("clientId") Long clientId);
        /**
        * 
        * 
            * @param familyMemberId  (required)
            * @param clientId clientId (required)
            * @param clientFamilyMemberRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/clients/{clientId}/familymembers/{familyMemberId}")
    Call<CommandProcessingResult> updateClientFamilyMembers(@retrofit2.http.Path("familyMemberId") Long familyMemberId, @retrofit2.http.Path("clientId") Long clientId);

        /**
        * 
        * 
            * @param clientId  (required)
            * @param clientFamilyMemberRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/clients/{clientId}/familymembers")
    Call<CommandProcessingResult> addClientFamilyMembers(@retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Body ClientFamilyMemberRequest clientFamilyMemberRequest, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param familyMemberId  (required)
            * @param clientId clientId (required)
        * @return Call&lt;CommandProcessingResult&gt;
        */
    @DELETE("v1/clients/{clientId}/familymembers/{familyMemberId}")
    Call<CommandProcessingResult> deleteClientFamilyMembers(@retrofit2.http.Path("familyMemberId") Long familyMemberId, @retrofit2.http.Path("clientId") Long clientId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param familyMemberId  (required)
            * @param clientId clientId (required)
        * @return Call&lt;ClientFamilyMembersData&gt;
        */
    @GET("v1/clients/{clientId}/familymembers/{familyMemberId}")
    Call<ClientFamilyMembersData> getFamilyMember(@retrofit2.http.Path("familyMemberId") Long familyMemberId, @retrofit2.http.Path("clientId") Long clientId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param clientId  (required)
        * @return Call&lt;List&lt;ClientFamilyMembersData&gt;&gt;
        */
    @GET("v1/clients/{clientId}/familymembers")
    Call<List<ClientFamilyMembersData>> getFamilyMembers(@retrofit2.http.Path("clientId") Long clientId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param clientId  (required)
        * @return Call&lt;ClientFamilyMembersData&gt;
        */
    @GET("v1/clients/{clientId}/familymembers/template")
    Call<ClientFamilyMembersData> getTemplate2(@retrofit2.http.Path("clientId") Long clientId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param familyMemberId  (required)
            * @param clientId clientId (required)
            * @param clientFamilyMemberRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/clients/{clientId}/familymembers/{familyMemberId}")
    Call<CommandProcessingResult> updateClientFamilyMembers(@retrofit2.http.Path("familyMemberId") Long familyMemberId, @retrofit2.http.Path("clientId") Long clientId, @retrofit2.http.Body ClientFamilyMemberRequest clientFamilyMemberRequest, @HeaderMap Map<String, String> headers);


        /**
        * 
        * 
            * @param clientId  (required)
            * @param clientFamilyMemberRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/clients/{clientId}/familymembers")
    Call<CommandProcessingResult> addClientFamilyMembers(@retrofit2.http.Path("clientId") Long clientId, @HeaderMap Map<String, String> headers);
        /**
        * 
        * 
            * @param familyMemberId  (required)
            * @param clientId clientId (required)
            * @param clientFamilyMemberRequest  (optional)
        * @return Call&lt;CommandProcessingResult&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/clients/{clientId}/familymembers/{familyMemberId}")
    Call<CommandProcessingResult> updateClientFamilyMembers(@retrofit2.http.Path("familyMemberId") Long familyMemberId, @retrofit2.http.Path("clientId") Long clientId, @HeaderMap Map<String, String> headers);
}
