/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.client.models.CurrencyData;
import org.apache.fineract.client.models.MonetaryCurrency;
import org.apache.fineract.client.models.Money;

/**
 * LoanProductRelatedDetail
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class LoanProductRelatedDetail {
  public static final String SERIALIZED_NAME_ALLOW_PARTIAL_PERIOD_INTEREST_CALCULATION = "allowPartialPeriodInterestCalculation";
  @SerializedName(SERIALIZED_NAME_ALLOW_PARTIAL_PERIOD_INTEREST_CALCULATION)
  private Boolean allowPartialPeriodInterestCalculation;

  /**
   * Gets or Sets amortizationMethod
   */
  @JsonAdapter(AmortizationMethodEnum.Adapter.class)
  public enum AmortizationMethodEnum {
    EQUAL_PRINCIPAL("EQUAL_PRINCIPAL"),
    
    EQUAL_INSTALLMENTS("EQUAL_INSTALLMENTS"),
    
    INVALID("INVALID");

    private String value;

    AmortizationMethodEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AmortizationMethodEnum fromValue(String value) {
      for (AmortizationMethodEnum b : AmortizationMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<AmortizationMethodEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AmortizationMethodEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AmortizationMethodEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AmortizationMethodEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_AMORTIZATION_METHOD = "amortizationMethod";
  @SerializedName(SERIALIZED_NAME_AMORTIZATION_METHOD)
  private AmortizationMethodEnum amortizationMethod;

  public static final String SERIALIZED_NAME_ANNUAL_NOMINAL_INTEREST_RATE = "annualNominalInterestRate";
  @SerializedName(SERIALIZED_NAME_ANNUAL_NOMINAL_INTEREST_RATE)
  private BigDecimal annualNominalInterestRate;

  /**
   * Gets or Sets buyDownFeeCalculationType
   */
  @JsonAdapter(BuyDownFeeCalculationTypeEnum.Adapter.class)
  public enum BuyDownFeeCalculationTypeEnum {
    FLAT("FLAT");

    private String value;

    BuyDownFeeCalculationTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static BuyDownFeeCalculationTypeEnum fromValue(String value) {
      for (BuyDownFeeCalculationTypeEnum b : BuyDownFeeCalculationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<BuyDownFeeCalculationTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final BuyDownFeeCalculationTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public BuyDownFeeCalculationTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return BuyDownFeeCalculationTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE = "buyDownFeeCalculationType";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE)
  private BuyDownFeeCalculationTypeEnum buyDownFeeCalculationType;

  /**
   * Gets or Sets buyDownFeeIncomeType
   */
  @JsonAdapter(BuyDownFeeIncomeTypeEnum.Adapter.class)
  public enum BuyDownFeeIncomeTypeEnum {
    FEE("FEE"),
    
    INTEREST("INTEREST");

    private String value;

    BuyDownFeeIncomeTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static BuyDownFeeIncomeTypeEnum fromValue(String value) {
      for (BuyDownFeeIncomeTypeEnum b : BuyDownFeeIncomeTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<BuyDownFeeIncomeTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final BuyDownFeeIncomeTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public BuyDownFeeIncomeTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return BuyDownFeeIncomeTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE = "buyDownFeeIncomeType";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE)
  private BuyDownFeeIncomeTypeEnum buyDownFeeIncomeType;

  /**
   * Gets or Sets buyDownFeeStrategy
   */
  @JsonAdapter(BuyDownFeeStrategyEnum.Adapter.class)
  public enum BuyDownFeeStrategyEnum {
    EQUAL_AMORTIZATION("EQUAL_AMORTIZATION");

    private String value;

    BuyDownFeeStrategyEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static BuyDownFeeStrategyEnum fromValue(String value) {
      for (BuyDownFeeStrategyEnum b : BuyDownFeeStrategyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<BuyDownFeeStrategyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final BuyDownFeeStrategyEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public BuyDownFeeStrategyEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return BuyDownFeeStrategyEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY = "buyDownFeeStrategy";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY)
  private BuyDownFeeStrategyEnum buyDownFeeStrategy;

  /**
   * Gets or Sets capitalizedIncomeCalculationType
   */
  @JsonAdapter(CapitalizedIncomeCalculationTypeEnum.Adapter.class)
  public enum CapitalizedIncomeCalculationTypeEnum {
    FLAT("FLAT");

    private String value;

    CapitalizedIncomeCalculationTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CapitalizedIncomeCalculationTypeEnum fromValue(String value) {
      for (CapitalizedIncomeCalculationTypeEnum b : CapitalizedIncomeCalculationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<CapitalizedIncomeCalculationTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CapitalizedIncomeCalculationTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CapitalizedIncomeCalculationTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return CapitalizedIncomeCalculationTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE = "capitalizedIncomeCalculationType";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE)
  private CapitalizedIncomeCalculationTypeEnum capitalizedIncomeCalculationType;

  /**
   * Gets or Sets capitalizedIncomeStrategy
   */
  @JsonAdapter(CapitalizedIncomeStrategyEnum.Adapter.class)
  public enum CapitalizedIncomeStrategyEnum {
    EQUAL_AMORTIZATION("EQUAL_AMORTIZATION");

    private String value;

    CapitalizedIncomeStrategyEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CapitalizedIncomeStrategyEnum fromValue(String value) {
      for (CapitalizedIncomeStrategyEnum b : CapitalizedIncomeStrategyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<CapitalizedIncomeStrategyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CapitalizedIncomeStrategyEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CapitalizedIncomeStrategyEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return CapitalizedIncomeStrategyEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY = "capitalizedIncomeStrategy";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY)
  private CapitalizedIncomeStrategyEnum capitalizedIncomeStrategy;

  /**
   * Gets or Sets capitalizedIncomeType
   */
  @JsonAdapter(CapitalizedIncomeTypeEnum.Adapter.class)
  public enum CapitalizedIncomeTypeEnum {
    FEE("FEE"),
    
    INTEREST("INTEREST");

    private String value;

    CapitalizedIncomeTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CapitalizedIncomeTypeEnum fromValue(String value) {
      for (CapitalizedIncomeTypeEnum b : CapitalizedIncomeTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<CapitalizedIncomeTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CapitalizedIncomeTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CapitalizedIncomeTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return CapitalizedIncomeTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE = "capitalizedIncomeType";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE)
  private CapitalizedIncomeTypeEnum capitalizedIncomeType;

  /**
   * Gets or Sets chargeOffBehaviour
   */
  @JsonAdapter(ChargeOffBehaviourEnum.Adapter.class)
  public enum ChargeOffBehaviourEnum {
    REGULAR("REGULAR"),
    
    ZERO_INTEREST("ZERO_INTEREST"),
    
    ACCELERATE_MATURITY("ACCELERATE_MATURITY");

    private String value;

    ChargeOffBehaviourEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ChargeOffBehaviourEnum fromValue(String value) {
      for (ChargeOffBehaviourEnum b : ChargeOffBehaviourEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<ChargeOffBehaviourEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ChargeOffBehaviourEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ChargeOffBehaviourEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return ChargeOffBehaviourEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR = "chargeOffBehaviour";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR)
  private ChargeOffBehaviourEnum chargeOffBehaviour;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private MonetaryCurrency currency;

  public static final String SERIALIZED_NAME_CURRENCY_DATA = "currencyData";
  @SerializedName(SERIALIZED_NAME_CURRENCY_DATA)
  private CurrencyData currencyData;

  public static final String SERIALIZED_NAME_DAYS_IN_MONTH_TYPE = "daysInMonthType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_MONTH_TYPE)
  private Integer daysInMonthType;

  /**
   * Gets or Sets daysInYearCustomStrategy
   */
  @JsonAdapter(DaysInYearCustomStrategyEnum.Adapter.class)
  public enum DaysInYearCustomStrategyEnum {
    FULL_LEAP_YEAR("FULL_LEAP_YEAR"),
    
    FEB_29_PERIOD_ONLY("FEB_29_PERIOD_ONLY");

    private String value;

    DaysInYearCustomStrategyEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DaysInYearCustomStrategyEnum fromValue(String value) {
      for (DaysInYearCustomStrategyEnum b : DaysInYearCustomStrategyEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<DaysInYearCustomStrategyEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DaysInYearCustomStrategyEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DaysInYearCustomStrategyEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DaysInYearCustomStrategyEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_CUSTOM_STRATEGY = "daysInYearCustomStrategy";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_CUSTOM_STRATEGY)
  private DaysInYearCustomStrategyEnum daysInYearCustomStrategy;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_TYPE = "daysInYearType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_TYPE)
  private Integer daysInYearType;

  public static final String SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT = "disbursedAmountPercentageForDownPayment";
  @SerializedName(SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT)
  private BigDecimal disbursedAmountPercentageForDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_ACCRUAL_ACTIVITY_POSTING = "enableAccrualActivityPosting";
  @SerializedName(SERIALIZED_NAME_ENABLE_ACCRUAL_ACTIVITY_POSTING)
  private Boolean enableAccrualActivityPosting;

  public static final String SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT = "enableAutoRepaymentForDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT)
  private Boolean enableAutoRepaymentForDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_BUY_DOWN_FEE = "enableBuyDownFee";
  @SerializedName(SERIALIZED_NAME_ENABLE_BUY_DOWN_FEE)
  private Boolean enableBuyDownFee;

  public static final String SERIALIZED_NAME_ENABLE_DOWN_PAYMENT = "enableDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_DOWN_PAYMENT)
  private Boolean enableDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_INCOME_CAPITALIZATION = "enableIncomeCapitalization";
  @SerializedName(SERIALIZED_NAME_ENABLE_INCOME_CAPITALIZATION)
  private Boolean enableIncomeCapitalization;

  public static final String SERIALIZED_NAME_EQUAL_AMORTIZATION = "equalAmortization";
  @SerializedName(SERIALIZED_NAME_EQUAL_AMORTIZATION)
  private Boolean equalAmortization;

  public static final String SERIALIZED_NAME_FIXED_LENGTH = "fixedLength";
  @SerializedName(SERIALIZED_NAME_FIXED_LENGTH)
  private Integer fixedLength;

  public static final String SERIALIZED_NAME_GRACE_ON_ARREARS_AGEING = "graceOnArrearsAgeing";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_ARREARS_AGEING)
  private Integer graceOnArrearsAgeing;

  public static final String SERIALIZED_NAME_GRACE_ON_INTEREST_CHARGED = "graceOnInterestCharged";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_INTEREST_CHARGED)
  private Integer graceOnInterestCharged;

  public static final String SERIALIZED_NAME_GRACE_ON_INTEREST_PAYMENT = "graceOnInterestPayment";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_INTEREST_PAYMENT)
  private Integer graceOnInterestPayment;

  public static final String SERIALIZED_NAME_GRACE_ON_PRINCIPAL_PAYMENT = "graceOnPrincipalPayment";
  @SerializedName(SERIALIZED_NAME_GRACE_ON_PRINCIPAL_PAYMENT)
  private Integer graceOnPrincipalPayment;

  public static final String SERIALIZED_NAME_IN_ARREARS_TOLERANCE = "inArrearsTolerance";
  @SerializedName(SERIALIZED_NAME_IN_ARREARS_TOLERANCE)
  private Money inArrearsTolerance;

  public static final String SERIALIZED_NAME_INSTALLMENT_AMOUNT_IN_MULTIPLES_OF = "installmentAmountInMultiplesOf";
  @SerializedName(SERIALIZED_NAME_INSTALLMENT_AMOUNT_IN_MULTIPLES_OF)
  private Integer installmentAmountInMultiplesOf;

  /**
   * Gets or Sets interestCalculationPeriodMethod
   */
  @JsonAdapter(InterestCalculationPeriodMethodEnum.Adapter.class)
  public enum InterestCalculationPeriodMethodEnum {
    DAILY("DAILY"),
    
    SAME_AS_REPAYMENT_PERIOD("SAME_AS_REPAYMENT_PERIOD"),
    
    INVALID("INVALID");

    private String value;

    InterestCalculationPeriodMethodEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static InterestCalculationPeriodMethodEnum fromValue(String value) {
      for (InterestCalculationPeriodMethodEnum b : InterestCalculationPeriodMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<InterestCalculationPeriodMethodEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final InterestCalculationPeriodMethodEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public InterestCalculationPeriodMethodEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return InterestCalculationPeriodMethodEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_METHOD = "interestCalculationPeriodMethod";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_METHOD)
  private InterestCalculationPeriodMethodEnum interestCalculationPeriodMethod;

  /**
   * Gets or Sets interestMethod
   */
  @JsonAdapter(InterestMethodEnum.Adapter.class)
  public enum InterestMethodEnum {
    DECLINING_BALANCE("DECLINING_BALANCE"),
    
    FLAT("FLAT"),
    
    INVALID("INVALID");

    private String value;

    InterestMethodEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static InterestMethodEnum fromValue(String value) {
      for (InterestMethodEnum b : InterestMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<InterestMethodEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final InterestMethodEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public InterestMethodEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return InterestMethodEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_INTEREST_METHOD = "interestMethod";
  @SerializedName(SERIALIZED_NAME_INTEREST_METHOD)
  private InterestMethodEnum interestMethod;

  /**
   * Gets or Sets interestPeriodFrequencyType
   */
  @JsonAdapter(InterestPeriodFrequencyTypeEnum.Adapter.class)
  public enum InterestPeriodFrequencyTypeEnum {
    DAYS("DAYS"),
    
    WEEKS("WEEKS"),
    
    MONTHS("MONTHS"),
    
    YEARS("YEARS"),
    
    WHOLE_TERM("WHOLE_TERM"),
    
    INVALID("INVALID");

    private String value;

    InterestPeriodFrequencyTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static InterestPeriodFrequencyTypeEnum fromValue(String value) {
      for (InterestPeriodFrequencyTypeEnum b : InterestPeriodFrequencyTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<InterestPeriodFrequencyTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final InterestPeriodFrequencyTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public InterestPeriodFrequencyTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return InterestPeriodFrequencyTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_INTEREST_PERIOD_FREQUENCY_TYPE = "interestPeriodFrequencyType";
  @SerializedName(SERIALIZED_NAME_INTEREST_PERIOD_FREQUENCY_TYPE)
  private InterestPeriodFrequencyTypeEnum interestPeriodFrequencyType;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_ENABLED = "interestRecalculationEnabled";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_ENABLED)
  private Boolean interestRecalculationEnabled;

  public static final String SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE = "interestRecognitionOnDisbursementDate";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE)
  private Boolean interestRecognitionOnDisbursementDate;

  /**
   * Gets or Sets loanScheduleProcessingType
   */
  @JsonAdapter(LoanScheduleProcessingTypeEnum.Adapter.class)
  public enum LoanScheduleProcessingTypeEnum {
    HORIZONTAL("HORIZONTAL"),
    
    VERTICAL("VERTICAL");

    private String value;

    LoanScheduleProcessingTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static LoanScheduleProcessingTypeEnum fromValue(String value) {
      for (LoanScheduleProcessingTypeEnum b : LoanScheduleProcessingTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<LoanScheduleProcessingTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final LoanScheduleProcessingTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public LoanScheduleProcessingTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return LoanScheduleProcessingTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE = "loanScheduleProcessingType";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE)
  private LoanScheduleProcessingTypeEnum loanScheduleProcessingType;

  /**
   * Gets or Sets loanScheduleType
   */
  @JsonAdapter(LoanScheduleTypeEnum.Adapter.class)
  public enum LoanScheduleTypeEnum {
    CUMULATIVE("CUMULATIVE"),
    
    PROGRESSIVE("PROGRESSIVE");

    private String value;

    LoanScheduleTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static LoanScheduleTypeEnum fromValue(String value) {
      for (LoanScheduleTypeEnum b : LoanScheduleTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<LoanScheduleTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final LoanScheduleTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public LoanScheduleTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return LoanScheduleTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_TYPE = "loanScheduleType";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_TYPE)
  private LoanScheduleTypeEnum loanScheduleType;

  public static final String SERIALIZED_NAME_MERCHANT_BUY_DOWN_FEE = "merchantBuyDownFee";
  @SerializedName(SERIALIZED_NAME_MERCHANT_BUY_DOWN_FEE)
  private Boolean merchantBuyDownFee;

  public static final String SERIALIZED_NAME_NOMINAL_INTEREST_RATE_PER_PERIOD = "nominalInterestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_NOMINAL_INTEREST_RATE_PER_PERIOD)
  private BigDecimal nominalInterestRatePerPeriod;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENTS = "numberOfRepayments";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENTS)
  private Integer numberOfRepayments;

  public static final String SERIALIZED_NAME_PRINCIPAL = "principal";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL)
  private Money principal;

  public static final String SERIALIZED_NAME_RECURRING_MORATORIUM_ON_PRINCIPAL_PERIODS = "recurringMoratoriumOnPrincipalPeriods";
  @SerializedName(SERIALIZED_NAME_RECURRING_MORATORIUM_ON_PRINCIPAL_PERIODS)
  private Integer recurringMoratoriumOnPrincipalPeriods;

  public static final String SERIALIZED_NAME_REPAY_EVERY = "repayEvery";
  @SerializedName(SERIALIZED_NAME_REPAY_EVERY)
  private Integer repayEvery;

  /**
   * Gets or Sets repaymentPeriodFrequencyType
   */
  @JsonAdapter(RepaymentPeriodFrequencyTypeEnum.Adapter.class)
  public enum RepaymentPeriodFrequencyTypeEnum {
    DAYS("DAYS"),
    
    WEEKS("WEEKS"),
    
    MONTHS("MONTHS"),
    
    YEARS("YEARS"),
    
    WHOLE_TERM("WHOLE_TERM"),
    
    INVALID("INVALID");

    private String value;

    RepaymentPeriodFrequencyTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static RepaymentPeriodFrequencyTypeEnum fromValue(String value) {
      for (RepaymentPeriodFrequencyTypeEnum b : RepaymentPeriodFrequencyTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<RepaymentPeriodFrequencyTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final RepaymentPeriodFrequencyTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public RepaymentPeriodFrequencyTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return RepaymentPeriodFrequencyTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_REPAYMENT_PERIOD_FREQUENCY_TYPE = "repaymentPeriodFrequencyType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_PERIOD_FREQUENCY_TYPE)
  private RepaymentPeriodFrequencyTypeEnum repaymentPeriodFrequencyType;

  /**
   * Gets or Sets supportedInterestRefundTypes
   */
  @JsonAdapter(SupportedInterestRefundTypesEnum.Adapter.class)
  public enum SupportedInterestRefundTypesEnum {
    MERCHANT_ISSUED_REFUND("MERCHANT_ISSUED_REFUND"),
    
    PAYOUT_REFUND("PAYOUT_REFUND");

    private String value;

    SupportedInterestRefundTypesEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static SupportedInterestRefundTypesEnum fromValue(String value) {
      for (SupportedInterestRefundTypesEnum b : SupportedInterestRefundTypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<SupportedInterestRefundTypesEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final SupportedInterestRefundTypesEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public SupportedInterestRefundTypesEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return SupportedInterestRefundTypesEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES = "supportedInterestRefundTypes";
  @SerializedName(SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES)
  private List<SupportedInterestRefundTypesEnum> supportedInterestRefundTypes;

  public LoanProductRelatedDetail() {
  }

  public LoanProductRelatedDetail allowPartialPeriodInterestCalculation(Boolean allowPartialPeriodInterestCalculation) {
    
    this.allowPartialPeriodInterestCalculation = allowPartialPeriodInterestCalculation;
    return this;
  }

  /**
   * Get allowPartialPeriodInterestCalculation
   * @return allowPartialPeriodInterestCalculation
   */
  @javax.annotation.Nullable

  public Boolean getAllowPartialPeriodInterestCalculation() {
    return allowPartialPeriodInterestCalculation;
  }


  public void setAllowPartialPeriodInterestCalculation(Boolean allowPartialPeriodInterestCalculation) {
    this.allowPartialPeriodInterestCalculation = allowPartialPeriodInterestCalculation;
  }

  public LoanProductRelatedDetail amortizationMethod(AmortizationMethodEnum amortizationMethod) {
    
    this.amortizationMethod = amortizationMethod;
    return this;
  }

  /**
   * Get amortizationMethod
   * @return amortizationMethod
   */
  @javax.annotation.Nullable

  public AmortizationMethodEnum getAmortizationMethod() {
    return amortizationMethod;
  }


  public void setAmortizationMethod(AmortizationMethodEnum amortizationMethod) {
    this.amortizationMethod = amortizationMethod;
  }

  public LoanProductRelatedDetail annualNominalInterestRate(BigDecimal annualNominalInterestRate) {
    
    this.annualNominalInterestRate = annualNominalInterestRate;
    return this;
  }

  /**
   * Get annualNominalInterestRate
   * @return annualNominalInterestRate
   */
  @javax.annotation.Nullable

  public BigDecimal getAnnualNominalInterestRate() {
    return annualNominalInterestRate;
  }


  public void setAnnualNominalInterestRate(BigDecimal annualNominalInterestRate) {
    this.annualNominalInterestRate = annualNominalInterestRate;
  }

  public LoanProductRelatedDetail buyDownFeeCalculationType(BuyDownFeeCalculationTypeEnum buyDownFeeCalculationType) {
    
    this.buyDownFeeCalculationType = buyDownFeeCalculationType;
    return this;
  }

  /**
   * Get buyDownFeeCalculationType
   * @return buyDownFeeCalculationType
   */
  @javax.annotation.Nullable

  public BuyDownFeeCalculationTypeEnum getBuyDownFeeCalculationType() {
    return buyDownFeeCalculationType;
  }


  public void setBuyDownFeeCalculationType(BuyDownFeeCalculationTypeEnum buyDownFeeCalculationType) {
    this.buyDownFeeCalculationType = buyDownFeeCalculationType;
  }

  public LoanProductRelatedDetail buyDownFeeIncomeType(BuyDownFeeIncomeTypeEnum buyDownFeeIncomeType) {
    
    this.buyDownFeeIncomeType = buyDownFeeIncomeType;
    return this;
  }

  /**
   * Get buyDownFeeIncomeType
   * @return buyDownFeeIncomeType
   */
  @javax.annotation.Nullable

  public BuyDownFeeIncomeTypeEnum getBuyDownFeeIncomeType() {
    return buyDownFeeIncomeType;
  }


  public void setBuyDownFeeIncomeType(BuyDownFeeIncomeTypeEnum buyDownFeeIncomeType) {
    this.buyDownFeeIncomeType = buyDownFeeIncomeType;
  }

  public LoanProductRelatedDetail buyDownFeeStrategy(BuyDownFeeStrategyEnum buyDownFeeStrategy) {
    
    this.buyDownFeeStrategy = buyDownFeeStrategy;
    return this;
  }

  /**
   * Get buyDownFeeStrategy
   * @return buyDownFeeStrategy
   */
  @javax.annotation.Nullable

  public BuyDownFeeStrategyEnum getBuyDownFeeStrategy() {
    return buyDownFeeStrategy;
  }


  public void setBuyDownFeeStrategy(BuyDownFeeStrategyEnum buyDownFeeStrategy) {
    this.buyDownFeeStrategy = buyDownFeeStrategy;
  }

  public LoanProductRelatedDetail capitalizedIncomeCalculationType(CapitalizedIncomeCalculationTypeEnum capitalizedIncomeCalculationType) {
    
    this.capitalizedIncomeCalculationType = capitalizedIncomeCalculationType;
    return this;
  }

  /**
   * Get capitalizedIncomeCalculationType
   * @return capitalizedIncomeCalculationType
   */
  @javax.annotation.Nullable

  public CapitalizedIncomeCalculationTypeEnum getCapitalizedIncomeCalculationType() {
    return capitalizedIncomeCalculationType;
  }


  public void setCapitalizedIncomeCalculationType(CapitalizedIncomeCalculationTypeEnum capitalizedIncomeCalculationType) {
    this.capitalizedIncomeCalculationType = capitalizedIncomeCalculationType;
  }

  public LoanProductRelatedDetail capitalizedIncomeStrategy(CapitalizedIncomeStrategyEnum capitalizedIncomeStrategy) {
    
    this.capitalizedIncomeStrategy = capitalizedIncomeStrategy;
    return this;
  }

  /**
   * Get capitalizedIncomeStrategy
   * @return capitalizedIncomeStrategy
   */
  @javax.annotation.Nullable

  public CapitalizedIncomeStrategyEnum getCapitalizedIncomeStrategy() {
    return capitalizedIncomeStrategy;
  }


  public void setCapitalizedIncomeStrategy(CapitalizedIncomeStrategyEnum capitalizedIncomeStrategy) {
    this.capitalizedIncomeStrategy = capitalizedIncomeStrategy;
  }

  public LoanProductRelatedDetail capitalizedIncomeType(CapitalizedIncomeTypeEnum capitalizedIncomeType) {
    
    this.capitalizedIncomeType = capitalizedIncomeType;
    return this;
  }

  /**
   * Get capitalizedIncomeType
   * @return capitalizedIncomeType
   */
  @javax.annotation.Nullable

  public CapitalizedIncomeTypeEnum getCapitalizedIncomeType() {
    return capitalizedIncomeType;
  }


  public void setCapitalizedIncomeType(CapitalizedIncomeTypeEnum capitalizedIncomeType) {
    this.capitalizedIncomeType = capitalizedIncomeType;
  }

  public LoanProductRelatedDetail chargeOffBehaviour(ChargeOffBehaviourEnum chargeOffBehaviour) {
    
    this.chargeOffBehaviour = chargeOffBehaviour;
    return this;
  }

  /**
   * Get chargeOffBehaviour
   * @return chargeOffBehaviour
   */
  @javax.annotation.Nullable

  public ChargeOffBehaviourEnum getChargeOffBehaviour() {
    return chargeOffBehaviour;
  }


  public void setChargeOffBehaviour(ChargeOffBehaviourEnum chargeOffBehaviour) {
    this.chargeOffBehaviour = chargeOffBehaviour;
  }

  public LoanProductRelatedDetail currency(MonetaryCurrency currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public MonetaryCurrency getCurrency() {
    return currency;
  }


  public void setCurrency(MonetaryCurrency currency) {
    this.currency = currency;
  }

  public LoanProductRelatedDetail currencyData(CurrencyData currencyData) {
    
    this.currencyData = currencyData;
    return this;
  }

  /**
   * Get currencyData
   * @return currencyData
   */
  @javax.annotation.Nullable

  public CurrencyData getCurrencyData() {
    return currencyData;
  }


  public void setCurrencyData(CurrencyData currencyData) {
    this.currencyData = currencyData;
  }

  public LoanProductRelatedDetail daysInMonthType(Integer daysInMonthType) {
    
    this.daysInMonthType = daysInMonthType;
    return this;
  }

  /**
   * Get daysInMonthType
   * @return daysInMonthType
   */
  @javax.annotation.Nullable

  public Integer getDaysInMonthType() {
    return daysInMonthType;
  }


  public void setDaysInMonthType(Integer daysInMonthType) {
    this.daysInMonthType = daysInMonthType;
  }

  public LoanProductRelatedDetail daysInYearCustomStrategy(DaysInYearCustomStrategyEnum daysInYearCustomStrategy) {
    
    this.daysInYearCustomStrategy = daysInYearCustomStrategy;
    return this;
  }

  /**
   * Get daysInYearCustomStrategy
   * @return daysInYearCustomStrategy
   */
  @javax.annotation.Nullable

  public DaysInYearCustomStrategyEnum getDaysInYearCustomStrategy() {
    return daysInYearCustomStrategy;
  }


  public void setDaysInYearCustomStrategy(DaysInYearCustomStrategyEnum daysInYearCustomStrategy) {
    this.daysInYearCustomStrategy = daysInYearCustomStrategy;
  }

  public LoanProductRelatedDetail daysInYearType(Integer daysInYearType) {
    
    this.daysInYearType = daysInYearType;
    return this;
  }

  /**
   * Get daysInYearType
   * @return daysInYearType
   */
  @javax.annotation.Nullable

  public Integer getDaysInYearType() {
    return daysInYearType;
  }


  public void setDaysInYearType(Integer daysInYearType) {
    this.daysInYearType = daysInYearType;
  }

  public LoanProductRelatedDetail disbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
    return this;
  }

  /**
   * Get disbursedAmountPercentageForDownPayment
   * @return disbursedAmountPercentageForDownPayment
   */
  @javax.annotation.Nullable

  public BigDecimal getDisbursedAmountPercentageForDownPayment() {
    return disbursedAmountPercentageForDownPayment;
  }


  public void setDisbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
  }

  public LoanProductRelatedDetail enableAccrualActivityPosting(Boolean enableAccrualActivityPosting) {
    
    this.enableAccrualActivityPosting = enableAccrualActivityPosting;
    return this;
  }

  /**
   * Get enableAccrualActivityPosting
   * @return enableAccrualActivityPosting
   */
  @javax.annotation.Nullable

  public Boolean getEnableAccrualActivityPosting() {
    return enableAccrualActivityPosting;
  }


  public void setEnableAccrualActivityPosting(Boolean enableAccrualActivityPosting) {
    this.enableAccrualActivityPosting = enableAccrualActivityPosting;
  }

  public LoanProductRelatedDetail enableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
    return this;
  }

  /**
   * Get enableAutoRepaymentForDownPayment
   * @return enableAutoRepaymentForDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableAutoRepaymentForDownPayment() {
    return enableAutoRepaymentForDownPayment;
  }


  public void setEnableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
  }

  public LoanProductRelatedDetail enableBuyDownFee(Boolean enableBuyDownFee) {
    
    this.enableBuyDownFee = enableBuyDownFee;
    return this;
  }

  /**
   * Get enableBuyDownFee
   * @return enableBuyDownFee
   */
  @javax.annotation.Nullable

  public Boolean getEnableBuyDownFee() {
    return enableBuyDownFee;
  }


  public void setEnableBuyDownFee(Boolean enableBuyDownFee) {
    this.enableBuyDownFee = enableBuyDownFee;
  }

  public LoanProductRelatedDetail enableDownPayment(Boolean enableDownPayment) {
    
    this.enableDownPayment = enableDownPayment;
    return this;
  }

  /**
   * Get enableDownPayment
   * @return enableDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableDownPayment() {
    return enableDownPayment;
  }


  public void setEnableDownPayment(Boolean enableDownPayment) {
    this.enableDownPayment = enableDownPayment;
  }

  public LoanProductRelatedDetail enableIncomeCapitalization(Boolean enableIncomeCapitalization) {
    
    this.enableIncomeCapitalization = enableIncomeCapitalization;
    return this;
  }

  /**
   * Get enableIncomeCapitalization
   * @return enableIncomeCapitalization
   */
  @javax.annotation.Nullable

  public Boolean getEnableIncomeCapitalization() {
    return enableIncomeCapitalization;
  }


  public void setEnableIncomeCapitalization(Boolean enableIncomeCapitalization) {
    this.enableIncomeCapitalization = enableIncomeCapitalization;
  }

  public LoanProductRelatedDetail equalAmortization(Boolean equalAmortization) {
    
    this.equalAmortization = equalAmortization;
    return this;
  }

  /**
   * Get equalAmortization
   * @return equalAmortization
   */
  @javax.annotation.Nullable

  public Boolean getEqualAmortization() {
    return equalAmortization;
  }


  public void setEqualAmortization(Boolean equalAmortization) {
    this.equalAmortization = equalAmortization;
  }

  public LoanProductRelatedDetail fixedLength(Integer fixedLength) {
    
    this.fixedLength = fixedLength;
    return this;
  }

  /**
   * Get fixedLength
   * @return fixedLength
   */
  @javax.annotation.Nullable

  public Integer getFixedLength() {
    return fixedLength;
  }


  public void setFixedLength(Integer fixedLength) {
    this.fixedLength = fixedLength;
  }

  public LoanProductRelatedDetail graceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
    
    this.graceOnArrearsAgeing = graceOnArrearsAgeing;
    return this;
  }

  /**
   * Get graceOnArrearsAgeing
   * @return graceOnArrearsAgeing
   */
  @javax.annotation.Nullable

  public Integer getGraceOnArrearsAgeing() {
    return graceOnArrearsAgeing;
  }


  public void setGraceOnArrearsAgeing(Integer graceOnArrearsAgeing) {
    this.graceOnArrearsAgeing = graceOnArrearsAgeing;
  }

  public LoanProductRelatedDetail graceOnInterestCharged(Integer graceOnInterestCharged) {
    
    this.graceOnInterestCharged = graceOnInterestCharged;
    return this;
  }

  /**
   * Get graceOnInterestCharged
   * @return graceOnInterestCharged
   */
  @javax.annotation.Nullable

  public Integer getGraceOnInterestCharged() {
    return graceOnInterestCharged;
  }


  public void setGraceOnInterestCharged(Integer graceOnInterestCharged) {
    this.graceOnInterestCharged = graceOnInterestCharged;
  }

  public LoanProductRelatedDetail graceOnInterestPayment(Integer graceOnInterestPayment) {
    
    this.graceOnInterestPayment = graceOnInterestPayment;
    return this;
  }

  /**
   * Get graceOnInterestPayment
   * @return graceOnInterestPayment
   */
  @javax.annotation.Nullable

  public Integer getGraceOnInterestPayment() {
    return graceOnInterestPayment;
  }


  public void setGraceOnInterestPayment(Integer graceOnInterestPayment) {
    this.graceOnInterestPayment = graceOnInterestPayment;
  }

  public LoanProductRelatedDetail graceOnPrincipalPayment(Integer graceOnPrincipalPayment) {
    
    this.graceOnPrincipalPayment = graceOnPrincipalPayment;
    return this;
  }

  /**
   * Get graceOnPrincipalPayment
   * @return graceOnPrincipalPayment
   */
  @javax.annotation.Nullable

  public Integer getGraceOnPrincipalPayment() {
    return graceOnPrincipalPayment;
  }


  public void setGraceOnPrincipalPayment(Integer graceOnPrincipalPayment) {
    this.graceOnPrincipalPayment = graceOnPrincipalPayment;
  }

  public LoanProductRelatedDetail inArrearsTolerance(Money inArrearsTolerance) {
    
    this.inArrearsTolerance = inArrearsTolerance;
    return this;
  }

  /**
   * Get inArrearsTolerance
   * @return inArrearsTolerance
   */
  @javax.annotation.Nullable

  public Money getInArrearsTolerance() {
    return inArrearsTolerance;
  }


  public void setInArrearsTolerance(Money inArrearsTolerance) {
    this.inArrearsTolerance = inArrearsTolerance;
  }

  public LoanProductRelatedDetail installmentAmountInMultiplesOf(Integer installmentAmountInMultiplesOf) {
    
    this.installmentAmountInMultiplesOf = installmentAmountInMultiplesOf;
    return this;
  }

  /**
   * Get installmentAmountInMultiplesOf
   * @return installmentAmountInMultiplesOf
   */
  @javax.annotation.Nullable

  public Integer getInstallmentAmountInMultiplesOf() {
    return installmentAmountInMultiplesOf;
  }


  public void setInstallmentAmountInMultiplesOf(Integer installmentAmountInMultiplesOf) {
    this.installmentAmountInMultiplesOf = installmentAmountInMultiplesOf;
  }

  public LoanProductRelatedDetail interestCalculationPeriodMethod(InterestCalculationPeriodMethodEnum interestCalculationPeriodMethod) {
    
    this.interestCalculationPeriodMethod = interestCalculationPeriodMethod;
    return this;
  }

  /**
   * Get interestCalculationPeriodMethod
   * @return interestCalculationPeriodMethod
   */
  @javax.annotation.Nullable

  public InterestCalculationPeriodMethodEnum getInterestCalculationPeriodMethod() {
    return interestCalculationPeriodMethod;
  }


  public void setInterestCalculationPeriodMethod(InterestCalculationPeriodMethodEnum interestCalculationPeriodMethod) {
    this.interestCalculationPeriodMethod = interestCalculationPeriodMethod;
  }

  public LoanProductRelatedDetail interestMethod(InterestMethodEnum interestMethod) {
    
    this.interestMethod = interestMethod;
    return this;
  }

  /**
   * Get interestMethod
   * @return interestMethod
   */
  @javax.annotation.Nullable

  public InterestMethodEnum getInterestMethod() {
    return interestMethod;
  }


  public void setInterestMethod(InterestMethodEnum interestMethod) {
    this.interestMethod = interestMethod;
  }

  public LoanProductRelatedDetail interestPeriodFrequencyType(InterestPeriodFrequencyTypeEnum interestPeriodFrequencyType) {
    
    this.interestPeriodFrequencyType = interestPeriodFrequencyType;
    return this;
  }

  /**
   * Get interestPeriodFrequencyType
   * @return interestPeriodFrequencyType
   */
  @javax.annotation.Nullable

  public InterestPeriodFrequencyTypeEnum getInterestPeriodFrequencyType() {
    return interestPeriodFrequencyType;
  }


  public void setInterestPeriodFrequencyType(InterestPeriodFrequencyTypeEnum interestPeriodFrequencyType) {
    this.interestPeriodFrequencyType = interestPeriodFrequencyType;
  }

  public LoanProductRelatedDetail interestRecalculationEnabled(Boolean interestRecalculationEnabled) {
    
    this.interestRecalculationEnabled = interestRecalculationEnabled;
    return this;
  }

  /**
   * Get interestRecalculationEnabled
   * @return interestRecalculationEnabled
   */
  @javax.annotation.Nullable

  public Boolean getInterestRecalculationEnabled() {
    return interestRecalculationEnabled;
  }


  public void setInterestRecalculationEnabled(Boolean interestRecalculationEnabled) {
    this.interestRecalculationEnabled = interestRecalculationEnabled;
  }

  public LoanProductRelatedDetail interestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
    return this;
  }

  /**
   * Get interestRecognitionOnDisbursementDate
   * @return interestRecognitionOnDisbursementDate
   */
  @javax.annotation.Nullable

  public Boolean getInterestRecognitionOnDisbursementDate() {
    return interestRecognitionOnDisbursementDate;
  }


  public void setInterestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
  }

  public LoanProductRelatedDetail loanScheduleProcessingType(LoanScheduleProcessingTypeEnum loanScheduleProcessingType) {
    
    this.loanScheduleProcessingType = loanScheduleProcessingType;
    return this;
  }

  /**
   * Get loanScheduleProcessingType
   * @return loanScheduleProcessingType
   */
  @javax.annotation.Nullable

  public LoanScheduleProcessingTypeEnum getLoanScheduleProcessingType() {
    return loanScheduleProcessingType;
  }


  public void setLoanScheduleProcessingType(LoanScheduleProcessingTypeEnum loanScheduleProcessingType) {
    this.loanScheduleProcessingType = loanScheduleProcessingType;
  }

  public LoanProductRelatedDetail loanScheduleType(LoanScheduleTypeEnum loanScheduleType) {
    
    this.loanScheduleType = loanScheduleType;
    return this;
  }

  /**
   * Get loanScheduleType
   * @return loanScheduleType
   */
  @javax.annotation.Nullable

  public LoanScheduleTypeEnum getLoanScheduleType() {
    return loanScheduleType;
  }


  public void setLoanScheduleType(LoanScheduleTypeEnum loanScheduleType) {
    this.loanScheduleType = loanScheduleType;
  }

  public LoanProductRelatedDetail merchantBuyDownFee(Boolean merchantBuyDownFee) {
    
    this.merchantBuyDownFee = merchantBuyDownFee;
    return this;
  }

  /**
   * Get merchantBuyDownFee
   * @return merchantBuyDownFee
   */
  @javax.annotation.Nullable

  public Boolean getMerchantBuyDownFee() {
    return merchantBuyDownFee;
  }


  public void setMerchantBuyDownFee(Boolean merchantBuyDownFee) {
    this.merchantBuyDownFee = merchantBuyDownFee;
  }

  public LoanProductRelatedDetail nominalInterestRatePerPeriod(BigDecimal nominalInterestRatePerPeriod) {
    
    this.nominalInterestRatePerPeriod = nominalInterestRatePerPeriod;
    return this;
  }

  /**
   * Get nominalInterestRatePerPeriod
   * @return nominalInterestRatePerPeriod
   */
  @javax.annotation.Nullable

  public BigDecimal getNominalInterestRatePerPeriod() {
    return nominalInterestRatePerPeriod;
  }


  public void setNominalInterestRatePerPeriod(BigDecimal nominalInterestRatePerPeriod) {
    this.nominalInterestRatePerPeriod = nominalInterestRatePerPeriod;
  }

  public LoanProductRelatedDetail numberOfRepayments(Integer numberOfRepayments) {
    
    this.numberOfRepayments = numberOfRepayments;
    return this;
  }

  /**
   * Get numberOfRepayments
   * @return numberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getNumberOfRepayments() {
    return numberOfRepayments;
  }


  public void setNumberOfRepayments(Integer numberOfRepayments) {
    this.numberOfRepayments = numberOfRepayments;
  }

  public LoanProductRelatedDetail principal(Money principal) {
    
    this.principal = principal;
    return this;
  }

  /**
   * Get principal
   * @return principal
   */
  @javax.annotation.Nullable

  public Money getPrincipal() {
    return principal;
  }


  public void setPrincipal(Money principal) {
    this.principal = principal;
  }

  public LoanProductRelatedDetail recurringMoratoriumOnPrincipalPeriods(Integer recurringMoratoriumOnPrincipalPeriods) {
    
    this.recurringMoratoriumOnPrincipalPeriods = recurringMoratoriumOnPrincipalPeriods;
    return this;
  }

  /**
   * Get recurringMoratoriumOnPrincipalPeriods
   * @return recurringMoratoriumOnPrincipalPeriods
   */
  @javax.annotation.Nullable

  public Integer getRecurringMoratoriumOnPrincipalPeriods() {
    return recurringMoratoriumOnPrincipalPeriods;
  }


  public void setRecurringMoratoriumOnPrincipalPeriods(Integer recurringMoratoriumOnPrincipalPeriods) {
    this.recurringMoratoriumOnPrincipalPeriods = recurringMoratoriumOnPrincipalPeriods;
  }

  public LoanProductRelatedDetail repayEvery(Integer repayEvery) {
    
    this.repayEvery = repayEvery;
    return this;
  }

  /**
   * Get repayEvery
   * @return repayEvery
   */
  @javax.annotation.Nullable

  public Integer getRepayEvery() {
    return repayEvery;
  }


  public void setRepayEvery(Integer repayEvery) {
    this.repayEvery = repayEvery;
  }

  public LoanProductRelatedDetail repaymentPeriodFrequencyType(RepaymentPeriodFrequencyTypeEnum repaymentPeriodFrequencyType) {
    
    this.repaymentPeriodFrequencyType = repaymentPeriodFrequencyType;
    return this;
  }

  /**
   * Get repaymentPeriodFrequencyType
   * @return repaymentPeriodFrequencyType
   */
  @javax.annotation.Nullable

  public RepaymentPeriodFrequencyTypeEnum getRepaymentPeriodFrequencyType() {
    return repaymentPeriodFrequencyType;
  }


  public void setRepaymentPeriodFrequencyType(RepaymentPeriodFrequencyTypeEnum repaymentPeriodFrequencyType) {
    this.repaymentPeriodFrequencyType = repaymentPeriodFrequencyType;
  }

  public LoanProductRelatedDetail supportedInterestRefundTypes(List<SupportedInterestRefundTypesEnum> supportedInterestRefundTypes) {
    
    this.supportedInterestRefundTypes = supportedInterestRefundTypes;
    return this;
  }

  public LoanProductRelatedDetail addSupportedInterestRefundTypesItem(SupportedInterestRefundTypesEnum supportedInterestRefundTypesItem) {
    if (this.supportedInterestRefundTypes == null) {
      this.supportedInterestRefundTypes = new ArrayList<>();
    }
    this.supportedInterestRefundTypes.add(supportedInterestRefundTypesItem);
    return this;
  }

  /**
   * Get supportedInterestRefundTypes
   * @return supportedInterestRefundTypes
   */
  @javax.annotation.Nullable

  public List<SupportedInterestRefundTypesEnum> getSupportedInterestRefundTypes() {
    return supportedInterestRefundTypes;
  }


  public void setSupportedInterestRefundTypes(List<SupportedInterestRefundTypesEnum> supportedInterestRefundTypes) {
    this.supportedInterestRefundTypes = supportedInterestRefundTypes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoanProductRelatedDetail loanProductRelatedDetail = (LoanProductRelatedDetail) o;
    return Objects.equals(this.allowPartialPeriodInterestCalculation, loanProductRelatedDetail.allowPartialPeriodInterestCalculation) &&
        Objects.equals(this.amortizationMethod, loanProductRelatedDetail.amortizationMethod) &&
        Objects.equals(this.annualNominalInterestRate, loanProductRelatedDetail.annualNominalInterestRate) &&
        Objects.equals(this.buyDownFeeCalculationType, loanProductRelatedDetail.buyDownFeeCalculationType) &&
        Objects.equals(this.buyDownFeeIncomeType, loanProductRelatedDetail.buyDownFeeIncomeType) &&
        Objects.equals(this.buyDownFeeStrategy, loanProductRelatedDetail.buyDownFeeStrategy) &&
        Objects.equals(this.capitalizedIncomeCalculationType, loanProductRelatedDetail.capitalizedIncomeCalculationType) &&
        Objects.equals(this.capitalizedIncomeStrategy, loanProductRelatedDetail.capitalizedIncomeStrategy) &&
        Objects.equals(this.capitalizedIncomeType, loanProductRelatedDetail.capitalizedIncomeType) &&
        Objects.equals(this.chargeOffBehaviour, loanProductRelatedDetail.chargeOffBehaviour) &&
        Objects.equals(this.currency, loanProductRelatedDetail.currency) &&
        Objects.equals(this.currencyData, loanProductRelatedDetail.currencyData) &&
        Objects.equals(this.daysInMonthType, loanProductRelatedDetail.daysInMonthType) &&
        Objects.equals(this.daysInYearCustomStrategy, loanProductRelatedDetail.daysInYearCustomStrategy) &&
        Objects.equals(this.daysInYearType, loanProductRelatedDetail.daysInYearType) &&
        Objects.equals(this.disbursedAmountPercentageForDownPayment, loanProductRelatedDetail.disbursedAmountPercentageForDownPayment) &&
        Objects.equals(this.enableAccrualActivityPosting, loanProductRelatedDetail.enableAccrualActivityPosting) &&
        Objects.equals(this.enableAutoRepaymentForDownPayment, loanProductRelatedDetail.enableAutoRepaymentForDownPayment) &&
        Objects.equals(this.enableBuyDownFee, loanProductRelatedDetail.enableBuyDownFee) &&
        Objects.equals(this.enableDownPayment, loanProductRelatedDetail.enableDownPayment) &&
        Objects.equals(this.enableIncomeCapitalization, loanProductRelatedDetail.enableIncomeCapitalization) &&
        Objects.equals(this.equalAmortization, loanProductRelatedDetail.equalAmortization) &&
        Objects.equals(this.fixedLength, loanProductRelatedDetail.fixedLength) &&
        Objects.equals(this.graceOnArrearsAgeing, loanProductRelatedDetail.graceOnArrearsAgeing) &&
        Objects.equals(this.graceOnInterestCharged, loanProductRelatedDetail.graceOnInterestCharged) &&
        Objects.equals(this.graceOnInterestPayment, loanProductRelatedDetail.graceOnInterestPayment) &&
        Objects.equals(this.graceOnPrincipalPayment, loanProductRelatedDetail.graceOnPrincipalPayment) &&
        Objects.equals(this.inArrearsTolerance, loanProductRelatedDetail.inArrearsTolerance) &&
        Objects.equals(this.installmentAmountInMultiplesOf, loanProductRelatedDetail.installmentAmountInMultiplesOf) &&
        Objects.equals(this.interestCalculationPeriodMethod, loanProductRelatedDetail.interestCalculationPeriodMethod) &&
        Objects.equals(this.interestMethod, loanProductRelatedDetail.interestMethod) &&
        Objects.equals(this.interestPeriodFrequencyType, loanProductRelatedDetail.interestPeriodFrequencyType) &&
        Objects.equals(this.interestRecalculationEnabled, loanProductRelatedDetail.interestRecalculationEnabled) &&
        Objects.equals(this.interestRecognitionOnDisbursementDate, loanProductRelatedDetail.interestRecognitionOnDisbursementDate) &&
        Objects.equals(this.loanScheduleProcessingType, loanProductRelatedDetail.loanScheduleProcessingType) &&
        Objects.equals(this.loanScheduleType, loanProductRelatedDetail.loanScheduleType) &&
        Objects.equals(this.merchantBuyDownFee, loanProductRelatedDetail.merchantBuyDownFee) &&
        Objects.equals(this.nominalInterestRatePerPeriod, loanProductRelatedDetail.nominalInterestRatePerPeriod) &&
        Objects.equals(this.numberOfRepayments, loanProductRelatedDetail.numberOfRepayments) &&
        Objects.equals(this.principal, loanProductRelatedDetail.principal) &&
        Objects.equals(this.recurringMoratoriumOnPrincipalPeriods, loanProductRelatedDetail.recurringMoratoriumOnPrincipalPeriods) &&
        Objects.equals(this.repayEvery, loanProductRelatedDetail.repayEvery) &&
        Objects.equals(this.repaymentPeriodFrequencyType, loanProductRelatedDetail.repaymentPeriodFrequencyType) &&
        Objects.equals(this.supportedInterestRefundTypes, loanProductRelatedDetail.supportedInterestRefundTypes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(allowPartialPeriodInterestCalculation, amortizationMethod, annualNominalInterestRate, buyDownFeeCalculationType, buyDownFeeIncomeType, buyDownFeeStrategy, capitalizedIncomeCalculationType, capitalizedIncomeStrategy, capitalizedIncomeType, chargeOffBehaviour, currency, currencyData, daysInMonthType, daysInYearCustomStrategy, daysInYearType, disbursedAmountPercentageForDownPayment, enableAccrualActivityPosting, enableAutoRepaymentForDownPayment, enableBuyDownFee, enableDownPayment, enableIncomeCapitalization, equalAmortization, fixedLength, graceOnArrearsAgeing, graceOnInterestCharged, graceOnInterestPayment, graceOnPrincipalPayment, inArrearsTolerance, installmentAmountInMultiplesOf, interestCalculationPeriodMethod, interestMethod, interestPeriodFrequencyType, interestRecalculationEnabled, interestRecognitionOnDisbursementDate, loanScheduleProcessingType, loanScheduleType, merchantBuyDownFee, nominalInterestRatePerPeriod, numberOfRepayments, principal, recurringMoratoriumOnPrincipalPeriods, repayEvery, repaymentPeriodFrequencyType, supportedInterestRefundTypes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoanProductRelatedDetail {\n");
    sb.append("    allowPartialPeriodInterestCalculation: ").append(toIndentedString(allowPartialPeriodInterestCalculation)).append("\n");
    sb.append("    amortizationMethod: ").append(toIndentedString(amortizationMethod)).append("\n");
    sb.append("    annualNominalInterestRate: ").append(toIndentedString(annualNominalInterestRate)).append("\n");
    sb.append("    buyDownFeeCalculationType: ").append(toIndentedString(buyDownFeeCalculationType)).append("\n");
    sb.append("    buyDownFeeIncomeType: ").append(toIndentedString(buyDownFeeIncomeType)).append("\n");
    sb.append("    buyDownFeeStrategy: ").append(toIndentedString(buyDownFeeStrategy)).append("\n");
    sb.append("    capitalizedIncomeCalculationType: ").append(toIndentedString(capitalizedIncomeCalculationType)).append("\n");
    sb.append("    capitalizedIncomeStrategy: ").append(toIndentedString(capitalizedIncomeStrategy)).append("\n");
    sb.append("    capitalizedIncomeType: ").append(toIndentedString(capitalizedIncomeType)).append("\n");
    sb.append("    chargeOffBehaviour: ").append(toIndentedString(chargeOffBehaviour)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    currencyData: ").append(toIndentedString(currencyData)).append("\n");
    sb.append("    daysInMonthType: ").append(toIndentedString(daysInMonthType)).append("\n");
    sb.append("    daysInYearCustomStrategy: ").append(toIndentedString(daysInYearCustomStrategy)).append("\n");
    sb.append("    daysInYearType: ").append(toIndentedString(daysInYearType)).append("\n");
    sb.append("    disbursedAmountPercentageForDownPayment: ").append(toIndentedString(disbursedAmountPercentageForDownPayment)).append("\n");
    sb.append("    enableAccrualActivityPosting: ").append(toIndentedString(enableAccrualActivityPosting)).append("\n");
    sb.append("    enableAutoRepaymentForDownPayment: ").append(toIndentedString(enableAutoRepaymentForDownPayment)).append("\n");
    sb.append("    enableBuyDownFee: ").append(toIndentedString(enableBuyDownFee)).append("\n");
    sb.append("    enableDownPayment: ").append(toIndentedString(enableDownPayment)).append("\n");
    sb.append("    enableIncomeCapitalization: ").append(toIndentedString(enableIncomeCapitalization)).append("\n");
    sb.append("    equalAmortization: ").append(toIndentedString(equalAmortization)).append("\n");
    sb.append("    fixedLength: ").append(toIndentedString(fixedLength)).append("\n");
    sb.append("    graceOnArrearsAgeing: ").append(toIndentedString(graceOnArrearsAgeing)).append("\n");
    sb.append("    graceOnInterestCharged: ").append(toIndentedString(graceOnInterestCharged)).append("\n");
    sb.append("    graceOnInterestPayment: ").append(toIndentedString(graceOnInterestPayment)).append("\n");
    sb.append("    graceOnPrincipalPayment: ").append(toIndentedString(graceOnPrincipalPayment)).append("\n");
    sb.append("    inArrearsTolerance: ").append(toIndentedString(inArrearsTolerance)).append("\n");
    sb.append("    installmentAmountInMultiplesOf: ").append(toIndentedString(installmentAmountInMultiplesOf)).append("\n");
    sb.append("    interestCalculationPeriodMethod: ").append(toIndentedString(interestCalculationPeriodMethod)).append("\n");
    sb.append("    interestMethod: ").append(toIndentedString(interestMethod)).append("\n");
    sb.append("    interestPeriodFrequencyType: ").append(toIndentedString(interestPeriodFrequencyType)).append("\n");
    sb.append("    interestRecalculationEnabled: ").append(toIndentedString(interestRecalculationEnabled)).append("\n");
    sb.append("    interestRecognitionOnDisbursementDate: ").append(toIndentedString(interestRecognitionOnDisbursementDate)).append("\n");
    sb.append("    loanScheduleProcessingType: ").append(toIndentedString(loanScheduleProcessingType)).append("\n");
    sb.append("    loanScheduleType: ").append(toIndentedString(loanScheduleType)).append("\n");
    sb.append("    merchantBuyDownFee: ").append(toIndentedString(merchantBuyDownFee)).append("\n");
    sb.append("    nominalInterestRatePerPeriod: ").append(toIndentedString(nominalInterestRatePerPeriod)).append("\n");
    sb.append("    numberOfRepayments: ").append(toIndentedString(numberOfRepayments)).append("\n");
    sb.append("    principal: ").append(toIndentedString(principal)).append("\n");
    sb.append("    recurringMoratoriumOnPrincipalPeriods: ").append(toIndentedString(recurringMoratoriumOnPrincipalPeriods)).append("\n");
    sb.append("    repayEvery: ").append(toIndentedString(repayEvery)).append("\n");
    sb.append("    repaymentPeriodFrequencyType: ").append(toIndentedString(repaymentPeriodFrequencyType)).append("\n");
    sb.append("    supportedInterestRefundTypes: ").append(toIndentedString(supportedInterestRefundTypes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

