/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.useradministration.api.PasswordPreferencesApiConstants;
import org.apache.fineract.useradministration.api.PasswordPreferencesApiResourceSwagger;
import org.apache.fineract.useradministration.data.PasswordValidationPolicyData;
import org.apache.fineract.useradministration.service.PasswordValidationPolicyReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/passwordpreferences")
@Component
@Tag(name="Password preferences", description="This API enables management of password policy for user administration.\n\nThere is no Apache Fineract functionality for creating a validation policy. The validation policies come pre-installed.\n\nValidation policies may be updated")
public class PasswordPreferencesApiResource {
    private final PlatformSecurityContext context;
    private final PasswordValidationPolicyReadPlatformService passwordValidationPolicyReadPlatformService;
    private final DefaultToApiJsonSerializer<PasswordValidationPolicyData> toApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=PasswordPreferencesApiResourceSwagger.GetPasswordPreferencesTemplateResponse.class))})})
    public String retrieve(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("PASSWORD_PREFERENCES");
        PasswordValidationPolicyData passwordValidationPolicyData = this.passwordValidationPolicyReadPlatformService.retrieveActiveValidationPolicy();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)passwordValidationPolicyData, PasswordPreferencesApiConstants.RESPONSE_DATA_PARAMETERS);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update password preferences", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=PasswordPreferencesApiResourceSwagger.PutPasswordPreferencesTemplateRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public String update(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updatePasswordPreferences().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Application Password validation policies", description="ARGUMENTS\nExample Requests:\n\npasswordpreferences")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=PasswordPreferencesApiResourceSwagger.GetPasswordPreferencesTemplateResponse.class)))})})
    public String template(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("PASSWORD_PREFERENCES");
        Collection validationPolicies = this.passwordValidationPolicyReadPlatformService.retrieveAll();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, validationPolicies, PasswordPreferencesApiConstants.RESPONSE_DATA_PARAMETERS);
    }

    @Generated
    public PasswordPreferencesApiResource(PlatformSecurityContext context, PasswordValidationPolicyReadPlatformService passwordValidationPolicyReadPlatformService, DefaultToApiJsonSerializer<PasswordValidationPolicyData> toApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.passwordValidationPolicyReadPlatformService = passwordValidationPolicyReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

