/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.spm.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.spm.data.ComponentData;
import org.apache.fineract.spm.data.QuestionData;
import org.apache.fineract.spm.data.ResponseData;
import org.apache.fineract.spm.data.SurveyData;
import org.apache.fineract.spm.domain.Component;
import org.apache.fineract.spm.domain.Question;
import org.apache.fineract.spm.domain.Response;
import org.apache.fineract.spm.domain.Survey;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SurveyMapper {
    private SurveyMapper() {
    }

    public static SurveyData map(Survey survey) {
        SurveyData surveyData = new SurveyData((Long)survey.getId(), SurveyMapper.mapComponents((List)survey.getComponents()), SurveyMapper.mapQuestions((List)survey.getQuestions()), survey.getKey(), survey.getName(), survey.getDescription(), survey.getCountryCode(), survey.getValidFrom(), survey.getValidTo());
        return surveyData;
    }

    public static Survey map(SurveyData surveyData, Survey survey) {
        survey.setComponents(SurveyMapper.mapComponentDatas((List)surveyData.getComponentDatas(), (Survey)survey));
        survey.setQuestions(SurveyMapper.mapQuestionDatas((List)surveyData.getQuestionDatas(), (Survey)survey));
        survey.setKey(surveyData.getKey());
        survey.setName(surveyData.getName());
        survey.setDescription(surveyData.getDescription());
        survey.setCountryCode(surveyData.getCountryCode());
        return survey;
    }

    private static List<ComponentData> mapComponents(List<Component> components) {
        ArrayList<ComponentData> componentDatas = new ArrayList<ComponentData>();
        if (components != null) {
            for (Component component : components) {
                componentDatas.add(new ComponentData((Long)component.getId(), component.getKey(), component.getText(), component.getDescription(), component.getSequenceNo()));
            }
        }
        return componentDatas;
    }

    private static List<Component> mapComponentDatas(List<ComponentData> componentDatas, Survey survey) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (componentDatas != null) {
            for (ComponentData componentData : componentDatas) {
                Component component = new Component();
                component.setSurvey(survey);
                component.setKey(componentData.getKey());
                component.setText(componentData.getText());
                component.setDescription(componentData.getDescription());
                component.setSequenceNo(componentData.getSequenceNo());
                components.add(component);
            }
        }
        return components;
    }

    private static List<QuestionData> mapQuestions(List<Question> questions) {
        ArrayList<QuestionData> questionDatas = new ArrayList<QuestionData>();
        if (questions != null) {
            for (Question question : questions) {
                questionDatas.add(new QuestionData((Long)question.getId(), SurveyMapper.mapResponses((List)question.getResponses()), question.getComponentKey(), question.getKey(), question.getText(), question.getDescription(), question.getSequenceNo()));
            }
        }
        return questionDatas;
    }

    private static List<Question> mapQuestionDatas(List<QuestionData> questionDatas, Survey survey) {
        ArrayList<Question> questions = new ArrayList<Question>();
        if (questionDatas != null) {
            for (QuestionData questionData : questionDatas) {
                Question question = new Question();
                question.setSurvey(survey);
                question.setComponentKey(questionData.getComponentKey());
                question.setResponses(SurveyMapper.mapResponseDatas((List)questionData.getResponseDatas(), (Question)question));
                question.setKey(questionData.getKey());
                question.setText(questionData.getText());
                question.setDescription(question.getDescription());
                question.setSequenceNo(questionData.getSequenceNo());
                questions.add(question);
            }
        }
        return questions;
    }

    private static List<ResponseData> mapResponses(List<Response> responses) {
        ArrayList<ResponseData> responseDatas = new ArrayList<ResponseData>();
        if (responses != null) {
            for (Response response : responses) {
                responseDatas.add(new ResponseData((Long)response.getId(), response.getText(), response.getValue(), response.getSequenceNo()));
            }
        }
        return responseDatas;
    }

    private static List<Response> mapResponseDatas(List<ResponseData> responseDatas, Question question) {
        ArrayList<Response> responses = new ArrayList<Response>();
        if (responseDatas != null) {
            for (ResponseData responseData : responseDatas) {
                Response response = new Response();
                response.setQuestion(question);
                response.setText(responseData.getText());
                response.setValue(responseData.getValue());
                response.setSequenceNo(responseData.getSequenceNo());
                responses.add(response);
            }
        }
        return responses;
    }
}

