/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareaccounts.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.service.RandomPasswordGenerator;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountCharge;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountStatusType;
import org.apache.fineract.portfolio.shareaccounts.domain.ShareAccountTransaction;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProduct;
import org.apache.fineract.useradministration.domain.AppUser;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_share_account")
public class ShareAccount
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @ManyToOne
    @JoinColumn(name="client_id")
    private Client client;
    @ManyToOne
    @JoinColumn(name="product_id")
    private ShareProduct shareProduct;
    @Column(name="status_enum", nullable=false)
    protected Integer status;
    @Column(name="submitted_date")
    private LocalDate submittedDate;
    @ManyToOne(optional=true)
    @JoinColumn(name="submitted_userid")
    protected AppUser submittedBy;
    @Column(name="approved_date")
    protected LocalDate approvedDate;
    @ManyToOne(optional=true)
    @JoinColumn(name="approved_userid")
    protected AppUser approvedBy;
    @Column(name="rejected_date")
    protected LocalDate rejectedDate;
    @ManyToOne(optional=true)
    @JoinColumn(name="rejected_userid")
    protected AppUser rejectedBy;
    @Column(name="activated_date")
    protected LocalDate activatedDate;
    @ManyToOne(optional=true)
    @JoinColumn(name="activated_userid")
    protected AppUser activatedBy;
    @Column(name="closed_date")
    protected LocalDate closedDate;
    @ManyToOne(optional=true)
    @JoinColumn(name="closed_userid")
    protected AppUser closedBy;
    @Column(name="lastmodified_date")
    protected LocalDateTime modifiedDate;
    @ManyToOne(optional=true)
    @JoinColumn(name="lastmodifiedby_id")
    protected AppUser modifiedBy;
    @Column(name="external_id")
    private String externalId;
    @Column(name="account_no", length=20, unique=true, nullable=false)
    private String accountNumber;
    @Column(name="total_approved_shares")
    private Long totalSharesApproved;
    @Column(name="total_pending_shares")
    private Long totalSharesPending;
    @Embedded
    private MonetaryCurrency currency;
    @Column(name="allow_dividends_inactive_clients")
    private Boolean allowDividendCalculationForInactiveClients;
    @ManyToOne
    @JoinColumn(name="savings_account_id")
    private SavingsAccount savingsAccount;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="shareAccount", orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<ShareAccountTransaction> shareAccountTransactions;
    @Column(name="lockin_period_frequency")
    private Integer lockinPeriodFrequency;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="lockin_period_frequency_enum")
    private PeriodFrequencyType lockinPeriodFrequencyType;
    @Column(name="minimum_active_period_frequency")
    private Integer minimumActivePeriodFrequency;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="minimum_active_period_frequency_enum")
    private PeriodFrequencyType minimumActivePeriodFrequencyType;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="shareAccount", orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<ShareAccountCharge> charges;
    @Transient
    protected boolean accountNumberRequiresAutoGeneration = false;
    static final long serialVersionUID = 6169043720567135905L;

    protected ShareAccount() {
    }

    public ShareAccount(Client client, ShareProduct shareProduct, String externalId, MonetaryCurrency currency, SavingsAccount savingsAccount, String accountNo, Long totalSharesApproved, Long totalSharesPending, Set<ShareAccountTransaction> purchasedShares, Boolean allowDividendCalculationForInactiveClients, Integer lockinPeriodFrequency, PeriodFrequencyType lockPeriodType, Integer minimumActivePeriodFrequency, PeriodFrequencyType minimumActivePeriodType, Set<ShareAccountCharge> charges, AppUser submittedBy, LocalDate submittedDate, AppUser approvedBy, LocalDate approvedDate, AppUser rejectedBy, LocalDate rejectedDate, AppUser activatedBy, LocalDate activatedDate, AppUser closedBy, LocalDate closedDate, AppUser modifiedBy, LocalDateTime modifiedDate) {
        this.client = client;
        this.shareProduct = shareProduct;
        this.externalId = externalId;
        this.currency = currency;
        this.savingsAccount = savingsAccount;
        if (StringUtils.isBlank((CharSequence)accountNo)) {
            this.accountNumber = new RandomPasswordGenerator(19).generate();
            this.accountNumberRequiresAutoGeneration = true;
        } else {
            this.accountNumber = accountNo;
        }
        this.totalSharesApproved = totalSharesApproved;
        this.totalSharesPending = totalSharesPending;
        this.shareAccountTransactions = purchasedShares;
        this.allowDividendCalculationForInactiveClients = allowDividendCalculationForInactiveClients;
        this.lockinPeriodFrequency = lockinPeriodFrequency;
        this.lockinPeriodFrequencyType = lockPeriodType;
        this.minimumActivePeriodFrequency = minimumActivePeriodFrequency;
        this.minimumActivePeriodFrequencyType = minimumActivePeriodType;
        this.charges = charges;
        this.submittedDate = submittedDate;
        this.submittedBy = submittedBy;
        this.approvedDate = approvedDate;
        this.approvedBy = approvedBy;
        this.rejectedDate = rejectedDate;
        this.rejectedBy = rejectedBy;
        this.activatedDate = activatedDate;
        this.activatedBy = activatedBy;
        this.closedDate = closedDate;
        this.closedBy = closedBy;
        this.modifiedBy = modifiedBy;
        this.modifiedDate = modifiedDate;
        this.status = ShareAccountStatusType.SUBMITTED_AND_PENDING_APPROVAL.getValue();
    }

    public boolean setShareProduct(ShareProduct shareProduct) {
        boolean toReturn = false;
        if (!((Long)this._persistence_get_shareProduct().getId()).equals(shareProduct.getId())) {
            this._persistence_set_shareProduct(shareProduct);
            toReturn = true;
        }
        return toReturn;
    }

    public ShareProduct getShareProduct() {
        return this._persistence_get_shareProduct();
    }

    public boolean setSubmittedDate(LocalDate submittedDate) {
        boolean toReturn = false;
        if (!DateUtils.isEqual((LocalDate)submittedDate, (LocalDate)this._persistence_get_submittedDate())) {
            this._persistence_set_submittedDate(submittedDate);
            toReturn = true;
        }
        return toReturn;
    }

    public boolean setApprovedDate(LocalDate approvedDate) {
        boolean toReturn = false;
        if (!DateUtils.isEqual((LocalDate)approvedDate, (LocalDate)this._persistence_get_approvedDate())) {
            this._persistence_set_approvedDate(approvedDate);
            toReturn = true;
        }
        return toReturn;
    }

    public boolean setExternalId(String externalId) {
        boolean toReturn = false;
        if (this._persistence_get_externalId() == null || !this._persistence_get_externalId().equals(externalId)) {
            this._persistence_set_externalId(externalId);
            toReturn = true;
        }
        return toReturn;
    }

    public boolean setSavingsAccount(SavingsAccount savingsAccount) {
        boolean returnValue = false;
        if (!((Long)this._persistence_get_savingsAccount().getId()).equals(savingsAccount.getId())) {
            this._persistence_set_savingsAccount(savingsAccount);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setPurchasedShares(Set<ShareAccountTransaction> purchasedShares) {
        this._persistence_set_shareAccountTransactions(purchasedShares);
        return true;
    }

    public void addTransaction(ShareAccountTransaction transaction) {
        transaction.setShareAccount(this);
        if (transaction.isPendingForApprovalTransaction()) {
            if (this._persistence_get_totalSharesPending() == null) {
                this._persistence_set_totalSharesPending(transaction.getTotalShares());
            } else {
                this._persistence_set_totalSharesPending(Long.valueOf(this._persistence_get_totalSharesPending() + transaction.getTotalShares()));
            }
        } else if (transaction.isPurchasTransaction()) {
            if (this._persistence_get_totalSharesApproved() == null) {
                this._persistence_set_totalSharesApproved(transaction.getTotalShares());
            } else {
                this._persistence_set_totalSharesApproved(Long.valueOf(this._persistence_get_totalSharesApproved() + transaction.getTotalShares()));
            }
        }
        this._persistence_get_shareAccountTransactions().add(transaction);
    }

    public boolean setAllowDividendCalculationForInactiveClients(Boolean allowDividendCalculationForInactiveClients) {
        boolean returnValue = false;
        if (this._persistence_get_allowDividendCalculationForInactiveClients() == null || !this._persistence_get_allowDividendCalculationForInactiveClients().equals(allowDividendCalculationForInactiveClients)) {
            this._persistence_set_allowDividendCalculationForInactiveClients(allowDividendCalculationForInactiveClients);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setLockPeriod(Integer lockinPeriod) {
        boolean returnValue = false;
        if (this._persistence_get_lockinPeriodFrequency() == null || !this._persistence_get_lockinPeriodFrequency().equals(lockinPeriod)) {
            this._persistence_set_lockinPeriodFrequency(lockinPeriod);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setLockPeriodFrequencyEnum(PeriodFrequencyType lockinPeriodFrequencyType) {
        boolean returnValue = false;
        if (this._persistence_get_lockinPeriodFrequencyType() == null || !this._persistence_get_lockinPeriodFrequencyType().getValue().equals(lockinPeriodFrequencyType.getValue())) {
            this._persistence_set_lockinPeriodFrequencyType(lockinPeriodFrequencyType);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setminimumActivePeriod(Integer minimumActivePeriodFrequency) {
        boolean returnValue = false;
        if (this._persistence_get_minimumActivePeriodFrequency() == null || !this._persistence_get_minimumActivePeriodFrequency().equals(minimumActivePeriodFrequency)) {
            this._persistence_set_minimumActivePeriodFrequency(minimumActivePeriodFrequency);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setminimumActivePeriodTypeEnum(PeriodFrequencyType minimumActivePeriodForDividends) {
        boolean returnValue = false;
        if (this._persistence_get_minimumActivePeriodFrequencyType() == null || !this._persistence_get_minimumActivePeriodFrequencyType().getValue().equals(minimumActivePeriodForDividends.getValue())) {
            this._persistence_set_minimumActivePeriodFrequencyType(minimumActivePeriodForDividends);
            returnValue = true;
        }
        return returnValue;
    }

    public boolean setCharges(Set<ShareAccountCharge> charges) {
        this._persistence_set_charges(charges);
        return true;
    }

    public void updateAccountNumber(String accountNo) {
        this._persistence_set_accountNumber(accountNo);
        this.accountNumberRequiresAutoGeneration = false;
    }

    public boolean isAccountNumberRequiresAutoGeneration() {
        return this.accountNumberRequiresAutoGeneration;
    }

    public Long getClientId() {
        return (Long)this._persistence_get_client().getId();
    }

    public String getClientName() {
        return this._persistence_get_client().getDisplayName();
    }

    public Client getClient() {
        return this._persistence_get_client();
    }

    public String getSavingsAccountNo() {
        return this._persistence_get_savingsAccount().getAccountNumber();
    }

    public void addAddtionalShares(Set<ShareAccountTransaction> additionalShares) {
        this._persistence_get_shareAccountTransactions().addAll(additionalShares);
    }

    public Set<ShareAccountTransaction> getShareAccountTransactions() {
        return this._persistence_get_shareAccountTransactions();
    }

    public Set<ShareAccountTransaction> getChargeTransactions() {
        HashSet<ShareAccountTransaction> chargeTransactions = new HashSet<ShareAccountTransaction>();
        for (ShareAccountTransaction transaction : this._persistence_get_shareAccountTransactions()) {
            if (!transaction.isActive() || !transaction.isChargeTransaction()) continue;
            chargeTransactions.add(transaction);
        }
        return chargeTransactions;
    }

    public void updateRequestedShares(ShareAccountTransaction purchased) {
        for (ShareAccountTransaction transaction : this._persistence_get_shareAccountTransactions()) {
            if (transaction.isChargeTransaction() || !((Long)transaction.getId()).equals(purchased.getId())) continue;
            transaction.update(purchased.getPurchasedDate(), purchased.getTotalShares(), purchased.getPurchasePrice());
        }
    }

    public void addAdditionalPurchasedShares(ShareAccountTransaction purchased) {
        purchased.setShareAccount(this);
        if (purchased.isRedeemTransaction()) {
            this._persistence_set_totalSharesApproved(Long.valueOf(this._persistence_get_totalSharesApproved() - purchased.getTotalShares()));
        } else if (this._persistence_get_totalSharesPending() == null) {
            this._persistence_set_totalSharesPending(purchased.getTotalShares());
        } else {
            this._persistence_set_totalSharesPending(Long.valueOf(this._persistence_get_totalSharesPending() + purchased.getTotalShares()));
        }
        this._persistence_get_shareAccountTransactions().add(purchased);
    }

    public void addShareAccountCharge(ShareAccountCharge charge) {
        charge.update(this);
        this._persistence_get_charges().add(charge);
    }

    public void approve(LocalDate approvedDate, AppUser approvedUser) {
        this._persistence_set_approvedDate(approvedDate);
        this._persistence_set_approvedBy(approvedUser);
        for (ShareAccountTransaction transaction : this._persistence_get_shareAccountTransactions()) {
            transaction.approve();
        }
        this._persistence_set_status(ShareAccountStatusType.APPROVED.getValue());
        this._persistence_set_totalSharesApproved(this._persistence_get_totalSharesPending());
        this._persistence_set_totalSharesPending(null);
    }

    public void activate(LocalDate approvedDate, AppUser approvedUser) {
        this._persistence_set_activatedDate(approvedDate);
        this._persistence_set_activatedBy(approvedUser);
        this._persistence_set_status(ShareAccountStatusType.ACTIVE.getValue());
    }

    public void undoApprove() {
        this._persistence_set_status(ShareAccountStatusType.SUBMITTED_AND_PENDING_APPROVAL.getValue());
        this._persistence_set_approvedDate(null);
        this._persistence_set_approvedBy(null);
        this._persistence_set_rejectedDate(null);
        this._persistence_set_rejectedBy(null);
        this._persistence_set_closedDate(null);
        this._persistence_set_closedBy(null);
        this._persistence_set_totalSharesApproved(null);
        Long tempTotalShares = 0L;
        for (ShareAccountTransaction transaction : this._persistence_get_shareAccountTransactions()) {
            if (!transaction.isPurchasTransaction()) continue;
            transaction.undoApprove();
            tempTotalShares = tempTotalShares + transaction.getTotalShares();
        }
        this._persistence_set_totalSharesPending(tempTotalShares);
    }

    public void reject(LocalDate rejectedDate, AppUser rejectedUser) {
        this._persistence_set_rejectedDate(rejectedDate);
        this._persistence_set_rejectedBy(rejectedUser);
        this._persistence_set_status(ShareAccountStatusType.REJECTED.getValue());
        this._persistence_set_totalSharesPending(null);
        this._persistence_set_totalSharesApproved(null);
        for (ShareAccountTransaction transaction : this._persistence_get_shareAccountTransactions()) {
            if (!transaction.isPendingForApprovalTransaction()) continue;
            transaction.reject();
        }
    }

    public void close(LocalDate closedDate, AppUser closedBy) {
        this._persistence_set_closedDate(closedDate);
        this._persistence_set_closedBy(closedBy);
        this._persistence_set_status(ShareAccountStatusType.CLOSED.getValue());
        this._persistence_set_totalSharesPending(null);
        this._persistence_set_totalSharesApproved(null);
    }

    public String getAccountNumber() {
        return this._persistence_get_accountNumber();
    }

    public ShareAccountTransaction retrievePurchasedShares(Long id) {
        ShareAccountTransaction toReturn = null;
        for (ShareAccountTransaction share : this._persistence_get_shareAccountTransactions()) {
            if (!((Long)share.getId()).equals(id)) continue;
            toReturn = share;
            break;
        }
        return toReturn;
    }

    public Set<ShareAccountCharge> getCharges() {
        return this._persistence_get_charges();
    }

    public void addChargeTransaction(ShareAccountTransaction chargeTransaction) {
        chargeTransaction.setShareAccount(this);
        this._persistence_get_shareAccountTransactions().add(chargeTransaction);
    }

    public Set<ShareAccountTransaction> getPendingForApprovalSharePurchaseTransactions() {
        HashSet<ShareAccountTransaction> purchaseTransactions = new HashSet<ShareAccountTransaction>();
        for (ShareAccountTransaction transaction : this._persistence_get_shareAccountTransactions()) {
            if (!transaction.isActive() || !transaction.isPendingForApprovalTransaction()) continue;
            purchaseTransactions.add(transaction);
        }
        return purchaseTransactions;
    }

    public MonetaryCurrency getCurrency() {
        return this._persistence_get_currency();
    }

    public void updateApprovedShares(Long shares) {
        if (this._persistence_get_totalSharesApproved() == null) {
            this._persistence_set_totalSharesApproved(shares);
        } else {
            this._persistence_set_totalSharesApproved(Long.valueOf(this._persistence_get_totalSharesApproved() + shares));
            this._persistence_set_totalSharesPending(Long.valueOf(this._persistence_get_totalSharesPending() - shares));
        }
    }

    public Long getTotalApprovedShares() {
        return this._persistence_get_totalSharesApproved();
    }

    public void removePendingShares(Long totalShares) {
        this._persistence_set_totalSharesPending(Long.valueOf(this._persistence_get_totalSharesPending() - totalShares));
    }

    public Long getOfficeId() {
        return (Long)this._persistence_get_client().getOffice().getId();
    }

    public void setTotalPendingShares(Long shares) {
        this._persistence_set_totalSharesPending(shares);
    }

    public ShareAccountTransaction getShareAccountTransaction(ShareAccountTransaction transaction) {
        ShareAccountTransaction returnTrans = null;
        for (ShareAccountTransaction tran : this._persistence_get_shareAccountTransactions()) {
            if (!DateUtils.isEqual((LocalDate)tran.getPurchasedDate(), (LocalDate)transaction.getPurchasedDate()) || !tran.getTotalShares().equals(transaction.getTotalShares()) || tran.getPurchasePrice().compareTo(transaction.getPurchasePrice()) != 0 || !tran.getTransactionStatus().equals(transaction.getTransactionStatus()) || !tran.getTransactionType().equals(transaction.getTransactionType())) continue;
            returnTrans = tran;
            break;
        }
        return returnTrans;
    }

    public LocalDate getSubmittedDate() {
        return this._persistence_get_submittedDate();
    }

    public LocalDate getApprovedDate() {
        return this._persistence_get_approvedDate();
    }

    public void removeTransactions() {
        for (ShareAccountTransaction transaction : this._persistence_get_shareAccountTransactions()) {
            transaction.setActive(false);
        }
        this._persistence_set_totalSharesApproved(Long.valueOf(0L));
        this._persistence_set_totalSharesPending(Long.valueOf(0L));
    }

    public void removeCharges() {
        for (ShareAccountCharge charge : this._persistence_get_charges()) {
            charge.setActive(false);
        }
    }

    public void addCharges(Set<ShareAccountCharge> charges) {
        this._persistence_get_charges().addAll(charges);
    }

    public Integer getLockinPeriodFrequency() {
        return this._persistence_get_lockinPeriodFrequency();
    }

    public PeriodFrequencyType getLockinPeriodFrequencyType() {
        return this._persistence_get_lockinPeriodFrequencyType();
    }

    public LocalDate getActivatedDate() {
        return this._persistence_get_activatedDate();
    }

    public Integer status() {
        return this._persistence_get_status();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ShareAccount();
    }

    public Object _persistence_get(String string) {
        if (string == "closedBy") {
            return this.closedBy;
        }
        if (string == "allowDividendCalculationForInactiveClients") {
            return this.allowDividendCalculationForInactiveClients;
        }
        if (string == "approvedBy") {
            return this.approvedBy;
        }
        if (string == "submittedDate") {
            return this.submittedDate;
        }
        if (string == "shareAccountTransactions") {
            return this.shareAccountTransactions;
        }
        if (string == "lockinPeriodFrequencyType") {
            return this.lockinPeriodFrequencyType;
        }
        if (string == "client") {
            return this.client;
        }
        if (string == "modifiedBy") {
            return this.modifiedBy;
        }
        if (string == "currency") {
            return this.currency;
        }
        if (string == "activatedDate") {
            return this.activatedDate;
        }
        if (string == "totalSharesPending") {
            return this.totalSharesPending;
        }
        if (string == "submittedBy") {
            return this.submittedBy;
        }
        if (string == "externalId") {
            return this.externalId;
        }
        if (string == "minimumActivePeriodFrequencyType") {
            return this.minimumActivePeriodFrequencyType;
        }
        if (string == "totalSharesApproved") {
            return this.totalSharesApproved;
        }
        if (string == "minimumActivePeriodFrequency") {
            return this.minimumActivePeriodFrequency;
        }
        if (string == "activatedBy") {
            return this.activatedBy;
        }
        if (string == "accountNumber") {
            return this.accountNumber;
        }
        if (string == "rejectedDate") {
            return this.rejectedDate;
        }
        if (string == "approvedDate") {
            return this.approvedDate;
        }
        if (string == "shareProduct") {
            return this.shareProduct;
        }
        if (string == "rejectedBy") {
            return this.rejectedBy;
        }
        if (string == "charges") {
            return this.charges;
        }
        if (string == "closedDate") {
            return this.closedDate;
        }
        if (string == "savingsAccount") {
            return this.savingsAccount;
        }
        if (string == "modifiedDate") {
            return this.modifiedDate;
        }
        if (string == "lockinPeriodFrequency") {
            return this.lockinPeriodFrequency;
        }
        if (string == "status") {
            return this.status;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "closedBy") {
            this.closedBy = (AppUser)object;
            return;
        }
        if (string == "allowDividendCalculationForInactiveClients") {
            this.allowDividendCalculationForInactiveClients = (Boolean)object;
            return;
        }
        if (string == "approvedBy") {
            this.approvedBy = (AppUser)object;
            return;
        }
        if (string == "submittedDate") {
            this.submittedDate = (LocalDate)object;
            return;
        }
        if (string == "shareAccountTransactions") {
            this.shareAccountTransactions = (Set)object;
            return;
        }
        if (string == "lockinPeriodFrequencyType") {
            this.lockinPeriodFrequencyType = (PeriodFrequencyType)object;
            return;
        }
        if (string == "client") {
            this.client = (Client)object;
            return;
        }
        if (string == "modifiedBy") {
            this.modifiedBy = (AppUser)object;
            return;
        }
        if (string == "currency") {
            this.currency = (MonetaryCurrency)object;
            return;
        }
        if (string == "activatedDate") {
            this.activatedDate = (LocalDate)object;
            return;
        }
        if (string == "totalSharesPending") {
            this.totalSharesPending = (Long)object;
            return;
        }
        if (string == "submittedBy") {
            this.submittedBy = (AppUser)object;
            return;
        }
        if (string == "externalId") {
            this.externalId = (String)object;
            return;
        }
        if (string == "minimumActivePeriodFrequencyType") {
            this.minimumActivePeriodFrequencyType = (PeriodFrequencyType)object;
            return;
        }
        if (string == "totalSharesApproved") {
            this.totalSharesApproved = (Long)object;
            return;
        }
        if (string == "minimumActivePeriodFrequency") {
            this.minimumActivePeriodFrequency = (Integer)object;
            return;
        }
        if (string == "activatedBy") {
            this.activatedBy = (AppUser)object;
            return;
        }
        if (string == "accountNumber") {
            this.accountNumber = (String)object;
            return;
        }
        if (string == "rejectedDate") {
            this.rejectedDate = (LocalDate)object;
            return;
        }
        if (string == "approvedDate") {
            this.approvedDate = (LocalDate)object;
            return;
        }
        if (string == "shareProduct") {
            this.shareProduct = (ShareProduct)object;
            return;
        }
        if (string == "rejectedBy") {
            this.rejectedBy = (AppUser)object;
            return;
        }
        if (string == "charges") {
            this.charges = (Set)object;
            return;
        }
        if (string == "closedDate") {
            this.closedDate = (LocalDate)object;
            return;
        }
        if (string == "savingsAccount") {
            this.savingsAccount = (SavingsAccount)object;
            return;
        }
        if (string == "modifiedDate") {
            this.modifiedDate = (LocalDateTime)object;
            return;
        }
        if (string == "lockinPeriodFrequency") {
            this.lockinPeriodFrequency = (Integer)object;
            return;
        }
        if (string == "status") {
            this.status = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public AppUser _persistence_get_closedBy() {
        this._persistence_checkFetched("closedBy");
        return this.closedBy;
    }

    public void _persistence_set_closedBy(AppUser appUser) {
        this._persistence_checkFetchedForSet("closedBy");
        this.closedBy = appUser;
    }

    public Boolean _persistence_get_allowDividendCalculationForInactiveClients() {
        this._persistence_checkFetched("allowDividendCalculationForInactiveClients");
        return this.allowDividendCalculationForInactiveClients;
    }

    public void _persistence_set_allowDividendCalculationForInactiveClients(Boolean bl) {
        this._persistence_checkFetchedForSet("allowDividendCalculationForInactiveClients");
        this.allowDividendCalculationForInactiveClients = bl;
    }

    public AppUser _persistence_get_approvedBy() {
        this._persistence_checkFetched("approvedBy");
        return this.approvedBy;
    }

    public void _persistence_set_approvedBy(AppUser appUser) {
        this._persistence_checkFetchedForSet("approvedBy");
        this.approvedBy = appUser;
    }

    public LocalDate _persistence_get_submittedDate() {
        this._persistence_checkFetched("submittedDate");
        return this.submittedDate;
    }

    public void _persistence_set_submittedDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("submittedDate");
        this.submittedDate = localDate;
    }

    public Set _persistence_get_shareAccountTransactions() {
        this._persistence_checkFetched("shareAccountTransactions");
        return this.shareAccountTransactions;
    }

    public void _persistence_set_shareAccountTransactions(Set set) {
        this._persistence_checkFetchedForSet("shareAccountTransactions");
        this.shareAccountTransactions = set;
    }

    public PeriodFrequencyType _persistence_get_lockinPeriodFrequencyType() {
        this._persistence_checkFetched("lockinPeriodFrequencyType");
        return this.lockinPeriodFrequencyType;
    }

    public void _persistence_set_lockinPeriodFrequencyType(PeriodFrequencyType periodFrequencyType) {
        this._persistence_checkFetchedForSet("lockinPeriodFrequencyType");
        this.lockinPeriodFrequencyType = periodFrequencyType;
    }

    public Client _persistence_get_client() {
        this._persistence_checkFetched("client");
        return this.client;
    }

    public void _persistence_set_client(Client client) {
        this._persistence_checkFetchedForSet("client");
        this.client = client;
    }

    public AppUser _persistence_get_modifiedBy() {
        this._persistence_checkFetched("modifiedBy");
        return this.modifiedBy;
    }

    public void _persistence_set_modifiedBy(AppUser appUser) {
        this._persistence_checkFetchedForSet("modifiedBy");
        this.modifiedBy = appUser;
    }

    public MonetaryCurrency _persistence_get_currency() {
        this._persistence_checkFetched("currency");
        return this.currency;
    }

    public void _persistence_set_currency(MonetaryCurrency monetaryCurrency) {
        this._persistence_checkFetchedForSet("currency");
        this.currency = monetaryCurrency;
    }

    public LocalDate _persistence_get_activatedDate() {
        this._persistence_checkFetched("activatedDate");
        return this.activatedDate;
    }

    public void _persistence_set_activatedDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("activatedDate");
        this.activatedDate = localDate;
    }

    public Long _persistence_get_totalSharesPending() {
        this._persistence_checkFetched("totalSharesPending");
        return this.totalSharesPending;
    }

    public void _persistence_set_totalSharesPending(Long l) {
        this._persistence_checkFetchedForSet("totalSharesPending");
        this.totalSharesPending = l;
    }

    public AppUser _persistence_get_submittedBy() {
        this._persistence_checkFetched("submittedBy");
        return this.submittedBy;
    }

    public void _persistence_set_submittedBy(AppUser appUser) {
        this._persistence_checkFetchedForSet("submittedBy");
        this.submittedBy = appUser;
    }

    public String _persistence_get_externalId() {
        this._persistence_checkFetched("externalId");
        return this.externalId;
    }

    public void _persistence_set_externalId(String string) {
        this._persistence_checkFetchedForSet("externalId");
        this.externalId = string;
    }

    public PeriodFrequencyType _persistence_get_minimumActivePeriodFrequencyType() {
        this._persistence_checkFetched("minimumActivePeriodFrequencyType");
        return this.minimumActivePeriodFrequencyType;
    }

    public void _persistence_set_minimumActivePeriodFrequencyType(PeriodFrequencyType periodFrequencyType) {
        this._persistence_checkFetchedForSet("minimumActivePeriodFrequencyType");
        this.minimumActivePeriodFrequencyType = periodFrequencyType;
    }

    public Long _persistence_get_totalSharesApproved() {
        this._persistence_checkFetched("totalSharesApproved");
        return this.totalSharesApproved;
    }

    public void _persistence_set_totalSharesApproved(Long l) {
        this._persistence_checkFetchedForSet("totalSharesApproved");
        this.totalSharesApproved = l;
    }

    public Integer _persistence_get_minimumActivePeriodFrequency() {
        this._persistence_checkFetched("minimumActivePeriodFrequency");
        return this.minimumActivePeriodFrequency;
    }

    public void _persistence_set_minimumActivePeriodFrequency(Integer n) {
        this._persistence_checkFetchedForSet("minimumActivePeriodFrequency");
        this.minimumActivePeriodFrequency = n;
    }

    public AppUser _persistence_get_activatedBy() {
        this._persistence_checkFetched("activatedBy");
        return this.activatedBy;
    }

    public void _persistence_set_activatedBy(AppUser appUser) {
        this._persistence_checkFetchedForSet("activatedBy");
        this.activatedBy = appUser;
    }

    public String _persistence_get_accountNumber() {
        this._persistence_checkFetched("accountNumber");
        return this.accountNumber;
    }

    public void _persistence_set_accountNumber(String string) {
        this._persistence_checkFetchedForSet("accountNumber");
        this.accountNumber = string;
    }

    public LocalDate _persistence_get_rejectedDate() {
        this._persistence_checkFetched("rejectedDate");
        return this.rejectedDate;
    }

    public void _persistence_set_rejectedDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("rejectedDate");
        this.rejectedDate = localDate;
    }

    public LocalDate _persistence_get_approvedDate() {
        this._persistence_checkFetched("approvedDate");
        return this.approvedDate;
    }

    public void _persistence_set_approvedDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("approvedDate");
        this.approvedDate = localDate;
    }

    public ShareProduct _persistence_get_shareProduct() {
        this._persistence_checkFetched("shareProduct");
        return this.shareProduct;
    }

    public void _persistence_set_shareProduct(ShareProduct shareProduct) {
        this._persistence_checkFetchedForSet("shareProduct");
        this.shareProduct = shareProduct;
    }

    public AppUser _persistence_get_rejectedBy() {
        this._persistence_checkFetched("rejectedBy");
        return this.rejectedBy;
    }

    public void _persistence_set_rejectedBy(AppUser appUser) {
        this._persistence_checkFetchedForSet("rejectedBy");
        this.rejectedBy = appUser;
    }

    public Set _persistence_get_charges() {
        this._persistence_checkFetched("charges");
        return this.charges;
    }

    public void _persistence_set_charges(Set set) {
        this._persistence_checkFetchedForSet("charges");
        this.charges = set;
    }

    public LocalDate _persistence_get_closedDate() {
        this._persistence_checkFetched("closedDate");
        return this.closedDate;
    }

    public void _persistence_set_closedDate(LocalDate localDate) {
        this._persistence_checkFetchedForSet("closedDate");
        this.closedDate = localDate;
    }

    public SavingsAccount _persistence_get_savingsAccount() {
        this._persistence_checkFetched("savingsAccount");
        return this.savingsAccount;
    }

    public void _persistence_set_savingsAccount(SavingsAccount savingsAccount) {
        this._persistence_checkFetchedForSet("savingsAccount");
        this.savingsAccount = savingsAccount;
    }

    public LocalDateTime _persistence_get_modifiedDate() {
        this._persistence_checkFetched("modifiedDate");
        return this.modifiedDate;
    }

    public void _persistence_set_modifiedDate(LocalDateTime localDateTime) {
        this._persistence_checkFetchedForSet("modifiedDate");
        this.modifiedDate = localDateTime;
    }

    public Integer _persistence_get_lockinPeriodFrequency() {
        this._persistence_checkFetched("lockinPeriodFrequency");
        return this.lockinPeriodFrequency;
    }

    public void _persistence_set_lockinPeriodFrequency(Integer n) {
        this._persistence_checkFetchedForSet("lockinPeriodFrequency");
        this.lockinPeriodFrequency = n;
    }

    public Integer _persistence_get_status() {
        this._persistence_checkFetched("status");
        return this.status;
    }

    public void _persistence_set_status(Integer n) {
        this._persistence_checkFetchedForSet("status");
        this.status = n;
    }
}

