/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.device.api;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import java.util.HashMap;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.self.config.SelfServiceModuleIsEnabledCondition;
import org.apache.fineract.portfolio.self.device.domain.DeviceRegistration;
import org.apache.fineract.portfolio.self.device.domain.DeviceRegistrationData;
import org.apache.fineract.portfolio.self.device.service.DeviceRegistrationReadPlatformService;
import org.apache.fineract.portfolio.self.device.service.DeviceRegistrationWritePlatformService;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Path(value="/v1/self/device/registration")
@Component
@Tag(name="Device Registration", description="")
@Conditional(value={SelfServiceModuleIsEnabledCondition.class})
public class DeviceRegistrationApiResource {
    private final PlatformSecurityContext context;
    private final DeviceRegistrationWritePlatformService deviceRegistrationWritePlatformService;
    private final DefaultToApiJsonSerializer<DeviceRegistrationData> toApiJsonSerializer;
    private final DeviceRegistrationReadPlatformService deviceRegistrationReadPlatformService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String registerDevice(String apiRequestBodyAsJson) {
        this.context.authenticatedUser();
        Gson gson = new Gson();
        JsonObject json = (JsonObject)new Gson().fromJson(apiRequestBodyAsJson, JsonObject.class);
        Long clientId = json.get("clientId").getAsLong();
        String registrationId = json.get("registrationId").getAsString();
        DeviceRegistration deviceRegistration = this.deviceRegistrationWritePlatformService.registerDevice(clientId, registrationId);
        return gson.toJson((Object)deviceRegistration.getId());
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveAllDeviceRegistrations(@Context UriInfo uriInfo) {
        this.context.authenticatedUser();
        Collection deviceRegistrationDataList = this.deviceRegistrationReadPlatformService.retrieveAllDeviceRegiistrations();
        return this.toApiJsonSerializer.serialize((Object)deviceRegistrationDataList);
    }

    @GET
    @Path(value="client/{clientId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveDeviceRegistrationByClientId(@PathParam(value="clientId") Long clientId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser();
        DeviceRegistrationData deviceRegistrationData = this.deviceRegistrationReadPlatformService.retrieveDeviceRegiistrationByClientId(clientId);
        return this.toApiJsonSerializer.serialize((Object)deviceRegistrationData);
    }

    @GET
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String retrieveDeviceRegiistration(@PathParam(value="id") Long id, @Context UriInfo uriInfo) {
        this.context.authenticatedUser();
        DeviceRegistrationData deviceRegistrationData = this.deviceRegistrationReadPlatformService.retrieveDeviceRegiistration(id);
        return this.toApiJsonSerializer.serialize((Object)deviceRegistrationData);
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String updateDeviceRegistration(@PathParam(value="id") Long id, String apiRequestBodyAsJson) {
        this.context.authenticatedUser();
        Gson gson = new Gson();
        JsonObject json = (JsonObject)new Gson().fromJson(apiRequestBodyAsJson, JsonObject.class);
        Long clientId = json.get("clientId").getAsLong();
        String registrationId = json.get("registrationId").getAsString();
        DeviceRegistration deviceRegistration = this.deviceRegistrationWritePlatformService.updateDeviceRegistration(id, clientId, registrationId);
        return gson.toJson((Object)deviceRegistration.getId());
    }

    @DELETE
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String delete(@PathParam(value="id") Long id) {
        this.context.authenticatedUser();
        this.deviceRegistrationWritePlatformService.deleteDeviceRegistration(id);
        return this.responseMap(id);
    }

    public String responseMap(Long id) {
        HashMap<String, Long> responseMap = new HashMap<String, Long>();
        responseMap.put("resource", id);
        return new Gson().toJson(responseMap);
    }

    @Generated
    public DeviceRegistrationApiResource(PlatformSecurityContext context, DeviceRegistrationWritePlatformService deviceRegistrationWritePlatformService, DefaultToApiJsonSerializer<DeviceRegistrationData> toApiJsonSerializer, DeviceRegistrationReadPlatformService deviceRegistrationReadPlatformService) {
        this.context = context;
        this.deviceRegistrationWritePlatformService = deviceRegistrationWritePlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.deviceRegistrationReadPlatformService = deviceRegistrationReadPlatformService;
    }
}

