/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.domain;

import com.google.gson.JsonElement;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.UnsupportedParameterException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepositoryWrapper;
import org.apache.fineract.portfolio.account.service.AccountTransfersReadPlatformService;
import org.apache.fineract.portfolio.accountdetails.domain.AccountType;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.exception.ClientNotActiveException;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepositoryWrapper;
import org.apache.fineract.portfolio.group.exception.CenterNotActiveException;
import org.apache.fineract.portfolio.group.exception.ClientNotInGroupException;
import org.apache.fineract.portfolio.group.exception.GroupNotActiveException;
import org.apache.fineract.portfolio.savings.SavingsCompoundingInterestPeriodType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationDaysInYearType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationType;
import org.apache.fineract.portfolio.savings.SavingsPeriodFrequencyType;
import org.apache.fineract.portfolio.savings.SavingsPostingInterestPeriodType;
import org.apache.fineract.portfolio.savings.data.SavingsAccountData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionData;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountChargeAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransactionDataSummaryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransactionSummaryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsHelper;
import org.apache.fineract.portfolio.savings.domain.SavingsProduct;
import org.apache.fineract.portfolio.savings.domain.SavingsProductRepository;
import org.apache.fineract.portfolio.savings.exception.SavingsProductNotFoundException;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class SavingsAccountAssembler {
    private static final Logger LOG = LoggerFactory.getLogger(SavingsAccountAssembler.class);
    private final SavingsAccountTransactionSummaryWrapper savingsAccountTransactionSummaryWrapper;
    private final SavingsAccountTransactionDataSummaryWrapper savingsAccountTransactionDataSummaryWrapper;
    private final SavingsHelper savingsHelper;
    private final ClientRepositoryWrapper clientRepository;
    private final GroupRepositoryWrapper groupRepository;
    private final StaffRepositoryWrapper staffRepository;
    private final SavingsProductRepository savingProductRepository;
    private final SavingsAccountRepositoryWrapper savingsAccountRepository;
    private final SavingsAccountChargeAssembler savingsAccountChargeAssembler;
    private final FromJsonHelper fromApiJsonHelper;
    private final JdbcTemplate jdbcTemplate;
    private final ConfigurationDomainService configurationDomainService;
    private final ExternalIdFactory externalIdFactory;

    @Autowired
    public SavingsAccountAssembler(SavingsAccountTransactionSummaryWrapper savingsAccountTransactionSummaryWrapper, SavingsAccountTransactionDataSummaryWrapper savingsAccountTransactionDataSummaryWrapper, ClientRepositoryWrapper clientRepository, GroupRepositoryWrapper groupRepository, StaffRepositoryWrapper staffRepository, SavingsProductRepository savingProductRepository, SavingsAccountRepositoryWrapper savingsAccountRepository, SavingsAccountChargeAssembler savingsAccountChargeAssembler, FromJsonHelper fromApiJsonHelper, AccountTransfersReadPlatformService accountTransfersReadPlatformService, JdbcTemplate jdbcTemplate, ConfigurationDomainService configurationDomainService, ExternalIdFactory externalIdFactory) {
        this.savingsAccountTransactionSummaryWrapper = savingsAccountTransactionSummaryWrapper;
        this.savingsAccountTransactionDataSummaryWrapper = savingsAccountTransactionDataSummaryWrapper;
        this.clientRepository = clientRepository;
        this.groupRepository = groupRepository;
        this.staffRepository = staffRepository;
        this.savingProductRepository = savingProductRepository;
        this.savingsAccountRepository = savingsAccountRepository;
        this.savingsAccountChargeAssembler = savingsAccountChargeAssembler;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.savingsHelper = new SavingsHelper(accountTransfersReadPlatformService);
        this.jdbcTemplate = jdbcTemplate;
        this.configurationDomainService = configurationDomainService;
        this.externalIdFactory = externalIdFactory;
    }

    public SavingsAccount assembleFrom(JsonCommand command, AppUser submittedBy) {
        Long fieldOfficerId;
        Long groupId;
        JsonElement element = command.parsedJson();
        String accountNo = this.fromApiJsonHelper.extractStringNamed("accountNo", element);
        String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
        Long productId = this.fromApiJsonHelper.extractLongNamed("productId", element);
        SavingsProduct product = (SavingsProduct)this.savingProductRepository.findById((Object)productId).orElseThrow(() -> new SavingsProductNotFoundException(productId));
        Client client = null;
        Group group = null;
        Staff fieldOfficer = null;
        AccountType accountType = AccountType.INVALID;
        Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
        if (clientId != null) {
            client = this.clientRepository.findOneWithNotFoundDetection(clientId);
            accountType = AccountType.INDIVIDUAL;
            if (client.isNotActive()) {
                throw new ClientNotActiveException(clientId);
            }
        }
        if ((groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element)) != null) {
            group = this.groupRepository.findOneWithNotFoundDetection(groupId);
            accountType = AccountType.GROUP;
            if (group.isNotActive()) {
                if (group.isCenter()) {
                    throw new CenterNotActiveException(groupId);
                }
                throw new GroupNotActiveException(groupId);
            }
        }
        if (group != null && client != null) {
            if (!group.hasClientAsMember(client)) {
                throw new ClientNotInGroupException(clientId, groupId);
            }
            accountType = AccountType.JLG;
        }
        if (Boolean.valueOf(command.booleanPrimitiveValueOfParameterNamed("isGSIM")) != null && command.booleanPrimitiveValueOfParameterNamed("isGSIM")) {
            accountType = AccountType.GSIM;
        }
        if ((fieldOfficerId = this.fromApiJsonHelper.extractLongNamed("fieldOfficerId", element)) != null) {
            fieldOfficer = this.staffRepository.findOneWithNotFoundDetection(fieldOfficerId);
        }
        LocalDate submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
        BigDecimal interestRate = null;
        interestRate = command.parameterExists("nominalAnnualInterestRate") ? command.bigDecimalValueOfParameterNamed("nominalAnnualInterestRate") : product.nominalAnnualInterestRate();
        SavingsCompoundingInterestPeriodType interestCompoundingPeriodType = null;
        Integer interestPeriodTypeValue = command.integerValueOfParameterNamed("interestCompoundingPeriodType");
        interestCompoundingPeriodType = interestPeriodTypeValue != null ? SavingsCompoundingInterestPeriodType.fromInt((Integer)interestPeriodTypeValue) : product.interestCompoundingPeriodType();
        SavingsPostingInterestPeriodType interestPostingPeriodType = null;
        Integer interestPostingPeriodTypeValue = command.integerValueOfParameterNamed("interestPostingPeriodType");
        interestPostingPeriodType = interestPostingPeriodTypeValue != null ? SavingsPostingInterestPeriodType.fromInt((Integer)interestPostingPeriodTypeValue) : product.interestPostingPeriodType();
        SavingsInterestCalculationType interestCalculationType = null;
        Integer interestCalculationTypeValue = command.integerValueOfParameterNamed("interestCalculationType");
        interestCalculationType = interestCalculationTypeValue != null ? SavingsInterestCalculationType.fromInt((Integer)interestCalculationTypeValue) : product.interestCalculationType();
        SavingsInterestCalculationDaysInYearType interestCalculationDaysInYearType = null;
        Integer interestCalculationDaysInYearTypeValue = command.integerValueOfParameterNamed("interestCalculationDaysInYearType");
        interestCalculationDaysInYearType = interestCalculationDaysInYearTypeValue != null ? SavingsInterestCalculationDaysInYearType.fromInt((Integer)interestCalculationDaysInYearTypeValue) : product.interestCalculationDaysInYearType();
        BigDecimal minRequiredOpeningBalance = null;
        minRequiredOpeningBalance = command.parameterExists("minRequiredOpeningBalance") ? command.bigDecimalValueOfParameterNamed("minRequiredOpeningBalance") : product.minRequiredOpeningBalance();
        Integer lockinPeriodFrequency = null;
        lockinPeriodFrequency = command.parameterExists("lockinPeriodFrequency") ? command.integerValueOfParameterNamed("lockinPeriodFrequency") : product.lockinPeriodFrequency();
        SavingsPeriodFrequencyType lockinPeriodFrequencyType = null;
        Integer lockinPeriodFrequencyTypeValue = null;
        if (command.parameterExists("lockinPeriodFrequencyType")) {
            lockinPeriodFrequencyTypeValue = command.integerValueOfParameterNamed("lockinPeriodFrequencyType");
            if (lockinPeriodFrequencyTypeValue != null) {
                lockinPeriodFrequencyType = SavingsPeriodFrequencyType.fromInt((Integer)lockinPeriodFrequencyTypeValue);
            }
        } else {
            lockinPeriodFrequencyType = product.lockinPeriodFrequencyType();
        }
        boolean iswithdrawalFeeApplicableForTransfer = false;
        if (command.parameterExists("withdrawalFeeForTransfers")) {
            iswithdrawalFeeApplicableForTransfer = command.booleanPrimitiveValueOfParameterNamed("withdrawalFeeForTransfers");
        }
        Set charges = this.savingsAccountChargeAssembler.fromParsedJson(element, product.currency().getCode());
        boolean allowOverdraft = false;
        allowOverdraft = command.parameterExists("allowOverdraft") ? command.booleanPrimitiveValueOfParameterNamed("allowOverdraft") : product.isAllowOverdraft();
        BigDecimal overdraftLimit = BigDecimal.ZERO;
        overdraftLimit = command.parameterExists("overdraftLimit") ? command.bigDecimalValueOfParameterNamedDefaultToNullIfZero("overdraftLimit") : product.overdraftLimit();
        BigDecimal nominalAnnualInterestRateOverdraft = BigDecimal.ZERO;
        nominalAnnualInterestRateOverdraft = command.parameterExists("nominalAnnualInterestRateOverdraft") ? command.bigDecimalValueOfParameterNamedDefaultToNullIfZero("nominalAnnualInterestRateOverdraft") : product.nominalAnnualInterestRateOverdraft();
        BigDecimal minOverdraftForInterestCalculation = BigDecimal.ZERO;
        minOverdraftForInterestCalculation = command.parameterExists("minOverdraftForInterestCalculation") ? command.bigDecimalValueOfParameterNamedDefaultToNullIfZero("minOverdraftForInterestCalculation") : product.minOverdraftForInterestCalculation();
        boolean enforceMinRequiredBalance = false;
        enforceMinRequiredBalance = command.parameterExists("enforceMinRequiredBalance") ? command.booleanPrimitiveValueOfParameterNamed("enforceMinRequiredBalance") : product.isMinRequiredBalanceEnforced();
        BigDecimal minRequiredBalance = BigDecimal.ZERO;
        minRequiredBalance = command.parameterExists("minRequiredBalance") ? command.bigDecimalValueOfParameterNamedDefaultToNullIfZero("minRequiredBalance") : product.minRequiredBalance();
        boolean lienAllowed = false;
        lienAllowed = command.parameterExists("lienAllowed") ? command.booleanPrimitiveValueOfParameterNamed("lienAllowed") : product.isLienAllowed();
        BigDecimal maxAllowedLienLimit = BigDecimal.ZERO;
        maxAllowedLienLimit = command.parameterExists("maxAllowedLienLimit") ? command.bigDecimalValueOfParameterNamedDefaultToNullIfZero("maxAllowedLienLimit") : product.maxAllowedLienLimit();
        boolean withHoldTax = product.withHoldTax();
        if (command.parameterExists("withHoldTax") && (withHoldTax = command.booleanPrimitiveValueOfParameterNamed("withHoldTax")) && product.getTaxGroup() == null) {
            throw new UnsupportedParameterException(Arrays.asList("withHoldTax"));
        }
        SavingsAccount account = SavingsAccount.createNewApplicationForSubmittal((Client)client, (Group)group, (SavingsProduct)product, (Staff)fieldOfficer, (String)accountNo, (ExternalId)this.externalIdFactory.create(externalId), (AccountType)accountType, (LocalDate)submittedOnDate, (AppUser)submittedBy, (BigDecimal)interestRate, (SavingsCompoundingInterestPeriodType)interestCompoundingPeriodType, (SavingsPostingInterestPeriodType)interestPostingPeriodType, (SavingsInterestCalculationType)interestCalculationType, (SavingsInterestCalculationDaysInYearType)interestCalculationDaysInYearType, (BigDecimal)minRequiredOpeningBalance, (Integer)lockinPeriodFrequency, (SavingsPeriodFrequencyType)lockinPeriodFrequencyType, (boolean)iswithdrawalFeeApplicableForTransfer, (Set)charges, (boolean)allowOverdraft, (BigDecimal)overdraftLimit, (boolean)enforceMinRequiredBalance, (BigDecimal)minRequiredBalance, (BigDecimal)maxAllowedLienLimit, (boolean)lienAllowed, (BigDecimal)nominalAnnualInterestRateOverdraft, (BigDecimal)minOverdraftForInterestCalculation, (boolean)withHoldTax);
        account.setHelpers(this.savingsAccountTransactionSummaryWrapper, this.savingsHelper);
        account.validateNewApplicationState("savingsaccount");
        account.validateAccountValuesWithProduct();
        return account;
    }

    public SavingsAccount assembleFrom(Long savingsId, boolean backdatedTxnsAllowedTill) {
        SavingsAccount account = this.savingsAccountRepository.findSavingsWithNotFoundDetection(savingsId, backdatedTxnsAllowedTill);
        return this.loadTransactionsToSavingsAccount(account, backdatedTxnsAllowedTill);
    }

    public SavingsAccount loadTransactionsToSavingsAccount(SavingsAccount account, boolean backdatedTxnsAllowedTill) {
        List savingsAccountTransactions = null;
        if (backdatedTxnsAllowedTill) {
            boolean isNotPresent;
            LocalDate pivotDate = account.getSummary().getInterestPostedTillDate();
            boolean bl = isNotPresent = pivotDate == null;
            if (!isNotPresent) {
                if (this.isRelaxingDaysConfigForPivotDateEnabled()) {
                    Long relaxingDaysForPivotDate = this.configurationDomainService.retrieveRelaxingDaysConfigForPivotDate();
                    LocalDate interestPostedTillDate = account.getSummary().getInterestPostedTillDate();
                    savingsAccountTransactions = this.savingsAccountRepository.findTransactionsAfterPivotDate(account, interestPostedTillDate.minusDays(relaxingDaysForPivotDate));
                    ((SavingsAccountTransaction)savingsAccountTransactions.get(0)).getSavingsAccount().setStartInterestCalculationDate(interestPostedTillDate.minusDays(relaxingDaysForPivotDate));
                    List pivotDateTransaction = this.savingsAccountRepository.findTransactionRunningBalanceBeforePivotDate(account, interestPostedTillDate.minusDays(relaxingDaysForPivotDate + 1L));
                    if (pivotDateTransaction != null && !pivotDateTransaction.isEmpty()) {
                        account.getSummary().setRunningBalanceOnPivotDate(((SavingsAccountTransaction)pivotDateTransaction.get(pivotDateTransaction.size() - 1)).getRunningBalance(account.getCurrency()).getAmount());
                    }
                } else {
                    savingsAccountTransactions = this.savingsAccountRepository.findTransactionsAfterPivotDate(account, account.getSummary().getInterestPostedTillDate());
                }
                if (savingsAccountTransactions != null && savingsAccountTransactions.size() > 0) {
                    account.setSavingsAccountTransactions(savingsAccountTransactions);
                }
            } else {
                savingsAccountTransactions = this.savingsAccountRepository.findAllTransactions(account);
                account.setSavingsAccountTransactions(savingsAccountTransactions);
            }
        }
        account.setHelpers(this.savingsAccountTransactionSummaryWrapper, this.savingsHelper);
        return account;
    }

    public SavingsAccountData assembleSavings(SavingsAccountData account) {
        boolean backdatedTxnsAllowedTill = this.configurationDomainService.retrievePivotDateConfig();
        if (backdatedTxnsAllowedTill && account.getSavingsAccountTransactionData() != null && account.getSummary().getInterestPostedTillDate() != null) {
            ArrayList<SavingsAccountTransactionData> removalList = new ArrayList<SavingsAccountTransactionData>();
            for (int i = 0; i < account.getSavingsAccountTransactionData().size(); ++i) {
                SavingsAccountTransactionData savingsAccountTransaction = (SavingsAccountTransactionData)account.getSavingsAccountTransactionData().get(i);
                removalList.add(savingsAccountTransaction);
                if (!savingsAccountTransaction.isInterestPostingAndNotReversed() && !savingsAccountTransaction.isOverdraftInterestAndNotReversed() || savingsAccountTransaction.isReversalTransaction()) continue;
                account.getSummary().setRunningBalanceOnPivotDate(savingsAccountTransaction.getRunningBalance());
                account.setLastSavingsAccountTransaction(savingsAccountTransaction);
                break;
            }
            account.getSavingsAccountTransactionData().removeAll(removalList);
        } else {
            account.getSummary().setRunningBalanceOnPivotDate(BigDecimal.ZERO);
        }
        account.setHelpers(this.savingsAccountTransactionDataSummaryWrapper, this.savingsHelper);
        return account;
    }

    public boolean getPivotConfigStatus() {
        return this.configurationDomainService.retrievePivotDateConfig();
    }

    public boolean isRelaxingDaysConfigForPivotDateEnabled() {
        return this.configurationDomainService.isRelaxingDaysConfigForPivotDateEnabled();
    }

    public void setHelpers(SavingsAccount account) {
        account.setHelpers(this.savingsAccountTransactionSummaryWrapper, this.savingsHelper);
    }

    public SavingsAccount assembleFrom(Client client, Group group, Long productId, LocalDate appliedonDate, AppUser appliedBy) {
        AccountType accountType = AccountType.INVALID;
        if (client != null) {
            accountType = AccountType.INDIVIDUAL;
            if (client.isNotActive()) {
                throw new ClientNotActiveException((Long)client.getId());
            }
        }
        if (group != null) {
            accountType = AccountType.GROUP;
            if (group.isNotActive()) {
                if (group.isCenter()) {
                    throw new CenterNotActiveException((Long)group.getId());
                }
                throw new GroupNotActiveException((Long)group.getId());
            }
        }
        if (group != null && client != null) {
            if (!group.hasClientAsMember(client)) {
                throw new ClientNotInGroupException((Long)client.getId(), (Long)group.getId());
            }
            accountType = AccountType.JLG;
        }
        SavingsProduct product = (SavingsProduct)this.savingProductRepository.findById((Object)productId).orElseThrow();
        Set charges = this.savingsAccountChargeAssembler.fromSavingsProduct(product);
        SavingsAccount account = SavingsAccount.createNewApplicationForSubmittal((Client)client, (Group)group, (SavingsProduct)product, null, null, null, (AccountType)accountType, (LocalDate)appliedonDate, (AppUser)appliedBy, (BigDecimal)product.nominalAnnualInterestRate(), (SavingsCompoundingInterestPeriodType)product.interestCompoundingPeriodType(), (SavingsPostingInterestPeriodType)product.interestPostingPeriodType(), (SavingsInterestCalculationType)product.interestCalculationType(), (SavingsInterestCalculationDaysInYearType)product.interestCalculationDaysInYearType(), (BigDecimal)product.minRequiredOpeningBalance(), (Integer)product.lockinPeriodFrequency(), (SavingsPeriodFrequencyType)product.lockinPeriodFrequencyType(), (boolean)product.isWithdrawalFeeApplicableForTransfer(), (Set)charges, (boolean)product.isAllowOverdraft(), (BigDecimal)product.overdraftLimit(), (boolean)product.isMinRequiredBalanceEnforced(), (BigDecimal)product.minRequiredBalance(), (BigDecimal)product.maxAllowedLienLimit(), (boolean)product.isLienAllowed(), (BigDecimal)product.nominalAnnualInterestRateOverdraft(), (BigDecimal)product.minOverdraftForInterestCalculation(), (boolean)product.withHoldTax());
        account.setHelpers(this.savingsAccountTransactionSummaryWrapper, this.savingsHelper);
        account.validateNewApplicationState("savingsaccount");
        account.validateAccountValuesWithProduct();
        return account;
    }

    public void assignSavingAccountHelpers(SavingsAccount savingsAccount) {
        savingsAccount.setHelpers(this.savingsAccountTransactionSummaryWrapper, this.savingsHelper);
    }

    public void assignSavingAccountHelpers(SavingsAccountData savingsAccountData) {
        savingsAccountData.setHelpers(this.savingsAccountTransactionDataSummaryWrapper, this.savingsHelper);
    }
}

