/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.domain;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.UnsupportedParameterException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepositoryWrapper;
import org.apache.fineract.portfolio.account.service.AccountTransfersReadPlatformService;
import org.apache.fineract.portfolio.accountdetails.domain.AccountType;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.client.exception.ClientNotActiveException;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepositoryWrapper;
import org.apache.fineract.portfolio.group.exception.CenterNotActiveException;
import org.apache.fineract.portfolio.group.exception.ClientNotInGroupException;
import org.apache.fineract.portfolio.group.exception.GroupNotActiveException;
import org.apache.fineract.portfolio.interestratechart.domain.InterestRateChart;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetailAssembler;
import org.apache.fineract.portfolio.savings.DepositAccountOnClosureType;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.SavingsCompoundingInterestPeriodType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationDaysInYearType;
import org.apache.fineract.portfolio.savings.SavingsInterestCalculationType;
import org.apache.fineract.portfolio.savings.SavingsPeriodFrequencyType;
import org.apache.fineract.portfolio.savings.SavingsPostingInterestPeriodType;
import org.apache.fineract.portfolio.savings.data.SavingsAccountTransactionDTO;
import org.apache.fineract.portfolio.savings.domain.DepositAccountInterestRateChart;
import org.apache.fineract.portfolio.savings.domain.DepositAccountRecurringDetail;
import org.apache.fineract.portfolio.savings.domain.DepositAccountTermAndPreClosure;
import org.apache.fineract.portfolio.savings.domain.DepositPreClosureDetail;
import org.apache.fineract.portfolio.savings.domain.DepositProductAssembler;
import org.apache.fineract.portfolio.savings.domain.DepositProductRecurringDetail;
import org.apache.fineract.portfolio.savings.domain.DepositProductTermAndPreClosure;
import org.apache.fineract.portfolio.savings.domain.DepositRecurringDetail;
import org.apache.fineract.portfolio.savings.domain.DepositTermDetail;
import org.apache.fineract.portfolio.savings.domain.FixedDepositAccount;
import org.apache.fineract.portfolio.savings.domain.FixedDepositProduct;
import org.apache.fineract.portfolio.savings.domain.FixedDepositProductRepository;
import org.apache.fineract.portfolio.savings.domain.RecurringDepositAccount;
import org.apache.fineract.portfolio.savings.domain.RecurringDepositProduct;
import org.apache.fineract.portfolio.savings.domain.RecurringDepositProductRepository;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountChargeAssembler;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountRepositoryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransactionSummaryWrapper;
import org.apache.fineract.portfolio.savings.domain.SavingsHelper;
import org.apache.fineract.portfolio.savings.domain.SavingsProduct;
import org.apache.fineract.portfolio.savings.exception.FixedDepositProductNotFoundException;
import org.apache.fineract.portfolio.savings.exception.RecurringDepositProductNotFoundException;
import org.apache.fineract.portfolio.savings.exception.SavingsProductNotFoundException;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DepositAccountAssembler {
    private final PlatformSecurityContext context;
    private final SavingsAccountTransactionSummaryWrapper savingsAccountTransactionSummaryWrapper;
    private final SavingsHelper savingsHelper;
    private final ClientRepositoryWrapper clientRepository;
    private final GroupRepositoryWrapper groupRepository;
    private final StaffRepositoryWrapper staffRepository;
    private final FixedDepositProductRepository fixedDepositProductRepository;
    private final RecurringDepositProductRepository recurringDepositProductRepository;
    private final SavingsAccountRepositoryWrapper savingsAccountRepository;
    private final SavingsAccountChargeAssembler savingsAccountChargeAssembler;
    private final FromJsonHelper fromApiJsonHelper;
    private final DepositProductAssembler depositProductAssembler;
    private final PaymentDetailAssembler paymentDetailAssembler;
    private final ExternalIdFactory externalIdFactory;

    @Autowired
    public DepositAccountAssembler(SavingsAccountTransactionSummaryWrapper savingsAccountTransactionSummaryWrapper, ClientRepositoryWrapper clientRepository, GroupRepositoryWrapper groupRepository, StaffRepositoryWrapper staffRepository, FixedDepositProductRepository fixedDepositProductRepository, SavingsAccountRepositoryWrapper savingsAccountRepository, SavingsAccountChargeAssembler savingsAccountChargeAssembler, FromJsonHelper fromApiJsonHelper, DepositProductAssembler depositProductAssembler, RecurringDepositProductRepository recurringDepositProductRepository, AccountTransfersReadPlatformService accountTransfersReadPlatformService, PlatformSecurityContext context, PaymentDetailAssembler paymentDetailAssembler, ExternalIdFactory externalIdFactory) {
        this.savingsAccountTransactionSummaryWrapper = savingsAccountTransactionSummaryWrapper;
        this.clientRepository = clientRepository;
        this.groupRepository = groupRepository;
        this.staffRepository = staffRepository;
        this.fixedDepositProductRepository = fixedDepositProductRepository;
        this.savingsAccountRepository = savingsAccountRepository;
        this.savingsAccountChargeAssembler = savingsAccountChargeAssembler;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.depositProductAssembler = depositProductAssembler;
        this.recurringDepositProductRepository = recurringDepositProductRepository;
        this.savingsHelper = new SavingsHelper(accountTransfersReadPlatformService);
        this.context = context;
        this.paymentDetailAssembler = paymentDetailAssembler;
        this.externalIdFactory = externalIdFactory;
    }

    public SavingsAccount assembleFrom(JsonCommand command, AppUser submittedBy, DepositAccountType depositAccountType) {
        Long fieldOfficerId;
        Long groupId;
        JsonElement element = command.parsedJson();
        String accountNo = this.fromApiJsonHelper.extractStringNamed("accountNo", element);
        String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
        Long productId = this.fromApiJsonHelper.extractLongNamed("productId", element);
        SavingsProduct product = null;
        if (depositAccountType.isFixedDeposit()) {
            product = (SavingsProduct)this.fixedDepositProductRepository.findById((Object)productId).orElseThrow(() -> new FixedDepositProductNotFoundException(productId));
        } else if (depositAccountType.isRecurringDeposit()) {
            product = (SavingsProduct)this.recurringDepositProductRepository.findById((Object)productId).orElseThrow(() -> new RecurringDepositProductNotFoundException(productId));
        }
        if (product == null) {
            throw new SavingsProductNotFoundException(productId);
        }
        Client client = null;
        Group group = null;
        Staff fieldOfficer = null;
        AccountType accountType = AccountType.INVALID;
        Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
        if (clientId != null) {
            boolean isCalendarInherited = command.booleanPrimitiveValueOfParameterNamed("isCalendarInherited");
            client = this.clientRepository.findOneWithNotFoundDetection(clientId, isCalendarInherited);
            accountType = AccountType.INDIVIDUAL;
            if (client.isNotActive()) {
                throw new ClientNotActiveException(clientId);
            }
        }
        if ((groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element)) != null) {
            group = this.groupRepository.findOneWithNotFoundDetection(groupId);
            accountType = AccountType.GROUP;
        }
        if (group != null && client != null) {
            if (!group.hasClientAsMember(client)) {
                throw new ClientNotInGroupException(clientId, groupId);
            }
            accountType = AccountType.JLG;
            if (group.isNotActive()) {
                if (group.isCenter()) {
                    throw new CenterNotActiveException(groupId);
                }
                throw new GroupNotActiveException(groupId);
            }
        }
        if ((fieldOfficerId = this.fromApiJsonHelper.extractLongNamed("fieldOfficerId", element)) != null) {
            fieldOfficer = this.staffRepository.findOneWithNotFoundDetection(fieldOfficerId);
        }
        LocalDate submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
        BigDecimal interestRate = null;
        interestRate = command.parameterExists("nominalAnnualInterestRate") ? command.bigDecimalValueOfParameterNamed("nominalAnnualInterestRate") : product.nominalAnnualInterestRate();
        SavingsCompoundingInterestPeriodType interestCompoundingPeriodType = null;
        Integer interestPeriodTypeValue = command.integerValueOfParameterNamed("interestCompoundingPeriodType");
        interestCompoundingPeriodType = interestPeriodTypeValue != null ? SavingsCompoundingInterestPeriodType.fromInt((Integer)interestPeriodTypeValue) : product.interestCompoundingPeriodType();
        SavingsPostingInterestPeriodType interestPostingPeriodType = null;
        Integer interestPostingPeriodTypeValue = command.integerValueOfParameterNamed("interestPostingPeriodType");
        interestPostingPeriodType = interestPostingPeriodTypeValue != null ? SavingsPostingInterestPeriodType.fromInt((Integer)interestPostingPeriodTypeValue) : product.interestPostingPeriodType();
        SavingsInterestCalculationType interestCalculationType = null;
        Integer interestCalculationTypeValue = command.integerValueOfParameterNamed("interestCalculationType");
        interestCalculationType = interestCalculationTypeValue != null ? SavingsInterestCalculationType.fromInt((Integer)interestCalculationTypeValue) : product.interestCalculationType();
        SavingsInterestCalculationDaysInYearType interestCalculationDaysInYearType = null;
        Integer interestCalculationDaysInYearTypeValue = command.integerValueOfParameterNamed("interestCalculationDaysInYearType");
        interestCalculationDaysInYearType = interestCalculationDaysInYearTypeValue != null ? SavingsInterestCalculationDaysInYearType.fromInt((Integer)interestCalculationDaysInYearTypeValue) : product.interestCalculationDaysInYearType();
        BigDecimal minRequiredOpeningBalance = null;
        minRequiredOpeningBalance = command.parameterExists("minRequiredOpeningBalance") ? command.bigDecimalValueOfParameterNamed("minRequiredOpeningBalance") : product.minRequiredOpeningBalance();
        Integer lockinPeriodFrequency = null;
        lockinPeriodFrequency = command.parameterExists("lockinPeriodFrequency") ? command.integerValueOfParameterNamed("lockinPeriodFrequency") : product.lockinPeriodFrequency();
        SavingsPeriodFrequencyType lockinPeriodFrequencyType = null;
        if (command.parameterExists("lockinPeriodFrequencyType")) {
            Integer lockinPeriodFrequencyTypeValue = null;
            lockinPeriodFrequencyTypeValue = command.integerValueOfParameterNamed("lockinPeriodFrequencyType");
            if (lockinPeriodFrequencyTypeValue != null) {
                lockinPeriodFrequencyType = SavingsPeriodFrequencyType.fromInt((Integer)lockinPeriodFrequencyTypeValue);
            }
        } else {
            lockinPeriodFrequencyType = product.lockinPeriodFrequencyType();
        }
        boolean iswithdrawalFeeApplicableForTransfer = false;
        if (command.parameterExists("withdrawalFeeForTransfers")) {
            iswithdrawalFeeApplicableForTransfer = command.booleanPrimitiveValueOfParameterNamed("withdrawalFeeForTransfers");
        }
        Set charges = this.savingsAccountChargeAssembler.fromParsedJson(element, product.currency().getCode());
        DepositAccountInterestRateChart accountChart = null;
        InterestRateChart productChart = null;
        if (command.parameterExists("chartId")) {
            Long chartId = command.longValueOfParameterNamed("chartId");
            productChart = product.findChart(chartId);
        } else {
            productChart = product.applicableChart(submittedOnDate);
        }
        if (productChart != null) {
            accountChart = DepositAccountInterestRateChart.from((InterestRateChart)productChart);
        }
        boolean withHoldTax = product.withHoldTax();
        if (command.parameterExists("withHoldTax") && (withHoldTax = command.booleanPrimitiveValueOfParameterNamed("withHoldTax")) && product.getTaxGroup() == null) {
            throw new UnsupportedParameterException(Arrays.asList("withHoldTax"));
        }
        Integer depositRolloverId = null;
        if (command.parameterExists("maturityInstructionId")) {
            depositRolloverId = command.integerValueOfParameterNamed("maturityInstructionId");
        }
        FixedDepositAccount account = null;
        if (depositAccountType.isFixedDeposit()) {
            DepositProductTermAndPreClosure prodTermAndPreClosure = ((FixedDepositProduct)product).depositProductTermAndPreClosure();
            DepositAccountTermAndPreClosure accountTermAndPreClosure = this.assembleAccountTermAndPreClosure(command, prodTermAndPreClosure);
            FixedDepositAccount fdAccount = FixedDepositAccount.createNewApplicationForSubmittal((Client)client, (Group)group, (SavingsProduct)product, (Staff)fieldOfficer, (String)accountNo, (ExternalId)this.externalIdFactory.create(externalId), (AccountType)accountType, (LocalDate)submittedOnDate, (AppUser)submittedBy, (BigDecimal)interestRate, (SavingsCompoundingInterestPeriodType)interestCompoundingPeriodType, (SavingsPostingInterestPeriodType)interestPostingPeriodType, (SavingsInterestCalculationType)interestCalculationType, (SavingsInterestCalculationDaysInYearType)interestCalculationDaysInYearType, (BigDecimal)minRequiredOpeningBalance, (Integer)lockinPeriodFrequency, (SavingsPeriodFrequencyType)lockinPeriodFrequencyType, (boolean)iswithdrawalFeeApplicableForTransfer, (Set)charges, (DepositAccountTermAndPreClosure)accountTermAndPreClosure, (DepositAccountInterestRateChart)accountChart, (boolean)withHoldTax);
            accountTermAndPreClosure.updateAccountReference((SavingsAccount)fdAccount);
            fdAccount.validateDomainRules();
            account = fdAccount;
        } else if (depositAccountType.isRecurringDeposit()) {
            DepositProductTermAndPreClosure prodTermAndPreClosure = ((RecurringDepositProduct)product).depositProductTermAndPreClosure();
            DepositAccountTermAndPreClosure accountTermAndPreClosure = this.assembleAccountTermAndPreClosure(command, prodTermAndPreClosure);
            DepositProductRecurringDetail prodRecurringDetail = ((RecurringDepositProduct)product).depositRecurringDetail();
            DepositAccountRecurringDetail accountRecurringDetail = this.assembleAccountRecurringDetail(command, prodRecurringDetail.recurringDetail());
            RecurringDepositAccount rdAccount = RecurringDepositAccount.createNewApplicationForSubmittal((Client)client, (Group)group, (SavingsProduct)product, (Staff)fieldOfficer, (String)accountNo, (ExternalId)this.externalIdFactory.create(externalId), (AccountType)accountType, (LocalDate)submittedOnDate, (AppUser)submittedBy, (BigDecimal)interestRate, (SavingsCompoundingInterestPeriodType)interestCompoundingPeriodType, (SavingsPostingInterestPeriodType)interestPostingPeriodType, (SavingsInterestCalculationType)interestCalculationType, (SavingsInterestCalculationDaysInYearType)interestCalculationDaysInYearType, (BigDecimal)minRequiredOpeningBalance, (Integer)lockinPeriodFrequency, (SavingsPeriodFrequencyType)lockinPeriodFrequencyType, (boolean)iswithdrawalFeeApplicableForTransfer, (Set)charges, (DepositAccountTermAndPreClosure)accountTermAndPreClosure, (DepositAccountRecurringDetail)accountRecurringDetail, (DepositAccountInterestRateChart)accountChart, (boolean)withHoldTax);
            accountTermAndPreClosure.updateAccountReference((SavingsAccount)rdAccount);
            accountRecurringDetail.updateAccountReference((SavingsAccount)rdAccount);
            rdAccount.validateDomainRules();
            account = rdAccount;
        }
        if (account != null) {
            account.setHelpers(this.savingsAccountTransactionSummaryWrapper, this.savingsHelper);
            account.validateNewApplicationState(depositAccountType.resourceName());
        }
        return account;
    }

    public SavingsAccount assembleFrom(Long savingsId, DepositAccountType depositAccountType) {
        SavingsAccount account = this.savingsAccountRepository.findOneWithNotFoundDetection(savingsId, depositAccountType);
        account.setHelpers(this.savingsAccountTransactionSummaryWrapper, this.savingsHelper);
        return account;
    }

    public void assignSavingAccountHelpers(SavingsAccount savingsAccount) {
        savingsAccount.setHelpers(this.savingsAccountTransactionSummaryWrapper, this.savingsHelper);
    }

    public DepositAccountTermAndPreClosure assembleAccountTermAndPreClosure(JsonCommand command, DepositProductTermAndPreClosure productTermAndPreclosure) {
        DepositPreClosureDetail productPreClosure = productTermAndPreclosure == null ? null : productTermAndPreclosure.depositPreClosureDetail();
        DepositTermDetail productTerm = productTermAndPreclosure == null ? null : productTermAndPreclosure.depositTermDetail();
        DepositPreClosureDetail updatedProductPreClosure = this.depositProductAssembler.assemblePreClosureDetail(command, productPreClosure);
        DepositTermDetail updatedProductTerm = this.depositProductAssembler.assembleDepositTermDetail(command, productTerm);
        BigDecimal depositAmount = command.bigDecimalValueOfParameterNamed("depositAmount");
        Integer depositPeriod = command.integerValueOfParameterNamed("depositPeriod");
        Integer depositPeriodFrequencyId = command.integerValueOfParameterNamed("depositPeriodFrequencyId");
        SavingsPeriodFrequencyType depositPeriodFrequency = SavingsPeriodFrequencyType.fromInt((Integer)depositPeriodFrequencyId);
        SavingsAccount account = null;
        LocalDate expectedFirstDepositOnDate = command.localDateValueOfParameterNamed("expectedFirstDepositOnDate");
        Boolean trasferInterest = command.booleanPrimitiveValueOfParameterNamed("transferInterestToSavings");
        BigDecimal maturityAmount = null;
        LocalDate maturityDate = null;
        Integer accountOnClosureTypeId = command.integerValueOfParameterNamed("maturityInstructionId");
        DepositAccountOnClosureType accountOnClosureType = accountOnClosureTypeId != null ? DepositAccountOnClosureType.fromInt((Integer)accountOnClosureTypeId) : null;
        Long transferToSavingsId = command.longValueOfParameterNamed("transferToSavingsId");
        return DepositAccountTermAndPreClosure.createNew((DepositPreClosureDetail)updatedProductPreClosure, (DepositTermDetail)updatedProductTerm, account, (BigDecimal)depositAmount, maturityAmount, maturityDate, (Integer)depositPeriod, (SavingsPeriodFrequencyType)depositPeriodFrequency, (LocalDate)expectedFirstDepositOnDate, (DepositAccountOnClosureType)accountOnClosureType, (Boolean)trasferInterest, (Long)transferToSavingsId);
    }

    public DepositAccountRecurringDetail assembleAccountRecurringDetail(JsonCommand command, DepositRecurringDetail prodRecurringDetail) {
        BigDecimal recurringDepositAmount = command.bigDecimalValueOfParameterNamed("mandatoryRecommendedDepositAmount");
        boolean isMandatoryDeposit = command.parameterExists("isMandatoryDeposit") ? command.booleanObjectValueOfParameterNamed("isMandatoryDeposit").booleanValue() : prodRecurringDetail.isMandatoryDeposit();
        boolean allowWithdrawal = command.parameterExists("allowWithdrawal") ? command.booleanObjectValueOfParameterNamed("allowWithdrawal").booleanValue() : prodRecurringDetail.allowWithdrawal();
        boolean adjustAdvanceTowardsFuturePayments = command.parameterExists("adjustAdvanceTowardsFuturePayments") ? command.booleanObjectValueOfParameterNamed("adjustAdvanceTowardsFuturePayments").booleanValue() : prodRecurringDetail.adjustAdvanceTowardsFuturePayments();
        boolean isCalendarInherited = command.parameterExists("isCalendarInherited") ? command.booleanObjectValueOfParameterNamed("isCalendarInherited") : false;
        DepositRecurringDetail depositRecurringDetail = DepositRecurringDetail.createFrom((boolean)isMandatoryDeposit, (boolean)allowWithdrawal, (boolean)adjustAdvanceTowardsFuturePayments);
        return DepositAccountRecurringDetail.createNew((BigDecimal)recurringDepositAmount, (DepositRecurringDetail)depositRecurringDetail, null, (boolean)isCalendarInherited);
    }

    public Collection<SavingsAccountTransactionDTO> assembleBulkMandatorySavingsAccountTransactionDTOs(JsonCommand command, PaymentDetail paymentDetail) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList<SavingsAccountTransactionDTO> savingsAccountTransactions = new ArrayList<SavingsAccountTransactionDTO>();
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        String dateFormat = this.fromApiJsonHelper.extractDateFormatParameter(element.getAsJsonObject());
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat).withLocale(locale);
        if (element.isJsonObject() && topLevelJsonElement.has("bulkSavingsDueTransactions") && topLevelJsonElement.get("bulkSavingsDueTransactions").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("bulkSavingsDueTransactions").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonObject savingsTransactionElement = array.get(i).getAsJsonObject();
                Long savingsId = this.fromApiJsonHelper.extractLongNamed("savingsId", (JsonElement)savingsTransactionElement);
                BigDecimal dueAmount = this.fromApiJsonHelper.extractBigDecimalNamed("transactionAmount", (JsonElement)savingsTransactionElement, locale);
                Integer depositAccountType = this.fromApiJsonHelper.extractIntegerNamed("depositAccountType", (JsonElement)savingsTransactionElement, locale);
                PaymentDetail detail = paymentDetail;
                if (paymentDetail == null) {
                    detail = this.paymentDetailAssembler.fetchPaymentDetail(savingsTransactionElement);
                }
                SavingsAccountTransactionDTO savingsAccountTransactionDTO = new SavingsAccountTransactionDTO(formatter, transactionDate, dueAmount, detail, savingsId, depositAccountType);
                savingsAccountTransactions.add(savingsAccountTransactionDTO);
            }
        }
        return savingsAccountTransactions;
    }
}

