/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.api;

import com.google.gson.JsonElement;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.GlobalEntityType;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookPopulatorService;
import org.apache.fineract.infrastructure.bulkimport.service.BulkImportWorkbookService;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.api.JsonQuery;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.PaginationParameters;
import org.apache.fineract.infrastructure.core.data.UploadRequest;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.portfolio.account.data.PortfolioAccountData;
import org.apache.fineract.portfolio.account.service.AccountAssociationsReadPlatformService;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.DepositsApiConstants;
import org.apache.fineract.portfolio.savings.api.FixedDepositAccountsApiResourceSwagger;
import org.apache.fineract.portfolio.savings.data.DepositAccountData;
import org.apache.fineract.portfolio.savings.data.FixedDepositAccountData;
import org.apache.fineract.portfolio.savings.data.SavingsAccountChargeData;
import org.apache.fineract.portfolio.savings.service.DepositAccountPreMatureCalculationPlatformService;
import org.apache.fineract.portfolio.savings.service.DepositAccountReadPlatformService;
import org.apache.fineract.portfolio.savings.service.FixedDepositAccountInterestCalculationService;
import org.apache.fineract.portfolio.savings.service.SavingsAccountChargeReadPlatformService;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Path(value="/v1/fixeddepositaccounts")
@Component
@Tag(name="Fixed Deposit Account", description="Fixed Deposit accounts are instances of a praticular fixed deposit product created. An application process around the creation of accounts is also supported.")
public class FixedDepositAccountsApiResource {
    private final DepositAccountReadPlatformService depositAccountReadPlatformService;
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<DepositAccountData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final SavingsAccountChargeReadPlatformService savingsAccountChargeReadPlatformService;
    private final FromJsonHelper fromJsonHelper;
    private final DepositAccountPreMatureCalculationPlatformService accountPreMatureCalculationPlatformService;
    private final AccountAssociationsReadPlatformService accountAssociationsReadPlatformService;
    private final BulkImportWorkbookService bulkImportWorkbookService;
    private final BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService;
    private final FixedDepositAccountInterestCalculationService fixedDepositAccountInterestCalculationService;
    private final SqlValidator sqlValidator;

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Fixed Deposit Account Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for fixed deposit applications. The template data returned consists of any or all of:\n\n\n\nField Defaults\n\nAllowed Value ListsExample Requests:\n\n\n\nfixeddepositaccounts/template?clientId=1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=FixedDepositAccountsApiResourceSwagger.GetFixedDepositAccountsTemplateResponse.class))})})
    public String template(@QueryParam(value="clientId") @Parameter(description="clientId") Long clientId, @QueryParam(value="groupId") @Parameter(description="groupId") Long groupId, @QueryParam(value="productId") @Parameter(description="productId") Long productId, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("fixeddepositaccount");
        DepositAccountData account = this.depositAccountReadPlatformService.retrieveTemplate(DepositAccountType.FIXED_DEPOSIT, clientId, groupId, productId, staffInSelectedOfficeOnly);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)account, DepositsApiConstants.FIXED_DEPOSIT_ACCOUNT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Fixed deposit applications/accounts", description="Lists Fixed Deposit Accounts\n\nExample Requests:\n\n\n\nfixeddepositaccounts\n\n\n\nfixeddepositaccounts?fields=name")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FixedDepositAccountsApiResourceSwagger.GetFixedDepositAccountsResponse.class)))})})
    public String retrieveAll(@Context UriInfo uriInfo, @QueryParam(value="paged") @Parameter(description="paged") Boolean paged, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder) {
        this.context.authenticatedUser().validateHasReadPermission("fixeddepositaccount");
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        PaginationParameters paginationParameters = PaginationParameters.builder().paged(Boolean.TRUE.equals(paged)).limit(limit).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (paginationParameters.isPaged()) {
            Page account = this.depositAccountReadPlatformService.retrieveAllPaged(DepositAccountType.FIXED_DEPOSIT, paginationParameters);
            return this.toApiJsonSerializer.serialize(settings, account, DepositsApiConstants.FIXED_DEPOSIT_ACCOUNT_RESPONSE_DATA_PARAMETERS);
        }
        Collection account = this.depositAccountReadPlatformService.retrieveAll(DepositAccountType.FIXED_DEPOSIT, paginationParameters);
        return this.toApiJsonSerializer.serialize(settings, account, DepositsApiConstants.FIXED_DEPOSIT_ACCOUNT_RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Submit new fixed deposit application", description="Submits a new fixed deposit applicationMandatory Fields: clientId or groupId, productId, submittedOnDate, depositAmount, depositPeriod, depositPeriodFrequencyId\n\nOptional Fields: accountNo, externalId, fieldOfficerId,linkAccountId(if provided initial deposit amount will be collected from this account),transferInterestToSavings(By enabling this flag all interest postings will be transferred to linked saving account )")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=FixedDepositAccountsApiResourceSwagger.PostFixedDepositAccountsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=FixedDepositAccountsApiResourceSwagger.PostFixedDepositAccountsResponse.class))})})
    public String submitApplication(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createFixedDepositAccount().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a fixed deposit application/account", description="Retrieves a fixed deposit application/account\n\nExample Requests :\n\n\n\nfixeddepositaccounts/1\n\nfixeddepositaccounts/1?associations=all")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=FixedDepositAccountsApiResourceSwagger.GetFixedDepositAccountsAccountIdResponse.class))})})
    public String retrieveOne(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @DefaultValue(value="false") @QueryParam(value="staffInSelectedOfficeOnly") @Parameter(description="staffInSelectedOfficeOnly") boolean staffInSelectedOfficeOnly, @DefaultValue(value="all") @QueryParam(value="chargeStatus") @Parameter(description="chargeStatus") String chargeStatus, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("fixeddepositaccount");
        if (!(this.is(chargeStatus, "all") || this.is(chargeStatus, "active") || this.is(chargeStatus, "inactive"))) {
            throw new UnrecognizedQueryParamException("status", chargeStatus, new Object[]{"all", "active", "inactive"});
        }
        FixedDepositAccountData account = (FixedDepositAccountData)this.depositAccountReadPlatformService.retrieveOneWithChartSlabs(DepositAccountType.FIXED_DEPOSIT, accountId);
        HashSet mandatoryResponseParameters = new HashSet();
        FixedDepositAccountData accountTemplate = this.populateTemplateAndAssociations(accountId, account, staffInSelectedOfficeOnly, chargeStatus, uriInfo, mandatoryResponseParameters);
        accountTemplate.setActivationCharge(this.getActivationCharge(accountId));
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters(), mandatoryResponseParameters);
        return this.toApiJsonSerializer.serialize(settings, (Object)accountTemplate, DepositsApiConstants.FIXED_DEPOSIT_ACCOUNT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="calculate-fd-interest")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=FixedDepositAccountsApiResourceSwagger.CalculateFixedDepositInterestResponse.class))})})
    public String calculateFixedDepositInterest(@Context UriInfo uriInfo, @QueryParam(value="principalAmount") @Parameter(description="BigDecimal principalAmount") BigDecimal principalAmount, @QueryParam(value="annualInterestRate") @Parameter(description="annualInterestRate") BigDecimal annualInterestRate, @QueryParam(value="tenureInMonths") @Parameter(description="tenureInMonths") Long tenureInMonths, @QueryParam(value="interestCompoundingPeriodInMonths") @Parameter(description="interestCompoundingPeriodInMonths") Long interestCompoundingPeriodInMonths, @QueryParam(value="interestPostingPeriodInMonths") @Parameter(description="interestPostingPeriodInMonths") Long interestPostingPeriodInMonths) {
        HashMap<String, Number> request = new HashMap<String, Number>();
        request.put("annualInterestRate", annualInterestRate);
        request.put("tenureInMonths", tenureInMonths);
        request.put("interestCompoundingPeriodInMonths", interestCompoundingPeriodInMonths);
        request.put("interestPostingPeriodInMonths", interestPostingPeriodInMonths);
        request.put("principalAmount", principalAmount);
        String apiRequestBodyAsJson = this.toApiJsonSerializer.serialize(request);
        JsonElement jsonElement = this.fromJsonHelper.parse(apiRequestBodyAsJson);
        HashMap result = this.fixedDepositAccountInterestCalculationService.calculateInterest(new JsonQuery(apiRequestBodyAsJson, jsonElement, this.fromJsonHelper));
        return this.toApiJsonSerializer.serializeResult((Object)result);
    }

    private BigDecimal getActivationCharge(Long accountId) {
        BigDecimal activationCharge = BigDecimal.ZERO;
        Collection savingCharges = this.savingsAccountChargeReadPlatformService.retrieveSavingsAccountCharges(accountId, "active");
        for (SavingsAccountChargeData savingsAccountChargeData : savingCharges) {
            if (!savingsAccountChargeData.isSavingsActivation()) continue;
            activationCharge = activationCharge.add(savingsAccountChargeData.getAmountOutstanding());
        }
        return activationCharge;
    }

    private FixedDepositAccountData populateTemplateAndAssociations(Long accountId, FixedDepositAccountData savingsAccount, boolean staffInSelectedOfficeOnly, String chargeStatus, UriInfo uriInfo, Set<String> mandatoryResponseParameters) {
        Collection transactions = null;
        Collection charges = null;
        PortfolioAccountData linkedAccount = null;
        PortfolioAccountData transferToSavingsAccount = null;
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        if (!associationParameters.isEmpty()) {
            if (associationParameters.contains("all")) {
                associationParameters.addAll(Arrays.asList("transactions", "charges", "linkedAccount"));
            }
            if (associationParameters.contains("transactions")) {
                mandatoryResponseParameters.add("transactions");
                Collection currentTransactions = this.depositAccountReadPlatformService.retrieveAllTransactions(DepositAccountType.FIXED_DEPOSIT, accountId);
                if (!CollectionUtils.isEmpty((Collection)currentTransactions)) {
                    transactions = currentTransactions;
                }
            }
            if (associationParameters.contains("charges")) {
                mandatoryResponseParameters.add("charges");
                Collection currentCharges = this.savingsAccountChargeReadPlatformService.retrieveSavingsAccountCharges(accountId, chargeStatus);
                if (!CollectionUtils.isEmpty((Collection)currentCharges)) {
                    charges = currentCharges;
                }
            }
            if (associationParameters.contains("linkedAccount")) {
                mandatoryResponseParameters.add("linkedAccount");
                linkedAccount = this.accountAssociationsReadPlatformService.retriveSavingsLinkedAssociation(accountId);
            }
        }
        if (savingsAccount.getTransferToSavingsId() != null) {
            transferToSavingsAccount = this.accountAssociationsReadPlatformService.retriveSavingsAccount(savingsAccount.getTransferToSavingsId());
        }
        FixedDepositAccountData templateData = null;
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (settings.isTemplate()) {
            templateData = (FixedDepositAccountData)this.depositAccountReadPlatformService.retrieveTemplate(DepositAccountType.FIXED_DEPOSIT, savingsAccount.getClientId(), savingsAccount.getGroupId(), savingsAccount.getDepositProductId(), staffInSelectedOfficeOnly);
        }
        return FixedDepositAccountData.associationsAndTemplate((FixedDepositAccountData)savingsAccount, templateData, transactions, charges, linkedAccount, (PortfolioAccountData)transferToSavingsAccount);
    }

    @PUT
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Modify a fixed deposit application", description="Fixed deposit application can only be modified when in 'Submitted and pending approval' state. Once the application is approved, the details cannot be changed using this method. Specific api endpoints will be created to allow change of interest detail such as rate, compounding period, posting period etc")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=FixedDepositAccountsApiResourceSwagger.PutFixedDepositAccountsAccountIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=FixedDepositAccountsApiResourceSwagger.PutFixedDepositAccountsAccountIdResponse.class))})})
    public String update(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateFixedDepositAccount(accountId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @POST
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Approve fixed deposit application | Undo approval fixed deposit application | Reject fixed deposit application | Withdraw fixed deposit application | Activate a fixed deposit account | Close a fixed deposit account | Premature Close a fixed deposit account | Calculate Premature amount on Fixed deposit account | Calculate Interest on Fixed Deposit Account | Post Interest on Fixed Deposit Account", description="Approve fixed deposit application:\n\nApproves fixed deposit application so long as its in 'Submitted and pending approval' state.\n\nUndo approval fixed deposit application:\n\nWill move 'approved' fixed deposit application back to 'Submitted and pending approval' state.\n\nReject fixed deposit application:\n\nRejects fixed deposit application so long as its in 'Submitted and pending approval' state.\n\nWithdraw fixed deposit application:\n\nUsed when an applicant withdraws from the fixed deposit application. It must be in 'Submitted and pending approval' state.\n\nClose a fixed deposit account:\n\nResults in a Matured fixed deposit account being converted into a 'closed' fixed deposit account.\n\nPremature Close a fixed deposit account:\n\nResults in an Active fixed deposit account being converted into a 'Premature Closed' fixed deposit account with options to withdraw prematured amount. (premature amount is calculated using interest rate chart applicable along with penal interest if any.)\n\nCalculate Premature amount on Fixed deposit account:\n\nCalculate premature amount on fixed deposit account till premature close date. Premature amount is calculated based on interest chart and penal interest applicable.\n\nCalculate Interest on Fixed Deposit Account:\n\nCalculates interest earned on a fixed deposit account based on todays date. It does not attempt to post or credit the interest on the account. That is responsibility of the Post Interest API that will likely be called by overnight process.\n\nPost Interest on Fixed Deposit Account:\n\nCalculates and Posts interest earned on a fixed deposit account based on today's date and whether an interest posting or crediting event is due.\n\nShowing request/response for Calculate Interest on Fixed Deposit Account")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=FixedDepositAccountsApiResourceSwagger.PostFixedDepositAccountsAccountIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=FixedDepositAccountsApiResourceSwagger.PostFixedDepositAccountsAccountIdResponse.class))})})
    public String handleCommands(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Context UriInfo uriInfo, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        String jsonApiRequest = apiRequestBodyAsJson;
        if (StringUtils.isBlank((CharSequence)jsonApiRequest)) {
            jsonApiRequest = "{}";
        }
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(jsonApiRequest);
        CommandProcessingResult result = null;
        if (this.is(commandParam, "reject")) {
            CommandWrapper commandRequest = builder.rejectFixedDepositAccountApplication(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "withdrawnByApplicant")) {
            CommandWrapper commandRequest = builder.withdrawFixedDepositAccountApplication(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "approve")) {
            CommandWrapper commandRequest = builder.approveFixedDepositAccountApplication(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "undoapproval")) {
            CommandWrapper commandRequest = builder.undoFixedDepositAccountApplication(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "activate")) {
            CommandWrapper commandRequest = builder.fixedDepositAccountActivation(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "calculateInterest")) {
            CommandWrapper commandRequest = builder.withNoJsonBody().fixedDepositAccountInterestCalculation(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "postInterest")) {
            CommandWrapper commandRequest = builder.fixedDepositAccountInterestPosting(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "close")) {
            CommandWrapper commandRequest = builder.closeFixedDepositAccount(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "prematureClose")) {
            CommandWrapper commandRequest = builder.prematureCloseFixedDepositAccount(accountId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, "calculatePrematureAmount")) {
            JsonElement parsedQuery = this.fromJsonHelper.parse(apiRequestBodyAsJson);
            JsonQuery query = JsonQuery.from((String)apiRequestBodyAsJson, (JsonElement)parsedQuery, (FromJsonHelper)this.fromJsonHelper);
            DepositAccountData account = this.accountPreMatureCalculationPlatformService.calculatePreMatureAmount(accountId, query, DepositAccountType.FIXED_DEPOSIT);
            ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
            return this.toApiJsonSerializer.serialize(settings, (Object)account, DepositsApiConstants.FIXED_DEPOSIT_ACCOUNT_RESPONSE_DATA_PARAMETERS);
        }
        if (result == null) {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[]{"reject", "withdrawnByApplicant", "approve", "undoapproval", "activate", "calculateInterest", "postInterest", "close", "prematureClose", "calculatePrematureAmount"});
        }
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @DELETE
    @Path(value="{accountId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a fixed deposit application", description="At present we support hard delete of fixed deposit application so long as its in 'Submitted and pending approval' state. One the application is moves past this state, it is not possible to do a 'hard' delete of the application or the account. An API endpoint will be added to close/de-activate the fixed deposit account.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=FixedDepositAccountsApiResourceSwagger.DeleteFixedDepositAccountsAccountIdResponse.class))})})
    public String delete(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteFixedDepositAccount(accountId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{accountId}/template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String accountClosureTemplate(@PathParam(value="accountId") @Parameter(description="accountId") Long accountId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("fixeddepositaccount");
        DepositAccountData account = null;
        if (this.is(commandParam, "close")) {
            account = this.depositAccountReadPlatformService.retrieveOneWithClosureTemplate(DepositAccountType.FIXED_DEPOSIT, accountId);
        }
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)account, DepositsApiConstants.FIXED_DEPOSIT_ACCOUNT_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getFixedDepositTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="staffId") Long staffId, @QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.FIXED_DEPOSIT_ACCOUNTS.toString(), officeId, staffId, dateFormat);
    }

    @POST
    @Path(value="uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload fixed deposit template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postFixedDepositTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.FIXED_DEPOSIT_ACCOUNTS.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
        return this.toApiJsonSerializer.serialize((Object)importDocumentId);
    }

    @GET
    @Path(value="transaction/downloadtemplate")
    @Produces(value={"application/vnd.ms-excel"})
    public Response getFixedDepositTransactionTemplate(@QueryParam(value="officeId") Long officeId, @QueryParam(value="dateFormat") String dateFormat) {
        return this.bulkImportWorkbookPopulatorService.getTemplate(GlobalEntityType.FIXED_DEPOSIT_TRANSACTIONS.toString(), officeId, null, dateFormat);
    }

    @POST
    @Path(value="transaction/uploadtemplate")
    @Consumes(value={"multipart/form-data"})
    @RequestBody(description="Upload fixed deposit transaction template", content={@Content(mediaType="multipart/form-data", schema=@Schema(implementation=UploadRequest.class))})
    public String postFixedDepositTransactionTemplate(@FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail, @FormDataParam(value="locale") String locale, @FormDataParam(value="dateFormat") String dateFormat) {
        Long importDocumentId = this.bulkImportWorkbookService.importWorkbook(GlobalEntityType.FIXED_DEPOSIT_TRANSACTIONS.toString(), uploadedInputStream, fileDetail, locale, dateFormat);
        return this.toApiJsonSerializer.serialize((Object)importDocumentId);
    }

    @Generated
    public FixedDepositAccountsApiResource(DepositAccountReadPlatformService depositAccountReadPlatformService, PlatformSecurityContext context, DefaultToApiJsonSerializer<DepositAccountData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper, SavingsAccountChargeReadPlatformService savingsAccountChargeReadPlatformService, FromJsonHelper fromJsonHelper, DepositAccountPreMatureCalculationPlatformService accountPreMatureCalculationPlatformService, AccountAssociationsReadPlatformService accountAssociationsReadPlatformService, BulkImportWorkbookService bulkImportWorkbookService, BulkImportWorkbookPopulatorService bulkImportWorkbookPopulatorService, FixedDepositAccountInterestCalculationService fixedDepositAccountInterestCalculationService, SqlValidator sqlValidator) {
        this.depositAccountReadPlatformService = depositAccountReadPlatformService;
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.savingsAccountChargeReadPlatformService = savingsAccountChargeReadPlatformService;
        this.fromJsonHelper = fromJsonHelper;
        this.accountPreMatureCalculationPlatformService = accountPreMatureCalculationPlatformService;
        this.accountAssociationsReadPlatformService = accountAssociationsReadPlatformService;
        this.bulkImportWorkbookService = bulkImportWorkbookService;
        this.bulkImportWorkbookPopulatorService = bulkImportWorkbookPopulatorService;
        this.fixedDepositAccountInterestCalculationService = fixedDepositAccountInterestCalculationService;
        this.sqlValidator = sqlValidator;
    }
}

