/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.rate.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RateDefinitionCommandFromApiJsonDeserializer {
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("id", "name", "percentage", "productApply", "active", "approveUser", "locale"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public RateDefinitionCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("name");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String name = this.fromApiJsonHelper.extractStringNamed("name", element);
        baseDataValidator.reset().parameter("name").value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(250));
        BigDecimal percentage = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("percentage", element);
        baseDataValidator.reset().parameter("percentage").value((Object)percentage).notBlank();
        String productApply = this.fromApiJsonHelper.extractStringNamed("productApply", element);
        baseDataValidator.reset().parameter("productApply").value((Object)productApply).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("rate");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists("name", element)) {
            String name = this.fromApiJsonHelper.extractStringNamed("name", element);
            baseDataValidator.reset().parameter("name").value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(250));
        }
        if (this.fromApiJsonHelper.parameterExists("percentage", element)) {
            BigDecimal percentage = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("percentage", element);
            baseDataValidator.reset().parameter("percentage").value((Object)percentage).notBlank();
        }
        if (this.fromApiJsonHelper.parameterExists("productApply", element)) {
            String productApply = this.fromApiJsonHelper.extractStringNamed("productApply", element);
            baseDataValidator.reset().parameter("productApply").value((Object)productApply).notBlank();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

