/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.meeting.service;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.apache.fineract.portfolio.meeting.data.MeetingData;
import org.apache.fineract.portfolio.meeting.exception.MeetingNotFoundException;
import org.apache.fineract.portfolio.meeting.service.MeetingReadPlatformService;
import org.apache.fineract.portfolio.meeting.service.MeetingReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class MeetingReadPlatformServiceImpl
implements MeetingReadPlatformService {
    private final JdbcTemplate jdbcTemplate;

    public MeetingData retrieveMeeting(Long meetingId, Long entityId, Integer entityTypeId) {
        try {
            MeetingDataMapper rm = new MeetingDataMapper();
            String sql = rm.schema() + " where m.id = ? and ci.entity_id = ? and ci.entity_type_enum = ? ";
            return (MeetingData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{meetingId, entityId, entityTypeId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new MeetingNotFoundException(meetingId, e);
        }
    }

    public Collection<MeetingData> retrieveMeetingsByEntity(Long entityId, Integer entityTypeId, Integer limit) {
        MeetingDataMapper rm = new MeetingDataMapper();
        String sql = rm.schema() + " where ci.entity_id = ? and ci.entity_type_enum = ? ";
        if (limit != null && limit > 0) {
            sql = sql + " order by m.meeting_date desc  limit ? ";
            return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{entityId, entityTypeId, limit});
        }
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{entityId, entityTypeId});
    }

    public Collection<MeetingData> retrieveMeetingsByEntityByCalendarType(Long entityId, Integer entityTypeId, List<Integer> calendarTypeOptions) {
        MeetingDataMapper rm = new MeetingDataMapper();
        String sqlCalendarTypeOptions = CalendarUtils.getSqlCalendarTypeOptionsInString(calendarTypeOptions);
        String sql = rm.schema() + " inner join m_calendar c on ci.calendar_id=c.id  where ci.entity_id = ? and ci.entity_type_enum = ? and c.calendar_type_enum in (" + sqlCalendarTypeOptions + ") order by c.start_date ";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{entityId, entityTypeId});
    }

    public MeetingData retrieveLastMeeting(Long calendarInstanceId) {
        try {
            MeetingDataMapper rm = new MeetingDataMapper();
            String sql = rm.schema() + " where ci.id = ? order by m.meeting_date desc, m.id desc limit 1";
            return (MeetingData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{calendarInstanceId});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Generated
    public MeetingReadPlatformServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

