/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service.reaging;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepository;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.serialization.JsonParserHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.reaging.LoanReAgeBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.reaging.LoanUndoReAgeBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.reaging.LoanReAgeTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.reaging.LoanUndoReAgeTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.organisation.monetary.data.CurrencyData;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.loanaccount.api.request.ReAgePreviewRequest;
import org.apache.fineract.portfolio.loanaccount.data.RepaymentScheduleRelatedLoanData;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.domain.reaging.LoanReAgeInterestHandlingType;
import org.apache.fineract.portfolio.loanaccount.domain.reaging.LoanReAgeParameter;
import org.apache.fineract.portfolio.loanaccount.exception.LoanTransactionNotFoundException;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.LoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.repository.LoanCapitalizedIncomeBalanceRepository;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanChargeValidator;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanRepaymentScheduleService;
import org.apache.fineract.portfolio.loanaccount.service.LoanScheduleService;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.apache.fineract.portfolio.loanaccount.service.ReprocessLoanTransactionsService;
import org.apache.fineract.portfolio.loanaccount.service.reaging.LoanReAgingValidator;
import org.apache.fineract.portfolio.note.domain.Note;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class LoanReAgingService {
    private final LoanAssembler loanAssembler;
    private final LoanReAgingValidator reAgingValidator;
    private final ExternalIdFactory externalIdFactory;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanTransactionRepository loanTransactionRepository;
    private final NoteRepository noteRepository;
    private final LoanChargeValidator loanChargeValidator;
    private final LoanUtilService loanUtilService;
    private final LoanScheduleService loanScheduleService;
    private final ReprocessLoanTransactionsService reprocessLoanTransactionsService;
    private final CodeValueRepository codeValueRepository;
    private final LoanRepaymentScheduleService loanRepaymentScheduleService;
    private final LoanReadPlatformService loanReadPlatformService;
    private final LoanCapitalizedIncomeBalanceRepository loanCapitalizedIncomeBalanceRepository;

    public CommandProcessingResult reAge(Long loanId, JsonCommand command) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.reAgingValidator.validateReAge(loan, command);
        BigDecimal userProvidedTxnAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        LoanTransaction reAgeTransaction = this.createReAgeTransaction(loan, command);
        this.processReAgeTransaction(loan, reAgeTransaction, true);
        this.validateUserProvidedTransactionAmount(userProvidedTxnAmount, reAgeTransaction);
        this.loanTransactionRepository.saveAndFlush((Object)reAgeTransaction);
        loan.updateLoanScheduleDependentDerivedFields();
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        this.persistNote(loan, command, changes);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanReAgeBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanReAgeTransactionBusinessEvent(reAgeTransaction));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)reAgeTransaction.getId()).withEntityExternalId(reAgeTransaction.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(command.getLoanId()).with(changes).build();
    }

    @Transactional(readOnly=true)
    public LoanScheduleData previewReAge(Long loanId, String loanExternalId, ReAgePreviewRequest reAgePreviewRequest) {
        Loan loan = loanId != null ? this.loanAssembler.assembleFrom(loanId) : this.loanAssembler.assembleFrom(ExternalIdFactory.produce((String)loanExternalId), false);
        return this.previewReAge(loan, reAgePreviewRequest);
    }

    private LoanScheduleData previewReAge(Loan loan, ReAgePreviewRequest reAgePreviewRequest) {
        this.reAgingValidator.validateReAge(loan, reAgePreviewRequest);
        LoanTransaction reAgeTransaction = this.createReAgeTransactionFromPreviewRequest(loan, reAgePreviewRequest);
        this.processReAgeTransaction(loan, reAgeTransaction, false);
        loan.updateLoanScheduleDependentDerivedFields();
        CurrencyData currencyData = new CurrencyData(loan.getCurrencyCode(), null, loan.getCurrency().getDigitsAfterDecimal(), loan.getCurrency().getInMultiplesOf(), null, null);
        RepaymentScheduleRelatedLoanData repaymentScheduleRelatedLoanData = new RepaymentScheduleRelatedLoanData(loan.getDisbursementDate(), loan.getDisbursementDate(), currencyData, loan.getPrincipal().getAmount(), loan.getInArrearsTolerance().getAmount(), BigDecimal.ZERO);
        Collection disbursementData = this.loanReadPlatformService.retrieveLoanDisbursementDetails((Long)loan.getId());
        List capitalizedIncomeData = this.loanCapitalizedIncomeBalanceRepository.findRepaymentPeriodDataByLoanId((Long)loan.getId());
        List sortedInstallments = loan.getRepaymentScheduleInstallments().stream().sorted(Comparator.comparingInt(LoanRepaymentScheduleInstallment::getInstallmentNumber)).collect(Collectors.toList());
        return this.loanRepaymentScheduleService.extractLoanScheduleData(sortedInstallments, repaymentScheduleRelatedLoanData, disbursementData, (Collection)capitalizedIncomeData, loan.isInterestRecalculationEnabled(), loan.getLoanProductRelatedDetail().getLoanScheduleType());
    }

    public CommandProcessingResult undoReAge(Long loanId, JsonCommand command) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.reAgingValidator.validateUndoReAge(loan);
        LinkedHashMap<String, String> changes = new LinkedHashMap<String, String>();
        changes.put("locale", command.locale());
        changes.put("dateFormat", command.dateFormat());
        LoanTransaction reAgeTransaction = this.findLatestNonReversedReAgeTransaction(loan);
        if (reAgeTransaction == null) {
            throw new LoanTransactionNotFoundException("Re-Age transaction for loan was not found");
        }
        if (loan.isProgressiveSchedule()) {
            ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, null);
            this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
        }
        this.reverseReAgeTransaction(reAgeTransaction, command);
        this.loanTransactionRepository.saveAndFlush((Object)reAgeTransaction);
        this.reprocessLoanTransactionsService.reprocessTransactions(loan);
        loan.updateLoanScheduleDependentDerivedFields();
        this.persistNote(loan, command, changes);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUndoReAgeBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUndoReAgeTransactionBusinessEvent(reAgeTransaction));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)reAgeTransaction.getId()).withEntityExternalId(reAgeTransaction.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(command.getLoanId()).with(changes).build();
    }

    private void processReAgeTransaction(Loan loan, LoanTransaction reAgeTransaction, boolean withPostTransactionChecks) {
        if (reAgeTransaction.getTransactionDate().isBefore(reAgeTransaction.getSubmittedOnDate()) || LoanReAgeInterestHandlingType.EQUAL_AMORTIZATION_FULL_INTEREST.equals((Object)reAgeTransaction.getLoanReAgeParameter().getInterestHandlingType()) || LoanReAgeInterestHandlingType.EQUAL_AMORTIZATION_PAYABLE_INTEREST.equals((Object)reAgeTransaction.getLoanReAgeParameter().getInterestHandlingType())) {
            ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, null);
            this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
            if (withPostTransactionChecks) {
                this.reprocessLoanTransactionsService.reprocessTransactions(loan, List.of(reAgeTransaction));
            } else {
                this.reprocessLoanTransactionsService.reprocessTransactionsWithoutChecks(loan, List.of(reAgeTransaction));
            }
        } else {
            this.reprocessLoanTransactionsService.processLatestTransaction(reAgeTransaction, loan);
        }
    }

    private void reverseReAgeTransaction(LoanTransaction reAgeTransaction, JsonCommand command) {
        ExternalId reversalExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(reAgeTransaction.getLoan(), reAgeTransaction, "reversed");
        reAgeTransaction.reverse(reversalExternalId);
        reAgeTransaction.manuallyAdjustedOrReversed();
    }

    private LoanTransaction findLatestNonReversedReAgeTransaction(Loan loan) {
        return loan.getLoanTransactions().stream().filter(LoanTransaction::isNotReversed).filter(LoanTransaction::isReAge).max(Comparator.comparing(LoanTransaction::getTransactionDate)).orElse(null);
    }

    private LoanTransaction createReAgeTransaction(Loan loan, JsonCommand command) {
        LocalDate startDate;
        ExternalId txExternalId = this.externalIdFactory.createFromCommand(command, "externalId");
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        if (transactionDate.isAfter(startDate = command.dateValueOfParameterNamed("startDate"))) {
            transactionDate = startDate;
        }
        Money txPrincipal = loan.getTotalPrincipalOutstandingUntil(transactionDate);
        BigDecimal txPrincipalAmount = txPrincipal.getAmount();
        LoanTransaction reAgeTransaction = new LoanTransaction(loan, loan.getOffice(), LoanTransactionType.REAGE, transactionDate, txPrincipalAmount, txPrincipalAmount, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, false, null, txExternalId);
        LoanReAgeParameter reAgeParameter = this.createReAgeParameter(reAgeTransaction, command);
        reAgeTransaction.setLoanReAgeParameter(reAgeParameter);
        return reAgeTransaction;
    }

    private LoanReAgeParameter createReAgeParameter(LoanTransaction reAgeTransaction, JsonCommand command) {
        PeriodFrequencyType periodFrequencyType = (PeriodFrequencyType)command.enumValueOfParameterNamed("frequencyType", PeriodFrequencyType.class);
        LocalDate startDate = command.dateValueOfParameterNamed("startDate");
        Integer numberOfInstallments = command.integerValueOfParameterNamed("numberOfInstallments");
        Integer periodFrequencyNumber = command.integerValueOfParameterNamed("frequencyNumber");
        LoanReAgeInterestHandlingType reAgeInterestHandlingType = (LoanReAgeInterestHandlingType)command.enumValueOfParameterNamed("reAgeInterestHandling", LoanReAgeInterestHandlingType.class);
        if (reAgeInterestHandlingType == null) {
            reAgeInterestHandlingType = LoanReAgeInterestHandlingType.DEFAULT;
        }
        CodeValue reasonCodeValue = null;
        if (command.parameterExists("reasonCodeValueId")) {
            reasonCodeValue = this.codeValueRepository.findByCodeNameAndId("ReAgeReasons", command.longValueOfParameterNamed("reasonCodeValueId"));
        }
        return new LoanReAgeParameter(reAgeTransaction, periodFrequencyType, periodFrequencyNumber, startDate, numberOfInstallments, reAgeInterestHandlingType, reasonCodeValue);
    }

    private void persistNote(Loan loan, JsonCommand command, Map<String, Object> changes) {
        if (command.hasParameter("note")) {
            String note = command.stringValueOfParameterNamed("note");
            Note newNote = Note.loanNote((Loan)loan, (String)note);
            changes.put("note", note);
            this.noteRepository.saveAndFlush((Object)newNote);
        }
    }

    private LoanTransaction createReAgeTransactionFromPreviewRequest(Loan loan, ReAgePreviewRequest reAgePreviewRequest) {
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        Locale locale = reAgePreviewRequest.getLocale() != null ? Locale.forLanguageTag(reAgePreviewRequest.getLocale()) : Locale.getDefault();
        LocalDate startDate = JsonParserHelper.convertFrom((String)reAgePreviewRequest.getStartDate(), (String)"startDate", (String)reAgePreviewRequest.getDateFormat(), (Locale)locale);
        if (transactionDate.isAfter(startDate)) {
            transactionDate = startDate;
        }
        Money txPrincipal = loan.getTotalPrincipalOutstandingUntil(transactionDate);
        BigDecimal txPrincipalAmount = txPrincipal.getAmount();
        LoanTransaction reAgeTransaction = new LoanTransaction(loan, loan.getOffice(), LoanTransactionType.REAGE, transactionDate, txPrincipalAmount, txPrincipalAmount, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, null, false, null, null);
        LoanReAgeParameter reAgeParameter = this.createReAgeParameterFromPreviewRequest(reAgeTransaction, reAgePreviewRequest);
        reAgeTransaction.setLoanReAgeParameter(reAgeParameter);
        return reAgeTransaction;
    }

    private LoanReAgeParameter createReAgeParameterFromPreviewRequest(LoanTransaction reAgeTransaction, ReAgePreviewRequest reAgePreviewRequest) {
        PeriodFrequencyType periodFrequencyType = PeriodFrequencyType.valueOf((String)reAgePreviewRequest.getFrequencyType());
        Locale locale = Optional.ofNullable(reAgePreviewRequest.getLocale()).map(Locale::forLanguageTag).orElse(Locale.getDefault());
        LocalDate startDate = JsonParserHelper.convertFrom((String)reAgePreviewRequest.getStartDate(), (String)"startDate", (String)reAgePreviewRequest.getDateFormat(), (Locale)locale);
        Integer numberOfInstallments = reAgePreviewRequest.getNumberOfInstallments();
        Integer periodFrequencyNumber = reAgePreviewRequest.getFrequencyNumber();
        LoanReAgeInterestHandlingType reAgeInterestHandlingType = Optional.ofNullable(reAgePreviewRequest.getReAgeInterestHandling()).map(LoanReAgeInterestHandlingType::valueOf).orElse(LoanReAgeInterestHandlingType.DEFAULT);
        return new LoanReAgeParameter(reAgeTransaction, periodFrequencyType, periodFrequencyNumber, startDate, numberOfInstallments, reAgeInterestHandlingType, null);
    }

    private void validateUserProvidedTransactionAmount(BigDecimal userProvidedTxnAmount, LoanTransaction reAgeTransaction) {
        BigDecimal calculatedReageTxnAmount;
        if (userProvidedTxnAmount != null && !MathUtil.isEqualTo((BigDecimal)(calculatedReageTxnAmount = reAgeTransaction.getAmount()), (BigDecimal)userProvidedTxnAmount)) {
            String errorMessage = String.format("User provided re-age amount (%s) is not matching with the calculated re-age amount (%s)", userProvidedTxnAmount, calculatedReageTxnAmount);
            throw new GeneralPlatformDomainRuleException("error.msg.loan.reage.amount.not.match.with.calculated.reage.amount", errorMessage, new Object[]{userProvidedTxnAmount, calculatedReageTxnAmount});
        }
    }

    @Generated
    public LoanReAgingService(LoanAssembler loanAssembler, LoanReAgingValidator reAgingValidator, ExternalIdFactory externalIdFactory, BusinessEventNotifierService businessEventNotifierService, LoanTransactionRepository loanTransactionRepository, NoteRepository noteRepository, LoanChargeValidator loanChargeValidator, LoanUtilService loanUtilService, LoanScheduleService loanScheduleService, ReprocessLoanTransactionsService reprocessLoanTransactionsService, CodeValueRepository codeValueRepository, LoanRepaymentScheduleService loanRepaymentScheduleService, LoanReadPlatformService loanReadPlatformService, LoanCapitalizedIncomeBalanceRepository loanCapitalizedIncomeBalanceRepository) {
        this.loanAssembler = loanAssembler;
        this.reAgingValidator = reAgingValidator;
        this.externalIdFactory = externalIdFactory;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanTransactionRepository = loanTransactionRepository;
        this.noteRepository = noteRepository;
        this.loanChargeValidator = loanChargeValidator;
        this.loanUtilService = loanUtilService;
        this.loanScheduleService = loanScheduleService;
        this.reprocessLoanTransactionsService = reprocessLoanTransactionsService;
        this.codeValueRepository = codeValueRepository;
        this.loanRepaymentScheduleService = loanRepaymentScheduleService;
        this.loanReadPlatformService = loanReadPlatformService;
        this.loanCapitalizedIncomeBalanceRepository = loanCapitalizedIncomeBalanceRepository;
    }
}

