/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.portfolio.loanproduct.domain.InterestRecalculationCompoundingMethod;
import org.apache.fineract.portfolio.loanproduct.domain.LoanPreCloseInterestCalculationStrategy;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductInterestRecalculationDetails;
import org.apache.fineract.portfolio.loanproduct.domain.LoanRescheduleStrategyMethod;
import org.apache.fineract.portfolio.loanproduct.domain.RecalculationFrequencyType;
import org.springframework.stereotype.Service;

@Service
public class LoanProductInterestRecalculationDetailsAssembler {
    public LoanProductInterestRecalculationDetails createFrom(JsonCommand command) {
        Integer preCloseInterestCalculationStrategy;
        Integer interestRecalculationCompoundingMethod = InterestRecalculationCompoundingMethod.fromInt((Integer)command.integerValueOfParameterNamed("interestRecalculationCompoundingMethod")).getValue();
        Integer loanRescheduleStrategyMethod = LoanRescheduleStrategyMethod.fromInt((Integer)command.integerValueOfParameterNamed("rescheduleStrategyMethod")).getValue();
        Integer recurrenceFrequency = command.integerValueOfParameterNamed("recalculationRestFrequencyType");
        Integer recurrenceOnNthDay = command.integerValueOfParameterNamed("recalculationRestFrequencyNthDayType");
        Integer recurrenceOnDay = command.integerValueOfParameterNamed("recalculationRestFrequencyOnDayType");
        Integer recurrenceOnWeekday = command.integerValueOfParameterNamed("recalculationRestFrequencyDayOfWeekType");
        Integer recurrenceInterval = command.integerValueOfParameterNamed("recalculationRestFrequencyInterval");
        boolean isArrearsBasedOnOriginalSchedule = command.booleanPrimitiveValueOfParameterNamed("isArrearsBasedOnOriginalSchedule");
        RecalculationFrequencyType frequencyType = RecalculationFrequencyType.fromInt((Integer)recurrenceFrequency);
        if (frequencyType.isSameAsRepayment()) {
            recurrenceInterval = 0;
        }
        InterestRecalculationCompoundingMethod compoundingMethod = InterestRecalculationCompoundingMethod.fromInt((Integer)interestRecalculationCompoundingMethod);
        Integer compoundingRecurrenceFrequency = null;
        Integer compoundingInterval = null;
        Integer compoundingRecurrenceOnNthDay = null;
        Integer compoundingRecurrenceOnDay = null;
        Integer compoundingRecurrenceOnWeekday = null;
        boolean allowCompoundingOnEod = false;
        if (compoundingMethod.isCompoundingEnabled()) {
            compoundingRecurrenceFrequency = command.integerValueOfParameterNamed("recalculationCompoundingFrequencyType");
            compoundingInterval = command.integerValueOfParameterNamed("recalculationCompoundingFrequencyInterval");
            RecalculationFrequencyType compoundingFrequencyType = RecalculationFrequencyType.fromInt((Integer)compoundingRecurrenceFrequency);
            if (compoundingFrequencyType.isSameAsRepayment()) {
                recurrenceInterval = 0;
            }
            compoundingRecurrenceOnNthDay = command.integerValueOfParameterNamed("recalculationCompoundingFrequencyNthDayType");
            compoundingRecurrenceOnDay = command.integerValueOfParameterNamed("recalculationCompoundingFrequencyOnDayType");
            compoundingRecurrenceOnWeekday = command.integerValueOfParameterNamed("recalculationCompoundingFrequencyDayOfWeekType");
            if (!compoundingFrequencyType.isDaily()) {
                allowCompoundingOnEod = command.booleanPrimitiveValueOfParameterNamed("allowCompoundingOnEod");
            }
        }
        if ((preCloseInterestCalculationStrategy = command.integerValueOfParameterNamed("preClosureInterestCalculationStrategy")) == null) {
            preCloseInterestCalculationStrategy = LoanPreCloseInterestCalculationStrategy.TILL_PRE_CLOSURE_DATE.getValue();
        }
        boolean isCompoundingToBePostedAsTransaction = command.booleanPrimitiveValueOfParameterNamed("isCompoundingToBePostedAsTransaction");
        boolean disallowInterestCalculationOnPastDue = command.booleanPrimitiveValueOfParameterNamed("disallowInterestCalculationOnPastDue");
        return new LoanProductInterestRecalculationDetails(interestRecalculationCompoundingMethod, loanRescheduleStrategyMethod, recurrenceFrequency, recurrenceInterval, recurrenceOnNthDay, recurrenceOnDay, recurrenceOnWeekday, compoundingRecurrenceFrequency, compoundingInterval, compoundingRecurrenceOnNthDay, compoundingRecurrenceOnDay, compoundingRecurrenceOnWeekday, isArrearsBasedOnOriginalSchedule, preCloseInterestCalculationStrategy, isCompoundingToBePostedAsTransaction, allowCompoundingOnEod, disallowInterestCalculationOnPastDue);
    }

    @Generated
    public LoanProductInterestRecalculationDetailsAssembler() {
    }
}

