/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanDisbursementDetails;

public class LoanDisbursementDetailsAssembler {
    private final FromJsonHelper fromApiJsonHelper;

    public List<LoanDisbursementDetails> fetchDisbursementData(JsonObject command) {
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(command);
        String dateFormat = this.fromApiJsonHelper.extractDateFormatParameter(command);
        ArrayList<LoanDisbursementDetails> disbursementDatas = new ArrayList<LoanDisbursementDetails>();
        JsonArray disbursementDataArray = command.getAsJsonArray("disbursementData");
        if (disbursementDataArray != null && !disbursementDataArray.isEmpty()) {
            disbursementDataArray.forEach(jsonElement -> {
                LocalDate expectedDisbursementDate = this.fromApiJsonHelper.extractLocalDateNamed("expectedDisbursementDate", jsonElement, dateFormat, locale);
                BigDecimal principal = this.fromApiJsonHelper.extractBigDecimalNamed("principal", jsonElement, locale);
                BigDecimal netDisbursalAmount = this.fromApiJsonHelper.extractBigDecimalNamed("netDisbursalAmount", jsonElement, locale);
                boolean isReversed = Boolean.TRUE.equals(this.fromApiJsonHelper.extractBooleanNamed("reversed", jsonElement));
                disbursementDatas.add(new LoanDisbursementDetails(expectedDisbursementDate, null, principal, netDisbursalAmount, isReversed));
            });
        }
        return disbursementDatas;
    }

    @Generated
    public LoanDisbursementDetailsAssembler(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }
}

