/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanAdjustTransactionBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanBuyDownFeeAmortizationAdjustmentTransactionCreatedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanBuyDownFeeAmortizationTransactionCreatedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.loanaccount.domain.AmortizationType;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAmortizationAllocationMapping;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeBalance;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelation;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelationTypeEnum;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.repository.LoanBuyDownFeeBalanceRepository;
import org.apache.fineract.portfolio.loanaccount.service.LoanAmortizationAllocationService;
import org.apache.fineract.portfolio.loanaccount.service.LoanBuyDownFeeAmortizationProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanBuyDownFeeAmortizationProcessingServiceImpl;
import org.apache.fineract.portfolio.loanaccount.service.LoanJournalEntryPoster;
import org.apache.fineract.portfolio.loanaccount.util.BuyDownFeeAmortizationUtil;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class LoanBuyDownFeeAmortizationProcessingServiceImpl
implements LoanBuyDownFeeAmortizationProcessingService {
    private final LoanTransactionRepository loanTransactionRepository;
    private final LoanBuyDownFeeBalanceRepository loanBuyDownFeeBalanceRepository;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanJournalEntryPoster journalEntryPoster;
    private final ExternalIdFactory externalIdFactory;
    private final LoanAmortizationAllocationService loanAmortizationAllocationService;

    @Transactional
    public void processBuyDownFeeAmortizationTillDate(@NonNull Loan loan, @NonNull LocalDate tillDate, boolean addJournal) {
        List balances = this.loanBuyDownFeeBalanceRepository.findAllByLoanIdAndClosedFalse((Long)loan.getId());
        LocalDate maturityDate = loan.getMaturityDate() != null ? loan.getMaturityDate() : this.getFinalBuyDownFeeAmortizationTransactionDate(loan);
        LocalDate tillDatePlusOne = tillDate.plusDays(1L);
        if (tillDatePlusOne.isAfter(maturityDate)) {
            tillDatePlusOne = maturityDate;
        }
        ArrayList<LoanAmortizationAllocationMapping> loanAmortizationAllocationMappings = new ArrayList<LoanAmortizationAllocationMapping>();
        Money totalAmortization = Money.zero((MonetaryCurrency)loan.getCurrency());
        BigDecimal totalAmortized = this.loanTransactionRepository.getAmortizedAmountBuyDownFee(loan);
        for (LoanBuyDownFeeBalance balance : balances) {
            AmortizationType amortizationType;
            BigDecimal amortizationAmount;
            if (!balance.isDeleted()) {
                List adjustments = this.loanTransactionRepository.findAdjustments(balance.getLoanTransaction());
                Money amortizationTillDate = BuyDownFeeAmortizationUtil.calculateTotalAmortizationTillDate((LoanBuyDownFeeBalance)balance, (List)adjustments, (LocalDate)maturityDate, (LoanBuyDownFeeStrategy)loan.getLoanProductRelatedDetail().getBuyDownFeeStrategy(), (LocalDate)tillDatePlusOne, (MonetaryCurrency)loan.getCurrency());
                totalAmortization = totalAmortization.add(amortizationTillDate);
                BigDecimal alreadyAmortizedAmount = this.loanAmortizationAllocationService.calculateAlreadyAmortizedAmount((Long)balance.getLoanTransaction().getId(), (Long)loan.getId());
                if (!adjustments.isEmpty()) {
                    if (alreadyAmortizedAmount.compareTo(amortizationTillDate.getAmount()) > 0) {
                        amortizationAmount = alreadyAmortizedAmount.subtract(amortizationTillDate.getAmount());
                        amortizationType = AmortizationType.AM_ADJ;
                    } else {
                        amortizationAmount = amortizationTillDate.getAmount().subtract(alreadyAmortizedAmount);
                        amortizationType = AmortizationType.AM;
                    }
                } else {
                    amortizationAmount = amortizationTillDate.getAmount().subtract(alreadyAmortizedAmount);
                    amortizationType = AmortizationType.AM;
                }
                balance.setUnrecognizedAmount(MathUtil.subtract((BigDecimal)balance.getAmount(), (BigDecimal[])new BigDecimal[]{balance.getAmountAdjustment(), amortizationTillDate.getAmount()}));
            } else {
                amortizationAmount = balance.getAmount().subtract(balance.getUnrecognizedAmount());
                amortizationType = AmortizationType.AM_ADJ;
                balance.setClosed(true);
            }
            if (amortizationAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            LoanAmortizationAllocationMapping loanAmortizationAllocationMapping2 = this.loanAmortizationAllocationService.createAmortizationAllocationMappingWithBaseLoanTransaction(balance.getLoanTransaction(), amortizationAmount, amortizationType);
            loanAmortizationAllocationMappings.add(loanAmortizationAllocationMapping2);
        }
        this.loanBuyDownFeeBalanceRepository.saveAll((Iterable)balances);
        BigDecimal totalAmortizationAmount = totalAmortization.getAmount().subtract(totalAmortized);
        if (!MathUtil.isZero((BigDecimal)totalAmortizationAmount)) {
            LoanTransaction transaction = MathUtil.isGreaterThanZero((BigDecimal)totalAmortizationAmount) ? LoanTransaction.buyDownFeeAmortization((Loan)loan, (Office)loan.getOffice(), (LocalDate)tillDate, (BigDecimal)totalAmortizationAmount, (ExternalId)this.externalIdFactory.create()) : LoanTransaction.buyDownFeeAmortizationAdjustment((Loan)loan, (Money)Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)MathUtil.negate((BigDecimal)totalAmortizationAmount)), (LocalDate)tillDate, (ExternalId)this.externalIdFactory.create());
            loan.addLoanTransaction(transaction);
            LoanTransaction finalTransaction = transaction = (LoanTransaction)this.loanTransactionRepository.saveAndFlush((Object)transaction);
            loanAmortizationAllocationMappings.forEach(loanAmortizationAllocationMapping -> this.loanAmortizationAllocationService.setAmortizationTransactionDataAndSaveAmortizationAllocationMapping(loanAmortizationAllocationMapping, finalTransaction));
            if (addJournal) {
                this.journalEntryPoster.postJournalEntriesForLoanTransaction(transaction, false, false);
            }
            LoanBuyDownFeeAmortizationTransactionCreatedBusinessEvent event = MathUtil.isGreaterThanZero((BigDecimal)totalAmortizationAmount) ? new LoanBuyDownFeeAmortizationTransactionCreatedBusinessEvent(transaction) : new LoanBuyDownFeeAmortizationAdjustmentTransactionCreatedBusinessEvent(transaction);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)event);
        }
    }

    @Transactional
    public void processBuyDownFeeAmortizationOnLoanClosure(@NonNull Loan loan, boolean addJournal) {
        LocalDate transactionDate = this.getFinalBuyDownFeeAmortizationTransactionDate(loan);
        Optional amortizationTransaction = this.createBuyDownFeeAmortizationTransaction(loan, transactionDate, false, null);
        amortizationTransaction.ifPresent(loanTransaction -> {
            if (loanTransaction.isBuyDownFeeAmortization()) {
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBuyDownFeeAmortizationTransactionCreatedBusinessEvent(loanTransaction));
            } else {
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBuyDownFeeAmortizationAdjustmentTransactionCreatedBusinessEvent(loanTransaction));
            }
            if (addJournal) {
                this.journalEntryPoster.postJournalEntriesForLoanTransaction((LoanTransaction)amortizationTransaction.get(), false, false);
            }
        });
    }

    @Transactional
    public void processBuyDownFeeAmortizationOnLoanChargeOff(@NonNull Loan loan, @NonNull LoanTransaction chargeOffTransaction) {
        Optional amortizationTransaction;
        LocalDate transactionDate = loan.getChargedOffOnDate();
        if (transactionDate == null) {
            transactionDate = DateUtils.getBusinessLocalDate();
        }
        if ((amortizationTransaction = this.createBuyDownFeeAmortizationTransaction(loan, transactionDate, true, chargeOffTransaction)).isPresent()) {
            this.journalEntryPoster.postJournalEntriesForLoanTransaction((LoanTransaction)amortizationTransaction.get(), false, false);
            if (((LoanTransaction)amortizationTransaction.get()).isBuyDownFeeAmortization()) {
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBuyDownFeeAmortizationTransactionCreatedBusinessEvent((LoanTransaction)amortizationTransaction.get()));
            } else {
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBuyDownFeeAmortizationAdjustmentTransactionCreatedBusinessEvent((LoanTransaction)amortizationTransaction.get()));
            }
        }
    }

    @Transactional
    public void processBuyDownFeeAmortizationOnLoanUndoChargeOff(@NonNull LoanTransaction loanTransaction) {
        Loan loan = loanTransaction.getLoan();
        loan.getLoanTransactions().stream().filter(LoanTransaction::isBuyDownFeeAmortization).filter(transaction -> transaction.getTransactionDate().equals(loanTransaction.getTransactionDate()) && transaction.getLoanTransactionRelations().stream().anyMatch(rel -> LoanTransactionRelationTypeEnum.RELATED.equals((Object)rel.getRelationType()) && rel.getToTransaction().equals(loanTransaction))).forEach(transaction -> {
            transaction.reverse();
            this.journalEntryPoster.postJournalEntriesForLoanTransaction(transaction, false, false);
            LoanAdjustTransactionBusinessEvent.Data data = new LoanAdjustTransactionBusinessEvent.Data(transaction);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAdjustTransactionBusinessEvent(data));
        });
        for (LoanBuyDownFeeBalance balance : this.loanBuyDownFeeBalanceRepository.findAllByLoanIdAndDeletedFalseAndClosedFalse((Long)loan.getId())) {
            balance.setUnrecognizedAmount(balance.getChargedOffAmount());
            balance.setChargedOffAmount(BigDecimal.ZERO);
        }
    }

    private Optional<LoanTransaction> createBuyDownFeeAmortizationTransaction(Loan loan, LocalDate transactionDate, boolean isChargeOff, LoanTransaction chargeOffTransaction) {
        LoanTransaction amortizationTransaction;
        ExternalId externalId = this.externalIdFactory.create();
        List balances = this.loanBuyDownFeeBalanceRepository.findAllByLoanIdAndClosedFalse((Long)loan.getId());
        ArrayList<LoanAmortizationAllocationMapping> loanAmortizationAllocationMappings = new ArrayList<LoanAmortizationAllocationMapping>();
        BigDecimal totalAmortization = BigDecimal.ZERO;
        BigDecimal totalAmortized = this.loanTransactionRepository.getAmortizedAmountBuyDownFee(loan);
        for (LoanBuyDownFeeBalance balance : balances) {
            AmortizationType amortizationType;
            BigDecimal amortizationAmount;
            if (!balance.isDeleted()) {
                List adjustments = this.loanTransactionRepository.findAdjustments(balance.getLoanTransaction());
                LocalDate maturityDate = loan.getMaturityDate() != null ? loan.getMaturityDate() : transactionDate;
                Money amortizationTillDate = BuyDownFeeAmortizationUtil.calculateTotalAmortizationTillDate((LoanBuyDownFeeBalance)balance, (List)adjustments, (LocalDate)maturityDate, (LoanBuyDownFeeStrategy)loan.getLoanProductRelatedDetail().getBuyDownFeeStrategy(), (LocalDate)maturityDate, (MonetaryCurrency)loan.getCurrency());
                totalAmortization = totalAmortization.add(amortizationTillDate.getAmount());
                BigDecimal alreadyAmortizedAmount = this.loanAmortizationAllocationService.calculateAlreadyAmortizedAmount((Long)balance.getLoanTransaction().getId(), (Long)loan.getId());
                if (!adjustments.isEmpty()) {
                    if (alreadyAmortizedAmount.compareTo(amortizationTillDate.getAmount()) > 0) {
                        amortizationAmount = alreadyAmortizedAmount.subtract(amortizationTillDate.getAmount());
                        amortizationType = AmortizationType.AM_ADJ;
                    } else {
                        amortizationAmount = amortizationTillDate.getAmount().subtract(alreadyAmortizedAmount);
                        amortizationType = AmortizationType.AM;
                    }
                } else {
                    amortizationAmount = amortizationTillDate.getAmount().subtract(alreadyAmortizedAmount);
                    amortizationType = AmortizationType.AM;
                }
                if (isChargeOff) {
                    balance.setChargedOffAmount(balance.getUnrecognizedAmount());
                }
                balance.setUnrecognizedAmount(BigDecimal.ZERO);
            } else {
                amortizationAmount = balance.getAmount().subtract(balance.getUnrecognizedAmount());
                amortizationType = AmortizationType.AM_ADJ;
                balance.setClosed(true);
            }
            if (amortizationAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            LoanAmortizationAllocationMapping loanAmortizationAllocationMapping2 = this.loanAmortizationAllocationService.createAmortizationAllocationMappingWithBaseLoanTransaction(balance.getLoanTransaction(), amortizationAmount, amortizationType);
            loanAmortizationAllocationMappings.add(loanAmortizationAllocationMapping2);
        }
        BigDecimal totalUnrecognizedAmount = totalAmortization.subtract(totalAmortized);
        if (MathUtil.isZero((BigDecimal)totalUnrecognizedAmount)) {
            return Optional.empty();
        }
        LoanTransaction loanTransaction = amortizationTransaction = MathUtil.isGreaterThanZero((BigDecimal)totalUnrecognizedAmount) ? LoanTransaction.buyDownFeeAmortization((Loan)loan, (Office)loan.getOffice(), (LocalDate)transactionDate, (BigDecimal)totalUnrecognizedAmount, (ExternalId)externalId) : LoanTransaction.buyDownFeeAmortizationAdjustment((Loan)loan, (Money)Money.of((MonetaryCurrency)loan.getCurrency(), (BigDecimal)MathUtil.negate((BigDecimal)totalUnrecognizedAmount)), (LocalDate)transactionDate, (ExternalId)externalId);
        if (isChargeOff) {
            amortizationTransaction.getLoanTransactionRelations().add(LoanTransactionRelation.linkToTransaction((LoanTransaction)amortizationTransaction, (LoanTransaction)chargeOffTransaction, (LoanTransactionRelationTypeEnum)LoanTransactionRelationTypeEnum.RELATED));
        }
        loan.addLoanTransaction(amortizationTransaction);
        this.loanTransactionRepository.saveAndFlush((Object)amortizationTransaction);
        loanAmortizationAllocationMappings.forEach(loanAmortizationAllocationMapping -> this.loanAmortizationAllocationService.setAmortizationTransactionDataAndSaveAmortizationAllocationMapping(loanAmortizationAllocationMapping, amortizationTransaction));
        return Optional.of(amortizationTransaction);
    }

    private LocalDate getFinalBuyDownFeeAmortizationTransactionDate(Loan loan) {
        return switch (1.$SwitchMap$org$apache$fineract$portfolio$loanaccount$domain$LoanStatus[loan.getStatus().ordinal()]) {
            case 1 -> loan.getClosedOnDate();
            case 2 -> loan.getOverpaidOnDate();
            case 3 -> loan.getWrittenOffOnDate();
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(loan.getStatus()));
        };
    }

    @Generated
    public LoanBuyDownFeeAmortizationProcessingServiceImpl(LoanTransactionRepository loanTransactionRepository, LoanBuyDownFeeBalanceRepository loanBuyDownFeeBalanceRepository, BusinessEventNotifierService businessEventNotifierService, LoanJournalEntryPoster journalEntryPoster, ExternalIdFactory externalIdFactory, LoanAmortizationAllocationService loanAmortizationAllocationService) {
        this.loanTransactionRepository = loanTransactionRepository;
        this.loanBuyDownFeeBalanceRepository = loanBuyDownFeeBalanceRepository;
        this.businessEventNotifierService = businessEventNotifierService;
        this.journalEntryPoster = journalEntryPoster;
        this.externalIdFactory = externalIdFactory;
        this.loanAmortizationAllocationService = loanAmortizationAllocationService;
    }
}

