/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import java.util.ArrayList;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;

public class LoanAccountServiceImpl
implements LoanAccountService {
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final LoanTransactionRepository loanTransactionRepository;

    public LoanTransaction saveLoanTransactionWithDataIntegrityViolationChecks(LoanTransaction newRepaymentTransaction) {
        try {
            return (LoanTransaction)this.loanTransactionRepository.saveAndFlush((Object)newRepaymentTransaction);
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            this.raiseValidationExceptionForUniqueConstraintViolation((Exception)e);
            throw e;
        }
    }

    public Loan saveAndFlushLoanWithDataIntegrityViolationChecks(Loan loan) {
        try {
            return this.loanRepositoryWrapper.saveAndFlush(loan);
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            this.raiseValidationExceptionForUniqueConstraintViolation((Exception)e);
            throw e;
        }
    }

    public Loan saveLoanWithDataIntegrityViolationChecks(Loan loan) {
        try {
            return this.loanRepositoryWrapper.save(loan);
        }
        catch (DataIntegrityViolationException | JpaSystemException e) {
            this.raiseValidationExceptionForUniqueConstraintViolation((Exception)e);
            throw e;
        }
    }

    private void raiseValidationExceptionForUniqueConstraintViolation(Exception e) {
        Throwable realCause = e.getCause();
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.transaction");
        if (realCause.getMessage().toLowerCase().contains("external_id_unique") || realCause.getMessage().contains("duplicate key value violates unique constraint \"m_loan_transaction_external_id_key\"")) {
            baseDataValidator.reset().parameter("externalId").failWithCode("value.must.be.unique", new Object[0]);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors, (Throwable)e);
        }
    }

    @Generated
    public LoanAccountServiceImpl(LoanRepositoryWrapper loanRepositoryWrapper, LoanTransactionRepository loanTransactionRepository) {
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.loanTransactionRepository = loanTransactionRepository;
    }
}

