/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.MathUtil;
import org.apache.fineract.portfolio.common.service.Validator;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanDisbursementDetails;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanApplicationValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanApprovedAmountValidator;
import org.springframework.stereotype.Component;

@Component
public final class LoanApprovedAmountValidatorImpl
implements LoanApprovedAmountValidator {
    private static final Set<LoanStatus> INVALID_LOAN_STATUSES_FOR_APPROVED_AMOUNT_MODIFICATION = Set.of(LoanStatus.INVALID, LoanStatus.SUBMITTED_AND_PENDING_APPROVAL, LoanStatus.REJECTED);
    private final FromJsonHelper fromApiJsonHelper;
    private final LoanRepository loanRepository;
    private final LoanApplicationValidator loanApplicationValidator;

    public void validateLoanApprovedAmountModification(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        HashSet<String> supportedParameters = new HashSet<String>(Arrays.asList("amount", "locale"));
        JsonElement element = this.fromApiJsonHelper.parse(json);
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, supportedParameters);
        BigDecimal newApprovedAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("amount", element);
        Validator.validateOrThrow((String)"loan.approved.amount", baseDataValidator -> baseDataValidator.reset().parameter("amount").value((Object)newApprovedAmount).notNull());
        Validator.validateOrThrowDomainViolation((String)"loan.approved.amount", baseDataValidator -> {
            BigDecimal totalExpectedPrincipal;
            BigDecimal totalPrincipalOnLoan;
            BigDecimal maximumThresholdForApprovedAmount;
            baseDataValidator.reset().parameter("amount").value((Object)newApprovedAmount).positiveAmount();
            Long loanId = command.getLoanId();
            Loan loan = (Loan)this.loanRepository.findById((Object)loanId).orElseThrow(() -> new LoanNotFoundException(loanId));
            if (INVALID_LOAN_STATUSES_FOR_APPROVED_AMOUNT_MODIFICATION.contains(loan.getStatus())) {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("loan.status.not.valid.for.approved.amount.modification", new Object[0]);
            }
            if (MathUtil.isGreaterThan((BigDecimal)newApprovedAmount, (BigDecimal)(maximumThresholdForApprovedAmount = loan.loanProduct().isAllowApprovedDisbursedAmountsOverApplied() ? this.loanApplicationValidator.getOverAppliedMax(loan) : loan.getProposedPrincipal()))) {
                baseDataValidator.reset().parameter("amount").failWithCode("can't.be.greater.than.maximum.applied.loan.amount.calculation", new Object[0]);
            }
            if (MathUtil.isLessThan((BigDecimal)newApprovedAmount, (BigDecimal)(totalPrincipalOnLoan = loan.getSummary().getTotalPrincipal()).add(totalExpectedPrincipal = loan.getDisbursementDetails().stream().filter(t -> t.actualDisbursementDate() == null).map(LoanDisbursementDetails::principal).reduce(BigDecimal.ZERO, BigDecimal::add)))) {
                baseDataValidator.reset().parameter("amount").failWithCode("less.than.disbursed.principal.and.capitalized.income", new Object[0]);
            }
        });
    }

    public void validateLoanAvailableDisbursementAmountModification(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        HashSet<String> supportedParameters = new HashSet<String>(Arrays.asList("amount", "locale"));
        JsonElement element = this.fromApiJsonHelper.parse(json);
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, supportedParameters);
        BigDecimal newAvailableDisbursementAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("amount", element);
        Validator.validateOrThrow((String)"loan.available.disbursement.amount", baseDataValidator -> baseDataValidator.reset().parameter("amount").value((Object)newAvailableDisbursementAmount).notNull());
        Validator.validateOrThrowDomainViolation((String)"loan.available.disbursement.amount", baseDataValidator -> {
            baseDataValidator.reset().parameter("amount").value((Object)newAvailableDisbursementAmount).zeroOrPositiveAmount();
            Long loanId = command.getLoanId();
            Loan loan = (Loan)this.loanRepository.findById((Object)loanId).orElseThrow(() -> new LoanNotFoundException(loanId));
            if (!loan.getStatus().isApproved() && !loan.getStatus().isActive()) {
                baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("loan.must.be.approved.or.active", new Object[0]);
            }
            BigDecimal maximumThresholdForApprovedAmount = loan.loanProduct().isAllowApprovedDisbursedAmountsOverApplied() ? this.loanApplicationValidator.getOverAppliedMax(loan) : loan.getProposedPrincipal();
            BigDecimal expectedDisbursementAmount = loan.getDisbursementDetails().stream().filter(t -> t.actualDisbursementDate() == null).map(LoanDisbursementDetails::principal).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal maximumAvailableDisbursementThreshold = maximumThresholdForApprovedAmount.subtract(loan.getSummary().getTotalPrincipal()).subtract(expectedDisbursementAmount);
            if (MathUtil.isGreaterThan((BigDecimal)newAvailableDisbursementAmount, (BigDecimal)maximumAvailableDisbursementThreshold)) {
                baseDataValidator.reset().parameter("amount").failWithCode("can't.be.greater.than.maximum.available.disbursement.amount.calculation", new Object[0]);
            }
            if (MathUtil.isZero((BigDecimal)newAvailableDisbursementAmount) && loan.getStatus().isApproved()) {
                baseDataValidator.reset().parameter("amount").failWithCode("cannot.be.zero.as.nothing.was.disbursed.yet", new Object[0]);
            }
        });
    }

    @Generated
    public LoanApprovedAmountValidatorImpl(FromJsonHelper fromApiJsonHelper, LoanRepository loanRepository, LoanApplicationValidator loanApplicationValidator) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.loanRepository = loanRepository;
        this.loanApplicationValidator = loanApplicationValidator;
    }
}

