/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.interestratechart.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.interestratechart.api.InterestRateChartsApiResourceSwagger;
import org.apache.fineract.portfolio.interestratechart.data.InterestRateChartData;
import org.apache.fineract.portfolio.interestratechart.service.InterestRateChartReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/interestratecharts")
@Component
@Tag(name="Interest Rate Chart", description="This defines an interest rate scheme that can be associated to a term deposit product. This will have a slab (band or range) of deposit periods and the associated interest rates applicable along with incentives for each band.")
public class InterestRateChartsApiResource {
    private final InterestRateChartReadPlatformService chartReadPlatformService;
    private final PlatformSecurityContext context;
    private final DefaultToApiJsonSerializer<InterestRateChartData> toApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private static final Set<String> INTERESTRATE_CHART_RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "id", "name", "description", "fromDate", "endDate", "chartSlabs", "isPrimaryGroupingByAmount"));

    @GET
    @Path(value="template")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve Chart Details Template", description="This is a convenience resource. It can be useful when building maintenance user interface screens for creating a chart. The template data returned consists of any or all of:\n\nField Defaults\nAllowed Value Lists\nExample Request:\n\ninterestratecharts/template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InterestRateChartsApiResourceSwagger.GetInterestRateChartsTemplateResponse.class))})})
    public String template(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("interestchart");
        InterestRateChartData chartData = this.chartReadPlatformService.template();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)chartData, INTERESTRATE_CHART_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve all Charts", description="Retrieve list of charts associated with a term deposit product(FD or RD).\nExample Requests:\n\ninterestratecharts?productId=1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=InterestRateChartsApiResourceSwagger.GetInterestRateChartsResponse.class)))})})
    public String retrieveAll(@Context UriInfo uriInfo, @QueryParam(value="productId") @Parameter(description="productId") Long productId) {
        this.context.authenticatedUser().validateHasReadPermission("interestchart");
        Collection chartDatas = this.chartReadPlatformService.retrieveAllWithSlabs(productId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, chartDatas, INTERESTRATE_CHART_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{chartId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Chart", description="It retrieves the Interest Rate Chart\nExample Requests:\n\ninterestratecharts/1")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InterestRateChartsApiResourceSwagger.GetInterestRateChartsResponse.class))})})
    public String retrieveOne(@PathParam(value="chartId") @Parameter(description="chartId") Long chartId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("interestchart");
        InterestRateChartData chartData = null;
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        chartData = !associationParameters.isEmpty() && associationParameters.contains("chartSlabs") ? this.chartReadPlatformService.retrieveOneWithSlabs(chartId) : this.chartReadPlatformService.retrieveOne(chartId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (settings.isTemplate()) {
            chartData = this.chartReadPlatformService.retrieveWithTemplate(chartData);
        }
        return this.toApiJsonSerializer.serialize(settings, (Object)chartData, INTERESTRATE_CHART_RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a Chart", description="Creates a new chart which can be attached to a term deposit products (FD or RD).")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=InterestRateChartsApiResourceSwagger.PostInterestRateChartsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InterestRateChartsApiResourceSwagger.PostInterestRateChartsResponse.class))})})
    public String create(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createInterestRateChart().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @PUT
    @Path(value="{chartId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Chart", description="It updates the chart")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=InterestRateChartsApiResourceSwagger.PutInterestRateChartsChartIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InterestRateChartsApiResourceSwagger.PutInterestRateChartsChartIdResponse.class))})})
    public String update(@PathParam(value="chartId") @Parameter(description="chartId") Long chartId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateInterestRateChart(chartId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{chartId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Chart", description="It deletes the chart")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InterestRateChartsApiResourceSwagger.DeleteInterestRateChartsChartIdResponse.class))})})
    public String delete(@PathParam(value="chartId") @Parameter(description="chartId") Long chartId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteInterestRateChart(chartId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public InterestRateChartsApiResource(InterestRateChartReadPlatformService chartReadPlatformService, PlatformSecurityContext context, DefaultToApiJsonSerializer<InterestRateChartData> toApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ApiRequestParameterHelper apiRequestParameterHelper) {
        this.chartReadPlatformService = chartReadPlatformService;
        this.context = context;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
    }
}

