/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collectionsheet.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CollectionSheetGenerateCommandFromApiJsonDeserializer {
    public static final String COLLECTIONSHEET = "collectionsheet";
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("transactionDate", "locale", "dateFormat", "calendarId"));
    private static final Set<String> INDIVIDUAL_COLLECTIONSHEET_SUPPORTED_PARAMS = new HashSet<String>(Arrays.asList("transactionDate", "locale", "dateFormat", "officeId", "staffId"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public CollectionSheetGenerateCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForGenerateCollectionSheet(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(COLLECTIONSHEET);
        String transactionDateStr = this.fromApiJsonHelper.extractStringNamed("transactionDate", element);
        baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDateStr).notBlank();
        if (!StringUtils.isBlank((CharSequence)transactionDateStr)) {
            LocalDate dueDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
            baseDataValidator.reset().parameter("transactionDate").value((Object)dueDate).notNull();
        }
        Long calendarId = this.fromApiJsonHelper.extractLongNamed("calendarId", element);
        baseDataValidator.reset().parameter("calendarId").value((Object)calendarId).notNull();
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    public void validateForGenerateCollectionSheetOfIndividuals(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)INDIVIDUAL_COLLECTIONSHEET_SUPPORTED_PARAMS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(COLLECTIONSHEET);
        String transactionDateStr = this.fromApiJsonHelper.extractStringNamed("transactionDate", element);
        baseDataValidator.reset().parameter("transactionDate").value((Object)transactionDateStr).notBlank();
        if (!StringUtils.isBlank((CharSequence)transactionDateStr)) {
            LocalDate dueDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
            baseDataValidator.reset().parameter("transactionDate").value((Object)dueDate).notNull();
        }
        Long officeId = this.fromApiJsonHelper.extractLongNamed("officeId", element);
        baseDataValidator.reset().parameter("officeId").value((Object)officeId).longGreaterThanZero();
        Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
        baseDataValidator.reset().parameter("staffId").value((Object)staffId).longGreaterThanZero();
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }
}

