/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collectionsheet.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.serialization.AbstractFromApiJsonDeserializer;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.collectionsheet.command.CollectionSheetBulkDisbursalCommand;
import org.apache.fineract.portfolio.collectionsheet.command.SingleDisbursalCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class CollectionSheetBulkDisbursalCommandFromApiJsonDeserializer
extends AbstractFromApiJsonDeserializer<CollectionSheetBulkDisbursalCommand> {
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public CollectionSheetBulkDisbursalCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public CollectionSheetBulkDisbursalCommand commandFromApiJson(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        JsonElement element = this.fromApiJsonHelper.parse(json);
        JsonObject topLevelJsonElement = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transactionDate", element);
        String note = this.fromApiJsonHelper.extractStringNamed("note", element);
        SingleDisbursalCommand[] loanDisbursementTransactions = null;
        if (element.isJsonObject() && topLevelJsonElement.has("bulkDisbursementTransactions") && topLevelJsonElement.get("bulkDisbursementTransactions").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("bulkDisbursementTransactions").getAsJsonArray();
            loanDisbursementTransactions = new SingleDisbursalCommand[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                JsonObject loanTransactionElement = array.get(i).getAsJsonObject();
                Long loanId = this.fromApiJsonHelper.extractLongNamed("loanId", (JsonElement)loanTransactionElement);
                BigDecimal disbursementAmount = this.fromApiJsonHelper.extractBigDecimalNamed("transactionAmount", (JsonElement)loanTransactionElement, locale);
                loanDisbursementTransactions[i] = new SingleDisbursalCommand(loanId, disbursementAmount, transactionDate);
            }
        }
        return new CollectionSheetBulkDisbursalCommand(note, transactionDate, loanDisbursementTransactions);
    }
}

