/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class ClientFamilyMemberCommandFromApiJsonDeserializer {
    public static final String ID = "id";
    public static final String CLIENT_ID = "clientId";
    public static final String FIRST_NAME = "firstName";
    public static final String MIDDLE_NAME = "middleName";
    public static final String LAST_NAME = "lastName";
    public static final String QUALIFICATION = "qualification";
    public static final String MOBILE_NUMBER = "mobileNumber";
    public static final String AGE = "age";
    public static final String IS_DEPENDENT = "isDependent";
    public static final String RELATIONSHIP_ID = "relationshipId";
    public static final String MARITAL_STATUS_ID = "maritalStatusId";
    public static final String GENDER_ID = "genderId";
    public static final String DATE_OF_BIRTH = "dateOfBirth";
    public static final String PROFESSION_ID = "professionId";
    public static final String LOCALE = "locale";
    public static final String DATE_FORMAT = "dateFormat";
    public static final String FAMILY_MEMBERS = "familyMembers";
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("id", "clientId", "firstName", "middleName", "lastName", "qualification", "mobileNumber", "age", "isDependent", "relationshipId", "maritalStatusId", "genderId", "dateOfBirth", "professionId", "locale", "dateFormat", "familyMembers"));
    public static final String FAMILY_MEMBERS1 = "FamilyMembers";
    public static final String RELATION_SHIP_ID = "relationShipId";
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public ClientFamilyMemberCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(FAMILY_MEMBERS1);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.extractArrayNamed(FAMILY_MEMBERS, element) != null) {
            JsonArray familyMembers = this.fromApiJsonHelper.extractJsonArrayNamed(FAMILY_MEMBERS, element);
            baseDataValidator.reset().value((Object)familyMembers).arrayNotEmpty();
        } else {
            baseDataValidator.reset().value((Object)this.fromApiJsonHelper.extractJsonArrayNamed(FAMILY_MEMBERS, element)).arrayNotEmpty();
        }
        this.validateForCreate(1L, json);
    }

    public void validateForCreate(long clientId, String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(FAMILY_MEMBERS1);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        baseDataValidator.reset().value((Object)clientId).notBlank().integerGreaterThanZero();
        if (this.fromApiJsonHelper.extractStringNamed(FIRST_NAME, element) != null) {
            String firstName = this.fromApiJsonHelper.extractStringNamed(FIRST_NAME, element);
            baseDataValidator.reset().parameter(FIRST_NAME).value((Object)firstName).notNull().notBlank().notExceedingLengthOf(Integer.valueOf(100));
        } else {
            baseDataValidator.reset().parameter(FIRST_NAME).value((Object)this.fromApiJsonHelper.extractStringNamed(FIRST_NAME, element)).notNull().notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.extractStringNamed(LAST_NAME, element) != null) {
            String lastName = this.fromApiJsonHelper.extractStringNamed(LAST_NAME, element);
            baseDataValidator.reset().parameter(LAST_NAME).value((Object)lastName).notNull().notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.extractStringNamed(MIDDLE_NAME, element) != null) {
            String middleName = this.fromApiJsonHelper.extractStringNamed(MIDDLE_NAME, element);
            baseDataValidator.reset().parameter(MIDDLE_NAME).value((Object)middleName).notNull().notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.extractStringNamed(QUALIFICATION, element) != null) {
            String qualification = this.fromApiJsonHelper.extractStringNamed(QUALIFICATION, element);
            baseDataValidator.reset().parameter(QUALIFICATION).value((Object)qualification).notNull().notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.extractStringNamed(MOBILE_NUMBER, element) != null) {
            String mobileNumber = this.fromApiJsonHelper.extractStringNamed(MOBILE_NUMBER, element);
            baseDataValidator.reset().parameter(MOBILE_NUMBER).value((Object)mobileNumber).notNull().notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.extractBooleanNamed(IS_DEPENDENT, element) != null) {
            Boolean isDependent = this.fromApiJsonHelper.extractBooleanNamed(IS_DEPENDENT, element);
            baseDataValidator.reset().parameter(IS_DEPENDENT).value((Object)isDependent).notNull().notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.extractLongNamed(RELATION_SHIP_ID, element) != null) {
            long relationShipId = this.fromApiJsonHelper.extractLongNamed(RELATION_SHIP_ID, element);
            baseDataValidator.reset().parameter(RELATION_SHIP_ID).value((Object)relationShipId).notBlank().longGreaterThanZero();
        } else {
            baseDataValidator.reset().parameter(RELATION_SHIP_ID).value((Object)this.fromApiJsonHelper.extractLongNamed(RELATION_SHIP_ID, element)).notBlank().longGreaterThanZero();
        }
        if (this.fromApiJsonHelper.extractLongNamed(MARITAL_STATUS_ID, element) != null) {
            long maritalStatusId = this.fromApiJsonHelper.extractLongNamed(MARITAL_STATUS_ID, element);
            baseDataValidator.reset().parameter(MARITAL_STATUS_ID).value((Object)maritalStatusId).notBlank().longGreaterThanZero();
        }
        if (this.fromApiJsonHelper.extractLongNamed(GENDER_ID, element) != null) {
            long genderId = this.fromApiJsonHelper.extractLongNamed(GENDER_ID, element);
            baseDataValidator.reset().parameter(GENDER_ID).value((Object)genderId).notBlank().longGreaterThanZero();
        }
        if (this.fromApiJsonHelper.extractLongNamed(AGE, element) != null) {
            long age = this.fromApiJsonHelper.extractLongNamed(AGE, element);
            baseDataValidator.reset().parameter(AGE).value((Object)age).notBlank().longGreaterThanZero();
        }
        if (this.fromApiJsonHelper.extractLongNamed(PROFESSION_ID, element) != null) {
            long professionId = this.fromApiJsonHelper.extractLongNamed(PROFESSION_ID, element);
            baseDataValidator.reset().parameter(PROFESSION_ID).value((Object)professionId).notBlank().longGreaterThanZero();
        }
        if (this.fromApiJsonHelper.extractLocalDateNamed(DATE_OF_BIRTH, element) != null) {
            LocalDate dateOfBirth = this.fromApiJsonHelper.extractLocalDateNamed(DATE_OF_BIRTH, element);
            baseDataValidator.reset().parameter(DATE_OF_BIRTH).value((Object)dateOfBirth).value((Object)dateOfBirth).notNull().validateDateBefore(DateUtils.getBusinessLocalDate());
        }
    }

    public void validateForUpdate(long familyMemberId, String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(FAMILY_MEMBERS1);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        baseDataValidator.reset().value((Object)familyMemberId).notBlank().integerGreaterThanZero();
        if (this.fromApiJsonHelper.extractStringNamed(FIRST_NAME, element) != null) {
            String firstName = this.fromApiJsonHelper.extractStringNamed(FIRST_NAME, element);
            baseDataValidator.reset().parameter(FIRST_NAME).value((Object)firstName).notNull().notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.extractStringNamed(LAST_NAME, element) != null) {
            String lastName = this.fromApiJsonHelper.extractStringNamed(LAST_NAME, element);
            baseDataValidator.reset().parameter(LAST_NAME).value((Object)lastName).notNull().notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.extractStringNamed(MIDDLE_NAME, element) != null) {
            String middleName = this.fromApiJsonHelper.extractStringNamed(MIDDLE_NAME, element);
            baseDataValidator.reset().parameter(MIDDLE_NAME).value((Object)middleName).notNull().notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.extractStringNamed(QUALIFICATION, element) != null) {
            String qualification = this.fromApiJsonHelper.extractStringNamed(QUALIFICATION, element);
            baseDataValidator.reset().parameter(QUALIFICATION).value((Object)qualification).notNull().notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.extractLongNamed(RELATION_SHIP_ID, element) != null) {
            long relationShipId = this.fromApiJsonHelper.extractLongNamed(RELATION_SHIP_ID, element);
            baseDataValidator.reset().parameter(RELATION_SHIP_ID).value((Object)relationShipId).notBlank().longGreaterThanZero();
        }
        if (this.fromApiJsonHelper.extractLongNamed(MARITAL_STATUS_ID, element) != null) {
            long maritalStatusId = this.fromApiJsonHelper.extractLongNamed(MARITAL_STATUS_ID, element);
            baseDataValidator.reset().parameter(MARITAL_STATUS_ID).value((Object)maritalStatusId).notBlank().longGreaterThanZero();
        }
        if (this.fromApiJsonHelper.extractLongNamed(GENDER_ID, element) != null) {
            long genderId = this.fromApiJsonHelper.extractLongNamed(GENDER_ID, element);
            baseDataValidator.reset().parameter(GENDER_ID).value((Object)genderId).longGreaterThanZero();
        }
        if (this.fromApiJsonHelper.extractLongNamed(PROFESSION_ID, element) != null) {
            long professionId = this.fromApiJsonHelper.extractLongNamed(PROFESSION_ID, element);
            baseDataValidator.reset().parameter(PROFESSION_ID).value((Object)professionId).longGreaterThanZero();
        }
        if (this.fromApiJsonHelper.extractLocalDateNamed(DATE_OF_BIRTH, element) != null) {
            LocalDate dateOfBirth = this.fromApiJsonHelper.extractLocalDateNamed(DATE_OF_BIRTH, element);
            baseDataValidator.reset().parameter(DATE_OF_BIRTH).value((Object)dateOfBirth).validateDateBefore(DateUtils.getBusinessLocalDate());
        }
    }

    public void validateForDelete(long familyMemberId) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource(FAMILY_MEMBERS1);
        baseDataValidator.reset().value((Object)familyMemberId).notBlank().integerGreaterThanZero();
    }
}

