/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.AccountTransferData;
import org.apache.fineract.portfolio.account.data.PortfolioAccountDTO;
import org.apache.fineract.portfolio.account.data.PortfolioAccountData;
import org.apache.fineract.portfolio.account.domain.AccountTransferType;
import org.apache.fineract.portfolio.account.exception.AccountTransferNotFoundException;
import org.apache.fineract.portfolio.account.mapper.AccountTransfersMapper;
import org.apache.fineract.portfolio.account.service.AccountTransferEnumerations;
import org.apache.fineract.portfolio.account.service.AccountTransfersReadPlatformService;
import org.apache.fineract.portfolio.account.service.PortfolioAccountReadPlatformService;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.CollectionUtils;

public class AccountTransfersReadPlatformServiceImpl
implements AccountTransfersReadPlatformService {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final JdbcTemplate jdbcTemplate;
    private final ClientReadPlatformService clientReadPlatformService;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final PortfolioAccountReadPlatformService portfolioAccountReadPlatformService;
    private final ColumnValidator columnValidator;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final AccountTransfersMapper accountTransfersMapper;
    private final PaginationHelper paginationHelper;
    private final SqlValidator sqlValidator;

    public AccountTransferData retrieveTemplate(Long fromOfficeId, Long fromClientId, Long fromAccountId, Integer fromAccountType, Long toOfficeId, Long toClientId, Long toAccountId, Integer toAccountType) {
        EnumOptionData loanAccountType = AccountTransferEnumerations.accountType((PortfolioAccountType)PortfolioAccountType.LOAN);
        EnumOptionData savingsAccountType = AccountTransferEnumerations.accountType((PortfolioAccountType)PortfolioAccountType.SAVINGS);
        Integer mostRelevantFromAccountType = fromAccountType;
        List<EnumOptionData> fromAccountTypeOptions = Arrays.asList(savingsAccountType, loanAccountType);
        List<EnumOptionData> toAccountTypeOptions = mostRelevantFromAccountType != null && mostRelevantFromAccountType == 1 ? Arrays.asList(savingsAccountType) : Arrays.asList(loanAccountType, savingsAccountType);
        Integer mostRelevantToAccountType = toAccountType;
        EnumOptionData fromAccountTypeData = AccountTransferEnumerations.accountType((Integer)mostRelevantFromAccountType);
        EnumOptionData toAccountTypeData = AccountTransferEnumerations.accountType((Integer)mostRelevantToAccountType);
        OfficeData fromOffice = null;
        ClientData fromClient = null;
        PortfolioAccountData fromAccount = null;
        OfficeData toOffice = null;
        ClientData toClient = null;
        PortfolioAccountData toAccount = null;
        Collection fromAccountOptions = null;
        Collection toAccountOptions = null;
        Long mostRelevantFromOfficeId = fromOfficeId;
        Long mostRelevantFromClientId = fromClientId;
        Long mostRelevantToOfficeId = toOfficeId;
        Long mostRelevantToClientId = toClientId;
        if (fromAccountId != null) {
            Integer accountType = mostRelevantFromAccountType == 1 ? PortfolioAccountType.LOAN.getValue() : PortfolioAccountType.SAVINGS.getValue();
            fromAccount = this.portfolioAccountReadPlatformService.retrieveOne(fromAccountId, accountType);
            mostRelevantFromClientId = fromAccount.getClientId();
        }
        if (mostRelevantFromClientId != null) {
            fromClient = this.clientReadPlatformService.retrieveOne(mostRelevantFromClientId);
            mostRelevantFromOfficeId = fromClient.getOfficeId();
            long[] loanStatus = null;
            if (mostRelevantFromAccountType == 1) {
                loanStatus = new long[]{300L, 700L};
            }
            PortfolioAccountDTO portfolioAccountDTO = new PortfolioAccountDTO(mostRelevantFromAccountType, mostRelevantFromClientId, loanStatus);
            fromAccountOptions = this.portfolioAccountReadPlatformService.retrieveAllForLookup(portfolioAccountDTO);
        }
        Collection fromOfficeOptions = null;
        Collection fromClientOptions = null;
        if (mostRelevantFromOfficeId != null) {
            fromOffice = this.officeReadPlatformService.retrieveOffice(mostRelevantFromOfficeId);
            fromOfficeOptions = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
            fromClientOptions = this.clientReadPlatformService.retrieveAllForLookupByOfficeId(mostRelevantFromOfficeId);
        }
        LocalDate transferDate = DateUtils.getBusinessLocalDate();
        Collection toOfficeOptions = fromOfficeOptions;
        Collection toClientOptions = null;
        if (toAccountId != null && fromAccount != null) {
            toAccount = this.portfolioAccountReadPlatformService.retrieveOne(toAccountId, mostRelevantToAccountType, fromAccount.getCurrencyCodeFromCurrency());
            mostRelevantToClientId = toAccount.getClientId();
        }
        if (mostRelevantToClientId != null) {
            toClient = this.clientReadPlatformService.retrieveOne(mostRelevantToClientId);
            mostRelevantToOfficeId = toClient.getOfficeId();
            toClientOptions = this.clientReadPlatformService.retrieveAllForLookupByOfficeId(mostRelevantToOfficeId);
            toAccountOptions = this.retrieveToAccounts(fromAccount, mostRelevantToAccountType, mostRelevantToClientId);
        }
        if (mostRelevantToOfficeId != null) {
            toOffice = this.officeReadPlatformService.retrieveOffice(mostRelevantToOfficeId);
            toOfficeOptions = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
            toClientOptions = this.clientReadPlatformService.retrieveAllForLookupByOfficeId(mostRelevantToOfficeId);
            if (toClientOptions != null && toClientOptions.size() == 1) {
                toClient = (ClientData)new ArrayList(toClientOptions).get(0);
                toAccountOptions = this.retrieveToAccounts(fromAccount, mostRelevantToAccountType, mostRelevantToClientId);
            }
        }
        return AccountTransferData.template((OfficeData)fromOffice, (ClientData)fromClient, (EnumOptionData)fromAccountTypeData, (PortfolioAccountData)fromAccount, (LocalDate)transferDate, (OfficeData)toOffice, (ClientData)toClient, (EnumOptionData)toAccountTypeData, (PortfolioAccountData)toAccount, (Collection)fromOfficeOptions, (Collection)fromClientOptions, fromAccountTypeOptions, (Collection)fromAccountOptions, (Collection)toOfficeOptions, (Collection)toClientOptions, toAccountTypeOptions, (Collection)toAccountOptions);
    }

    private Collection<PortfolioAccountData> retrieveToAccounts(PortfolioAccountData excludeThisAccountFromOptions, Integer toAccountType, Long toClientId) {
        String currencyCode = excludeThisAccountFromOptions != null ? excludeThisAccountFromOptions.getCurrencyCodeFromCurrency() : null;
        PortfolioAccountDTO portfolioAccountDTO = new PortfolioAccountDTO(toAccountType, toClientId, currencyCode, null, null);
        Collection accountOptions = this.portfolioAccountReadPlatformService.retrieveAllForLookup(portfolioAccountDTO);
        if (!CollectionUtils.isEmpty((Collection)accountOptions)) {
            accountOptions.remove(excludeThisAccountFromOptions);
        } else {
            accountOptions = null;
        }
        return accountOptions;
    }

    public Page<AccountTransferData> retrieveAll(SearchParameters searchParameters, Long accountDetailId) {
        Stream.of(searchParameters.getOrderBy(), searchParameters.getSortOrder(), searchParameters.getExternalId()).forEach(arg_0 -> ((SqlValidator)this.sqlValidator).validate(arg_0));
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(this.accountTransfersMapper.schema());
        Object[] finalObjectArray = new Object[]{};
        if (accountDetailId != null) {
            sqlBuilder.append(" where att.account_transfer_details_id=?");
            finalObjectArray = new Object[]{accountDetailId};
        }
        if (searchParameters.hasOrderBy()) {
            sqlBuilder.append(" order by ").append(searchParameters.getOrderBy());
            this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
            if (searchParameters.hasSortOrder()) {
                sqlBuilder.append(' ').append(searchParameters.getSortOrder());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getSortOrder()});
            }
        }
        if (searchParameters.hasLimit()) {
            sqlBuilder.append(" limit ").append(searchParameters.getLimit());
            if (searchParameters.hasOffset()) {
                sqlBuilder.append(" offset ").append(searchParameters.getOffset());
            }
        }
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), finalObjectArray, (RowMapper)this.accountTransfersMapper);
    }

    public AccountTransferData retrieveOne(Long transferId) {
        try {
            String sql = "select " + this.accountTransfersMapper.schema() + " where att.id = ?";
            return (AccountTransferData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.accountTransfersMapper, new Object[]{transferId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new AccountTransferNotFoundException(transferId, e);
        }
    }

    public Collection<Long> fetchPostInterestTransactionIds(Long accountId) {
        String sql = "select att.from_savings_transaction_id from m_account_transfer_transaction att inner join m_account_transfer_details atd on atd.id = att.account_transfer_details_id where atd.from_savings_account_id=? and att.is_reversed = false and atd.transfer_type = ?";
        return this.jdbcTemplate.queryForList("select att.from_savings_transaction_id from m_account_transfer_transaction att inner join m_account_transfer_details atd on atd.id = att.account_transfer_details_id where atd.from_savings_account_id=? and att.is_reversed = false and atd.transfer_type = ?", Long.class, new Object[]{accountId, AccountTransferType.INTEREST_TRANSFER.getValue()});
    }

    public Collection<Long> fetchPostInterestTransactionIdsWithPivotDate(Long accountId, LocalDate pivotDate) {
        String sql = "select att.from_savings_transaction_id from m_account_transfer_transaction att inner join m_account_transfer_details atd on atd.id = att.account_transfer_details_id where atd.from_savings_account_id=? and att.is_reversed = false and atd.transfer_type = ? and att.transaction_date >= ?";
        return this.jdbcTemplate.queryForList("select att.from_savings_transaction_id from m_account_transfer_transaction att inner join m_account_transfer_details atd on atd.id = att.account_transfer_details_id where atd.from_savings_account_id=? and att.is_reversed = false and atd.transfer_type = ? and att.transaction_date >= ?", Long.class, new Object[]{accountId, AccountTransferType.INTEREST_TRANSFER.getValue(), pivotDate});
    }

    public boolean isAccountTransfer(Long transactionId, PortfolioAccountType accountType) {
        StringBuilder sql = new StringBuilder("select count(*) from m_account_transfer_transaction at where ");
        if (accountType.isLoanAccount()) {
            sql.append("at.from_loan_transaction_id=").append(transactionId).append(" or at.to_loan_transaction_id=").append(transactionId);
        } else {
            sql.append("at.from_savings_transaction_id=").append(transactionId).append(" or at.to_savings_transaction_id=").append(transactionId);
        }
        int count = (Integer)this.jdbcTemplate.queryForObject(sql.toString(), Integer.class);
        return count > 0;
    }

    public Page<AccountTransferData> retrieveByStandingInstruction(Long id, SearchParameters searchParameters) {
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(this.accountTransfersMapper.schema()).append(" join m_account_transfer_standing_instructions atsi on atsi.account_transfer_details_id = att.account_transfer_details_id ");
        sqlBuilder.append(" where atsi.id = ?");
        if (searchParameters != null) {
            if (searchParameters.hasOrderBy()) {
                sqlBuilder.append(" order by ").append(searchParameters.getOrderBy());
                this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getOrderBy()});
                if (searchParameters.hasSortOrder()) {
                    sqlBuilder.append(' ').append(searchParameters.getSortOrder());
                    this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{searchParameters.getSortOrder()});
                }
            }
            if (searchParameters.hasLimit()) {
                sqlBuilder.append(" ");
                if (searchParameters.hasOffset()) {
                    sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue(), searchParameters.getOffset().intValue()));
                } else {
                    sqlBuilder.append(this.sqlGenerator.limit(searchParameters.getLimit().intValue()));
                }
            }
        }
        Object[] finalObjectArray = new Object[]{id};
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), finalObjectArray, (RowMapper)this.accountTransfersMapper);
    }

    public AccountTransferData retrieveRefundByTransferTemplate(Long fromOfficeId, Long fromClientId, Long fromAccountId, Integer fromAccountType, Long toOfficeId, Long toClientId, Long toAccountId, Integer toAccountType) {
        EnumOptionData loanAccountType = AccountTransferEnumerations.accountType((PortfolioAccountType)PortfolioAccountType.LOAN);
        EnumOptionData savingsAccountType = AccountTransferEnumerations.accountType((PortfolioAccountType)PortfolioAccountType.SAVINGS);
        Integer mostRelevantFromAccountType = fromAccountType;
        List<EnumOptionData> fromAccountTypeOptions = Arrays.asList(savingsAccountType, loanAccountType);
        List<EnumOptionData> toAccountTypeOptions = mostRelevantFromAccountType == 1 ? Arrays.asList(savingsAccountType) : Arrays.asList(loanAccountType, savingsAccountType);
        Integer mostRelevantToAccountType = toAccountType;
        EnumOptionData fromAccountTypeData = AccountTransferEnumerations.accountType((Integer)mostRelevantFromAccountType);
        EnumOptionData toAccountTypeData = AccountTransferEnumerations.accountType((Integer)mostRelevantToAccountType);
        OfficeData fromOffice = null;
        ClientData fromClient = null;
        PortfolioAccountData fromAccount = null;
        OfficeData toOffice = null;
        ClientData toClient = null;
        PortfolioAccountData toAccount = null;
        Collection fromAccountOptions = null;
        Collection toAccountOptions = null;
        Long mostRelevantFromOfficeId = fromOfficeId;
        Long mostRelevantFromClientId = fromClientId;
        Long mostRelevantToOfficeId = toOfficeId;
        Long mostRelevantToClientId = toClientId;
        if (fromAccountId != null) {
            Integer accountType = mostRelevantFromAccountType == 1 ? PortfolioAccountType.LOAN.getValue() : PortfolioAccountType.SAVINGS.getValue();
            fromAccount = this.portfolioAccountReadPlatformService.retrieveOneByPaidInAdvance(fromAccountId, accountType);
            mostRelevantFromClientId = fromAccount.getClientId();
        }
        if (mostRelevantFromClientId != null) {
            fromClient = this.clientReadPlatformService.retrieveOne(mostRelevantFromClientId);
            mostRelevantFromOfficeId = fromClient.getOfficeId();
            long[] loanStatus = null;
            if (mostRelevantFromAccountType == 1) {
                loanStatus = new long[]{300L, 700L};
            }
            PortfolioAccountDTO portfolioAccountDTO = new PortfolioAccountDTO(mostRelevantFromAccountType, mostRelevantFromClientId, loanStatus);
            fromAccountOptions = this.portfolioAccountReadPlatformService.retrieveAllForLookup(portfolioAccountDTO);
        }
        Collection fromOfficeOptions = null;
        Collection fromClientOptions = null;
        if (mostRelevantFromOfficeId != null) {
            fromOffice = this.officeReadPlatformService.retrieveOffice(mostRelevantFromOfficeId);
            fromOfficeOptions = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
            fromClientOptions = this.clientReadPlatformService.retrieveAllForLookupByOfficeId(mostRelevantFromOfficeId);
        }
        LocalDate transferDate = DateUtils.getBusinessLocalDate();
        Collection toOfficeOptions = fromOfficeOptions;
        Collection toClientOptions = null;
        if (toAccountId != null && fromAccount != null) {
            toAccount = this.portfolioAccountReadPlatformService.retrieveOne(toAccountId, mostRelevantToAccountType, fromAccount.getCurrencyCodeFromCurrency());
            mostRelevantToClientId = toAccount.getClientId();
        }
        if (mostRelevantToClientId != null) {
            toClient = this.clientReadPlatformService.retrieveOne(mostRelevantToClientId);
            mostRelevantToOfficeId = toClient.getOfficeId();
            toClientOptions = this.clientReadPlatformService.retrieveAllForLookupByOfficeId(mostRelevantToOfficeId);
            toAccountOptions = this.retrieveToAccounts(fromAccount, mostRelevantToAccountType, mostRelevantToClientId);
        }
        if (mostRelevantToOfficeId != null) {
            toOffice = this.officeReadPlatformService.retrieveOffice(mostRelevantToOfficeId);
            toOfficeOptions = this.officeReadPlatformService.retrieveAllOfficesForDropdown();
            toClientOptions = this.clientReadPlatformService.retrieveAllForLookupByOfficeId(mostRelevantToOfficeId);
            if (toClientOptions != null && toClientOptions.size() == 1) {
                toClient = (ClientData)new ArrayList(toClientOptions).get(0);
                toAccountOptions = this.retrieveToAccounts(fromAccount, mostRelevantToAccountType, mostRelevantToClientId);
            }
        }
        return AccountTransferData.template((OfficeData)fromOffice, (ClientData)fromClient, (EnumOptionData)fromAccountTypeData, (PortfolioAccountData)fromAccount, (LocalDate)transferDate, (OfficeData)toOffice, (ClientData)toClient, (EnumOptionData)toAccountTypeData, (PortfolioAccountData)toAccount, (Collection)fromOfficeOptions, (Collection)fromClientOptions, fromAccountTypeOptions, (Collection)fromAccountOptions, (Collection)toOfficeOptions, (Collection)toClientOptions, toAccountTypeOptions, (Collection)toAccountOptions);
    }

    public BigDecimal getTotalTransactionAmount(Long accountId, Integer accountType, LocalDate transactionDate) {
        StringBuilder sqlBuilder = new StringBuilder(" select sum(trans.amount) as totalTransactionAmount ");
        sqlBuilder.append(" from m_account_transfer_details as det ");
        sqlBuilder.append(" inner join m_account_transfer_transaction as trans ");
        sqlBuilder.append(" on det.id = trans.account_transfer_details_id ");
        sqlBuilder.append(" where trans.is_reversed = false ");
        sqlBuilder.append(" and trans.transaction_date = ? ");
        sqlBuilder.append(" and IF(1=?, det.from_loan_account_id = ?, det.from_savings_account_id = ?) ");
        return (BigDecimal)this.jdbcTemplate.queryForObject(sqlBuilder.toString(), BigDecimal.class, new Object[]{DATE_TIME_FORMATTER.format(transactionDate), accountType, accountId, accountId});
    }

    @Generated
    public AccountTransfersReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, ClientReadPlatformService clientReadPlatformService, OfficeReadPlatformService officeReadPlatformService, PortfolioAccountReadPlatformService portfolioAccountReadPlatformService, ColumnValidator columnValidator, DatabaseSpecificSQLGenerator sqlGenerator, AccountTransfersMapper accountTransfersMapper, PaginationHelper paginationHelper, SqlValidator sqlValidator) {
        this.jdbcTemplate = jdbcTemplate;
        this.clientReadPlatformService = clientReadPlatformService;
        this.officeReadPlatformService = officeReadPlatformService;
        this.portfolioAccountReadPlatformService = portfolioAccountReadPlatformService;
        this.columnValidator = columnValidator;
        this.sqlGenerator = sqlGenerator;
        this.accountTransfersMapper = accountTransfersMapper;
        this.paginationHelper = paginationHelper;
        this.sqlValidator = sqlValidator;
    }
}

