/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.workingdays.service;

import java.util.Arrays;
import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.organisation.workingdays.data.WorkingDaysData;
import org.apache.fineract.organisation.workingdays.domain.RepaymentRescheduleType;
import org.apache.fineract.organisation.workingdays.domain.WorkingDaysEnumerations;
import org.apache.fineract.organisation.workingdays.exception.WorkingDaysNotFoundException;
import org.apache.fineract.organisation.workingdays.service.WorkingDaysReadPlatformService;
import org.apache.fineract.organisation.workingdays.service.WorkingDaysReadPlatformServiceImpl;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class WorkingDaysReadPlatformServiceImpl
implements WorkingDaysReadPlatformService {
    private final JdbcTemplate jdbcTemplate;

    public WorkingDaysData retrieve() {
        try {
            WorkingDaysMapper rm = new WorkingDaysMapper();
            String sql = " select " + rm.schema();
            WorkingDaysData data = (WorkingDaysData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm);
            Collection repaymentRescheduleOptions = this.repaymentRescheduleTypeOptions();
            return new WorkingDaysData(data, repaymentRescheduleOptions);
        }
        catch (EmptyResultDataAccessException e) {
            throw new WorkingDaysNotFoundException(e);
        }
    }

    public WorkingDaysData repaymentRescheduleType() {
        Collection repaymentRescheduleOptions = this.repaymentRescheduleTypeOptions();
        return new WorkingDaysData(null, null, null, repaymentRescheduleOptions, null, null);
    }

    private Collection<EnumOptionData> repaymentRescheduleTypeOptions() {
        return Arrays.asList(WorkingDaysEnumerations.repaymentRescheduleType((RepaymentRescheduleType)RepaymentRescheduleType.SAME_DAY), WorkingDaysEnumerations.repaymentRescheduleType((RepaymentRescheduleType)RepaymentRescheduleType.MOVE_TO_NEXT_WORKING_DAY), WorkingDaysEnumerations.repaymentRescheduleType((RepaymentRescheduleType)RepaymentRescheduleType.MOVE_TO_NEXT_REPAYMENT_MEETING_DAY), WorkingDaysEnumerations.repaymentRescheduleType((RepaymentRescheduleType)RepaymentRescheduleType.MOVE_TO_PREVIOUS_WORKING_DAY));
    }

    @Generated
    public WorkingDaysReadPlatformServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

