/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.teller.service;

import jakarta.persistence.PersistenceException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.accounting.common.AccountingConstants;
import org.apache.fineract.accounting.financialactivityaccount.domain.FinancialActivityAccount;
import org.apache.fineract.accounting.financialactivityaccount.domain.FinancialActivityAccountRepositoryWrapper;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.accounting.journalentry.domain.JournalEntry;
import org.apache.fineract.accounting.journalentry.domain.JournalEntryRepository;
import org.apache.fineract.accounting.journalentry.domain.JournalEntryType;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.security.exception.NoAuthorizationException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepository;
import org.apache.fineract.organisation.staff.exception.StaffNotFoundException;
import org.apache.fineract.organisation.teller.data.CashierTransactionDataValidator;
import org.apache.fineract.organisation.teller.domain.Cashier;
import org.apache.fineract.organisation.teller.domain.CashierRepository;
import org.apache.fineract.organisation.teller.domain.CashierTransaction;
import org.apache.fineract.organisation.teller.domain.CashierTransactionRepository;
import org.apache.fineract.organisation.teller.domain.CashierTxnType;
import org.apache.fineract.organisation.teller.domain.Teller;
import org.apache.fineract.organisation.teller.domain.TellerRepositoryWrapper;
import org.apache.fineract.organisation.teller.exception.CashierExistForTellerException;
import org.apache.fineract.organisation.teller.exception.CashierNotFoundException;
import org.apache.fineract.organisation.teller.serialization.TellerCommandFromApiJsonDeserializer;
import org.apache.fineract.organisation.teller.service.TellerWritePlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class TellerWritePlatformServiceJpaImpl
implements TellerWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TellerWritePlatformServiceJpaImpl.class);
    private final PlatformSecurityContext context;
    private final TellerCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final TellerRepositoryWrapper tellerRepositoryWrapper;
    private final OfficeRepositoryWrapper officeRepositoryWrapper;
    private final StaffRepository staffRepository;
    private final CashierRepository cashierRepository;
    private final CashierTransactionRepository cashierTxnRepository;
    private final JournalEntryRepository glJournalEntryRepository;
    private final FinancialActivityAccountRepositoryWrapper financialActivityAccountRepositoryWrapper;
    private final CashierTransactionDataValidator cashierTransactionDataValidator;

    @Transactional
    public CommandProcessingResult createTeller(JsonCommand command) {
        try {
            this.context.authenticatedUser();
            Long officeId = command.longValueOfParameterNamed("officeId");
            this.fromApiJsonDeserializer.validateForCreateAndUpdateTeller(command.json());
            Office tellerOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(officeId);
            Teller teller = Teller.fromJson((Office)tellerOffice, (JsonCommand)command);
            this.tellerRepositoryWrapper.saveAndFlush(teller);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)teller.getId()).withOfficeId((Long)teller.getOffice().getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleTellerDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleTellerDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult modifyTeller(Long tellerId, JsonCommand command) {
        try {
            Long officeId = command.longValueOfParameterNamed("officeId");
            Office tellerOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(officeId);
            AppUser currentUser = this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreateAndUpdateTeller(command.json());
            Teller teller = this.validateUserPriviledgeOnTellerAndRetrieve(currentUser, tellerId);
            Map changes = teller.update(tellerOffice, command);
            if (!changes.isEmpty()) {
                this.tellerRepositoryWrapper.saveAndFlush(teller);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)teller.getId()).withOfficeId(teller.officeId()).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleTellerDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleTellerDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    private Teller validateUserPriviledgeOnTellerAndRetrieve(AppUser currentUser, Long tellerId) {
        Teller tellerToReturn;
        Long tellerOfficeId;
        Long userOfficeId = (Long)currentUser.getOffice().getId();
        Office userOffice = this.officeRepositoryWrapper.findOfficeHierarchy(userOfficeId);
        if (userOffice.doesNotHaveAnOfficeInHierarchyWithId(tellerOfficeId = (tellerToReturn = this.tellerRepositoryWrapper.findOneWithNotFoundDetection(tellerId)).officeId())) {
            throw new NoAuthorizationException("User does not have sufficient priviledges to act on the provided office.");
        }
        return tellerToReturn;
    }

    @Transactional
    public CommandProcessingResult deleteTeller(Long tellerId) {
        Teller teller = this.tellerRepositoryWrapper.findOneWithNotFoundDetection(tellerId);
        Set isTellerIdPresentInCashier = teller.getCashiers();
        for (Cashier tellerIdInCashier : isTellerIdPresentInCashier) {
            if (!((Long)tellerIdInCashier.getTeller().getId()).toString().equalsIgnoreCase(tellerId.toString())) continue;
            throw new CashierExistForTellerException(tellerId);
        }
        this.tellerRepositoryWrapper.delete(teller);
        return new CommandProcessingResultBuilder().withEntityId((Long)teller.getId()).build();
    }

    private void handleTellerDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("m_tellers_name_unq")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.teller.duplicate.name", "Teller with name `" + name + "` already exists", "name", new Object[]{name});
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.teller.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    public CommandProcessingResult allocateCashierToTeller(Long tellerId, JsonCommand command) {
        try {
            this.context.authenticatedUser();
            Object startTime = " ";
            Object endTime = " ";
            Teller teller = this.tellerRepositoryWrapper.findOneWithNotFoundDetection(tellerId);
            Office tellerOffice = teller.getOffice();
            Long staffId = command.longValueOfParameterNamed("staffId");
            this.fromApiJsonDeserializer.validateForAllocateCashier(command.json());
            Staff staff = (Staff)this.staffRepository.findById((Object)staffId).orElseThrow(() -> new StaffNotFoundException(staffId));
            Boolean isFullDay = command.booleanObjectValueOfParameterNamed("isFullDay");
            if (!isFullDay.booleanValue()) {
                Long hourStartTime = command.longValueOfParameterNamed("hourStartTime");
                Long minStartTime = command.longValueOfParameterNamed("minStartTime");
                startTime = minStartTime == 0L ? hourStartTime.toString() + ":" + minStartTime.toString() + "0" : hourStartTime.toString() + ":" + minStartTime.toString();
                Long hourEndTime = command.longValueOfParameterNamed("hourEndTime");
                Long minEndTime = command.longValueOfParameterNamed("minEndTime");
                endTime = minEndTime == 0L ? hourEndTime.toString() + ":" + minEndTime.toString() + "0" : hourEndTime.toString() + ":" + minEndTime.toString();
            }
            Cashier cashier = Cashier.fromJson((Office)tellerOffice, (Teller)teller, (Staff)staff, (String)startTime, (String)endTime, (JsonCommand)command);
            this.cashierTransactionDataValidator.validateCashierAllowedDateAndTime(cashier, teller);
            this.cashierRepository.save((Object)cashier);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)teller.getId()).withSubEntityId((Long)cashier.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleTellerDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleTellerDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult updateCashierAllocation(Long tellerId, Long cashierId, JsonCommand command) {
        try {
            AppUser currentUser = this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForAllocateCashier(command.json());
            Long staffId = command.longValueOfParameterNamed("staffId");
            Staff staff = (Staff)this.staffRepository.findById((Object)staffId).orElseThrow(() -> new StaffNotFoundException(staffId));
            Cashier cashier = this.validateUserPriviledgeOnCashierAndRetrieve(currentUser, tellerId, cashierId);
            cashier.setStaff(staff);
            Map changes = cashier.update(command);
            if (!changes.isEmpty()) {
                this.cashierRepository.saveAndFlush((Object)cashier);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)cashier.getTeller().getId()).withSubEntityId((Long)cashier.getId()).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleTellerDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleTellerDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    private Cashier validateUserPriviledgeOnCashierAndRetrieve(AppUser currentUser, Long tellerId, Long cashierId) {
        this.validateUserPriviledgeOnTellerAndRetrieve(currentUser, tellerId);
        return this.cashierRepository.findById((Object)cashierId).orElse(null);
    }

    @Transactional
    public CommandProcessingResult deleteCashierAllocation(Long tellerId, Long cashierId, JsonCommand command) {
        try {
            AppUser currentUser = this.context.authenticatedUser();
            Cashier cashier = this.validateUserPriviledgeOnCashierAndRetrieve(currentUser, tellerId, cashierId);
            this.cashierRepository.delete((Object)cashier);
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleTellerDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleTellerDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
        return new CommandProcessingResultBuilder().withEntityId(cashierId).build();
    }

    public CommandProcessingResult allocateCashToCashier(Long cashierId, JsonCommand command) {
        return this.doTransactionForCashier(cashierId, CashierTxnType.ALLOCATE, command);
    }

    public CommandProcessingResult settleCashFromCashier(Long cashierId, JsonCommand command) {
        this.cashierTransactionDataValidator.validateSettleCashAndCashOutTransactions(cashierId, command);
        return this.doTransactionForCashier(cashierId, CashierTxnType.SETTLE, command);
    }

    private CommandProcessingResult doTransactionForCashier(Long cashierId, CashierTxnType txnType, JsonCommand command) {
        try {
            AppUser currentUser = this.context.authenticatedUser();
            Cashier cashier = (Cashier)this.cashierRepository.findById((Object)cashierId).orElseThrow(() -> new CashierNotFoundException(cashierId));
            this.fromApiJsonDeserializer.validateForCashTxnForCashier(command.json());
            String entityType = command.stringValueOfParameterNamed("entityType");
            if (entityType != null) {
                if (entityType.equals("loan account") || entityType.equals("savings account")) {
                    // empty if block
                }
                if (entityType.equals("client")) {
                    // empty if block
                }
            }
            CashierTransaction cashierTxn = CashierTransaction.fromJson((Cashier)cashier, (JsonCommand)command);
            cashierTxn.setTxnType(txnType.getId());
            this.cashierTxnRepository.save((Object)cashierTxn);
            FinancialActivityAccount mainVaultFinancialActivityAccount = this.financialActivityAccountRepositoryWrapper.findByFinancialActivityTypeWithNotFoundDetection(AccountingConstants.FinancialActivity.CASH_AT_MAINVAULT.getValue().intValue());
            FinancialActivityAccount tellerCashFinancialActivityAccount = this.financialActivityAccountRepositoryWrapper.findByFinancialActivityTypeWithNotFoundDetection(AccountingConstants.FinancialActivity.CASH_AT_TELLER.getValue().intValue());
            GLAccount creditAccount = null;
            GLAccount debitAccount = null;
            if (txnType.equals(CashierTxnType.ALLOCATE)) {
                debitAccount = tellerCashFinancialActivityAccount.getGlAccount();
                creditAccount = mainVaultFinancialActivityAccount.getGlAccount();
            } else if (txnType.equals(CashierTxnType.SETTLE)) {
                debitAccount = mainVaultFinancialActivityAccount.getGlAccount();
                creditAccount = tellerCashFinancialActivityAccount.getGlAccount();
            }
            Office cashierOffice = cashier.getTeller().getOffice();
            Long time = System.currentTimeMillis();
            String uniqueVal = String.valueOf(time) + String.valueOf(currentUser.getId()) + String.valueOf(cashierOffice.getId());
            String transactionId = Long.toHexString(Long.parseLong(uniqueVal));
            JournalEntry debitJournalEntry = JournalEntry.createNew((Office)cashierOffice, null, (GLAccount)debitAccount, (String)cashierTxn.getCurrencyCode(), (String)transactionId, (boolean)false, (LocalDate)cashierTxn.getTxnDate(), (JournalEntryType)JournalEntryType.DEBIT, (BigDecimal)cashierTxn.getTxnAmount(), (String)cashierTxn.getTxnNote(), null, null, null, null, null, null, null);
            JournalEntry creditJournalEntry = JournalEntry.createNew((Office)cashierOffice, null, (GLAccount)creditAccount, (String)cashierTxn.getCurrencyCode(), (String)transactionId, (boolean)false, (LocalDate)cashierTxn.getTxnDate(), (JournalEntryType)JournalEntryType.CREDIT, (BigDecimal)cashierTxn.getTxnAmount(), (String)cashierTxn.getTxnNote(), null, null, null, null, null, null, null);
            this.glJournalEntryRepository.saveAndFlush((Object)debitJournalEntry);
            this.glJournalEntryRepository.saveAndFlush((Object)creditJournalEntry);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)cashier.getId()).withSubEntityId((Long)cashierTxn.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleTellerDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleTellerDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Generated
    public TellerWritePlatformServiceJpaImpl(PlatformSecurityContext context, TellerCommandFromApiJsonDeserializer fromApiJsonDeserializer, TellerRepositoryWrapper tellerRepositoryWrapper, OfficeRepositoryWrapper officeRepositoryWrapper, StaffRepository staffRepository, CashierRepository cashierRepository, CashierTransactionRepository cashierTxnRepository, JournalEntryRepository glJournalEntryRepository, FinancialActivityAccountRepositoryWrapper financialActivityAccountRepositoryWrapper, CashierTransactionDataValidator cashierTransactionDataValidator) {
        this.context = context;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.tellerRepositoryWrapper = tellerRepositoryWrapper;
        this.officeRepositoryWrapper = officeRepositoryWrapper;
        this.staffRepository = staffRepository;
        this.cashierRepository = cashierRepository;
        this.cashierTxnRepository = cashierTxnRepository;
        this.glJournalEntryRepository = glJournalEntryRepository;
        this.financialActivityAccountRepositoryWrapper = financialActivityAccountRepositoryWrapper;
        this.cashierTransactionDataValidator = cashierTransactionDataValidator;
    }
}

