/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.springbatch.messagehandler.kafka;

import java.util.HashMap;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.springbatch.ContextualMessage;
import org.apache.fineract.infrastructure.springbatch.OutputChannelInterceptor;
import org.apache.fineract.infrastructure.springbatch.messagehandler.conditions.kafka.KafkaManagerCondition;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.springframework.batch.integration.config.annotation.EnableBatchIntegration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.handler.LoggingHandler;
import org.springframework.integration.kafka.outbound.KafkaProducerMessageHandler;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.serializer.JsonSerializer;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.ChannelInterceptor;

@Configuration
@EnableBatchIntegration
@Conditional(value={KafkaManagerCondition.class})
public class KafkaManagerConfig {
    @Autowired
    private DirectChannel outboundRequests;
    @Autowired
    private OutputChannelInterceptor outputInterceptor;
    @Autowired
    private FineractProperties fineractProperties;

    @Bean
    public ProducerFactory<Object, Object> producerFactory() {
        HashMap<String, Object> props = new HashMap<String, Object>(this.fineractProperties.getRemoteJobMessageHandler().getKafka().getProducer().getExtraPropertiesMap());
        props.put("bootstrap.servers", this.fineractProperties.getRemoteJobMessageHandler().getKafka().getBootstrapServers());
        props.put("key.serializer", IntegerSerializer.class);
        props.put("value.serializer", JsonSerializer.class);
        return new DefaultKafkaProducerFactory(props);
    }

    @Bean
    public KafkaTemplate<?, ?> kafkaTemplate(ProducerFactory<Object, Object> producerFactory) {
        return new KafkaTemplate(producerFactory);
    }

    @Bean
    public IntegrationFlow outboundFlow(KafkaTemplate<?, ?> kafkaTemplate) {
        FineractProperties.KafkaTopicProperties topic = this.fineractProperties.getRemoteJobMessageHandler().getKafka().getTopic();
        KafkaProducerMessageHandler messageHandler = new KafkaProducerMessageHandler(kafkaTemplate);
        messageHandler.setTopicExpression((Expression)new LiteralExpression(topic.getName()));
        messageHandler.setPartitionIdExpression((Expression)new FunctionExpression(message -> ((ContextualMessage)message.getPayload()).getStepExecutionRequest().getStepExecutionId() % (long)topic.getPartitions()));
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((MessageChannel)this.outboundRequests).intercept(new ChannelInterceptor[]{this.outputInterceptor})).log(LoggingHandler.Level.DEBUG)).handle((MessageHandler)messageHandler)).get();
    }
}

