/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.sms.domain;

import com.google.gson.JsonElement;
import org.apache.fineract.infrastructure.campaigns.sms.domain.SmsCampaign;
import org.apache.fineract.infrastructure.campaigns.sms.domain.SmsCampaignRepository;
import org.apache.fineract.infrastructure.campaigns.sms.exception.SmsCampaignNotFound;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.sms.domain.SmsMessage;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageRepository;
import org.apache.fineract.infrastructure.sms.exception.SmsNotFoundException;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepositoryWrapper;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepositoryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SmsMessageAssembler {
    private final SmsMessageRepository smsMessageRepository;
    private final GroupRepositoryWrapper groupRepository;
    private final ClientRepositoryWrapper clientRepository;
    private final StaffRepositoryWrapper staffRepository;
    private final SmsCampaignRepository smsCampaignRepository;
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public SmsMessageAssembler(SmsMessageRepository smsMessageRepository, GroupRepositoryWrapper groupRepositoryWrapper, ClientRepositoryWrapper clientRepository, StaffRepositoryWrapper staffRepository, FromJsonHelper fromApiJsonHelper, SmsCampaignRepository smsCampaignRepository) {
        this.smsMessageRepository = smsMessageRepository;
        this.groupRepository = groupRepositoryWrapper;
        this.clientRepository = clientRepository;
        this.staffRepository = staffRepository;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.smsCampaignRepository = smsCampaignRepository;
    }

    public SmsMessage assembleFromJson(JsonCommand command) {
        JsonElement element = command.parsedJson();
        String mobileNo = null;
        Group group = null;
        String externalId = null;
        if (this.fromApiJsonHelper.parameterExists("groupId", element)) {
            Long groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element);
            group = this.groupRepository.findOneWithNotFoundDetection(groupId);
        }
        SmsCampaign smsCampaign = null;
        boolean isNotification = false;
        if (this.fromApiJsonHelper.parameterExists("campaignId", element)) {
            Long campaignId = this.fromApiJsonHelper.extractLongNamed("campaignId", element);
            smsCampaign = (SmsCampaign)this.smsCampaignRepository.findById((Object)campaignId).orElseThrow(() -> new SmsCampaignNotFound(campaignId));
            isNotification = smsCampaign.isNotification();
        }
        Client client = null;
        if (this.fromApiJsonHelper.parameterExists("clientId", element)) {
            Long clientId = this.fromApiJsonHelper.extractLongNamed("clientId", element);
            client = this.clientRepository.findOneWithNotFoundDetection(clientId);
            mobileNo = client.mobileNo();
        }
        Staff staff = null;
        if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
            Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
            staff = this.staffRepository.findOneWithNotFoundDetection(staffId);
            mobileNo = staff.mobileNo();
        }
        String message = this.fromApiJsonHelper.extractStringNamed("message", element);
        return SmsMessage.pendingSms(externalId, (Group)group, (Client)client, (Staff)staff, (String)message, (String)mobileNo, (SmsCampaign)smsCampaign, (boolean)isNotification);
    }

    public SmsMessage assembleFromResourceId(Long resourceId) {
        return (SmsMessage)this.smsMessageRepository.findById((Object)resourceId).orElseThrow(() -> new SmsNotFoundException(resourceId));
    }
}

