/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.security.vote;

import java.util.function.Supplier;
import org.apache.fineract.useradministration.domain.AppUser;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;

public class SelfServiceUserAuthorizationManager
implements AuthorizationManager<RequestAuthorizationContext> {
    public AuthorizationDecision check(Supplier<Authentication> authentication, RequestAuthorizationContext fi) {
        if (!"OPTIONS".equalsIgnoreCase(fi.getRequest().getMethod())) {
            boolean notAllowed;
            AppUser user = (AppUser)authentication.get().getPrincipal();
            String pathURL = fi.getRequest().getRequestURL().toString();
            boolean isSelfServiceRequest = pathURL.contains("/self/");
            boolean bl = notAllowed = isSelfServiceRequest && !user.isSelfServiceUser() || !isSelfServiceRequest && user.isSelfServiceUser();
            if (notAllowed) {
                return new AuthorizationDecision(false);
            }
        }
        return new AuthorizationDecision(true);
    }

    public static SelfServiceUserAuthorizationManager selfServiceUserAuthManager() {
        return new SelfServiceUserAuthorizationManager();
    }
}

