/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service;

import io.github.resilience4j.retry.annotation.Retry;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.jobs.data.JobDetailDataValidator;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobDetail;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobDetailRepository;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobRunHistory;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobRunHistoryRepository;
import org.apache.fineract.infrastructure.jobs.domain.SchedulerDetail;
import org.apache.fineract.infrastructure.jobs.domain.SchedulerDetailRepository;
import org.apache.fineract.infrastructure.jobs.exception.JobNotFoundException;
import org.apache.fineract.infrastructure.jobs.service.SchedularWritePlatformService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SchedularWritePlatformServiceJpaRepositoryImpl
implements SchedularWritePlatformService {
    private final ScheduledJobDetailRepository scheduledJobDetailsRepository;
    private final ScheduledJobRunHistoryRepository scheduledJobRunHistoryRepository;
    private final SchedulerDetailRepository schedulerDetailRepository;
    private final JobDetailDataValidator dataValidator;

    @Autowired
    public SchedularWritePlatformServiceJpaRepositoryImpl(ScheduledJobDetailRepository scheduledJobDetailsRepository, ScheduledJobRunHistoryRepository scheduledJobRunHistoryRepository, JobDetailDataValidator dataValidator, SchedulerDetailRepository schedulerDetailRepository) {
        this.scheduledJobDetailsRepository = scheduledJobDetailsRepository;
        this.scheduledJobRunHistoryRepository = scheduledJobRunHistoryRepository;
        this.schedulerDetailRepository = schedulerDetailRepository;
        this.dataValidator = dataValidator;
    }

    public List<ScheduledJobDetail> retrieveAllJobs(String nodeId) {
        return this.scheduledJobDetailsRepository.findAllJobs(Integer.valueOf(Integer.parseInt(nodeId)));
    }

    public ScheduledJobDetail findByJobKey(String jobKey) {
        return this.scheduledJobDetailsRepository.findByJobKey(jobKey);
    }

    @Transactional
    public void saveOrUpdate(ScheduledJobDetail scheduledJobDetails) {
        this.scheduledJobDetailsRepository.save((Object)scheduledJobDetails);
    }

    @Transactional
    public void saveOrUpdate(ScheduledJobDetail scheduledJobDetails, ScheduledJobRunHistory scheduledJobRunHistory) {
        this.scheduledJobDetailsRepository.save((Object)scheduledJobDetails);
        this.scheduledJobRunHistoryRepository.save((Object)scheduledJobRunHistory);
    }

    public Long fetchMaxVersionBy(String jobKey) {
        Long version = 0L;
        Long versionFromDB = this.scheduledJobRunHistoryRepository.findMaxVersionByJobKey(jobKey);
        if (versionFromDB != null) {
            version = versionFromDB;
        }
        return version;
    }

    public ScheduledJobDetail findByJobId(Long jobId) {
        return this.scheduledJobDetailsRepository.findByJobId(jobId);
    }

    @Transactional
    public void updateSchedulerDetail(SchedulerDetail schedulerDetail) {
        this.schedulerDetailRepository.save((Object)schedulerDetail);
    }

    public SchedulerDetail retriveSchedulerDetail() {
        SchedulerDetail schedulerDetail = null;
        List schedulerDetailList = this.schedulerDetailRepository.findAll();
        if (schedulerDetailList != null) {
            schedulerDetail = (SchedulerDetail)schedulerDetailList.get(0);
        }
        return schedulerDetail;
    }

    @Transactional
    public CommandProcessingResult updateJobDetail(Long jobId, JsonCommand command) {
        this.dataValidator.validateForUpdate(command.json());
        ScheduledJobDetail scheduledJobDetail = this.findByJobId(jobId);
        if (scheduledJobDetail == null) {
            throw new JobNotFoundException(String.valueOf(jobId));
        }
        Map changes = scheduledJobDetail.update(command);
        if (!changes.isEmpty()) {
            this.scheduledJobDetailsRepository.saveAndFlush((Object)scheduledJobDetail);
        }
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(jobId).with(changes).build();
    }

    @Transactional
    @Retry(name="processJobDetailForExecution", fallbackMethod="fallbackProcessJobDetailForExecution")
    public boolean processJobDetailForExecution(String jobKey, String triggerType) {
        boolean isStopExecution = false;
        ScheduledJobDetail scheduledJobDetail = this.scheduledJobDetailsRepository.findByJobKeyWithLock(jobKey);
        if (scheduledJobDetail.isCurrentlyRunning() || triggerType.equals("cron") && scheduledJobDetail.getNextRunTime().after(new Date())) {
            isStopExecution = true;
        }
        SchedulerDetail schedulerDetail = this.retriveSchedulerDetail();
        if (triggerType.equals("cron") && schedulerDetail.isSuspended()) {
            scheduledJobDetail.setTriggerMisfired(true);
            isStopExecution = true;
        } else if (!isStopExecution) {
            scheduledJobDetail.setCurrentlyRunning(true);
            scheduledJobDetail.setMismatchedJob(false);
        }
        this.scheduledJobDetailsRepository.save((Object)scheduledJobDetail);
        return isStopExecution;
    }

    public boolean fallbackProcessJobDetailForExecution(Exception e) {
        return false;
    }
}

