/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.infrastructure.businessdate.service.BusinessDateReadPlatformService;
import org.apache.fineract.infrastructure.core.domain.ActionContext;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.core.service.tenant.TenantDetailsService;
import org.apache.fineract.infrastructure.jobs.data.JobParameterDTO;
import org.apache.fineract.infrastructure.jobs.domain.JobParameterRepository;
import org.apache.fineract.infrastructure.jobs.domain.ScheduledJobDetail;
import org.apache.fineract.infrastructure.jobs.service.jobname.JobNameService;
import org.apache.fineract.infrastructure.jobs.service.jobparameterprovider.JobParameterProvider;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.domain.AppUserRepositoryWrapper;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class JobStarter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobStarter.class);
    private final JobExplorer jobExplorer;
    private final JobLauncher jobLauncher;
    private final JobParameterRepository jobParameterRepository;
    private final List<JobParameterProvider<?>> jobParameterProviders;
    private final JobNameService jobNameService;
    private final TenantDetailsService tenantDetailsService;
    private final AppUserRepositoryWrapper userRepository;
    private final BusinessDateReadPlatformService businessDateReadPlatformService;
    public static final List<BatchStatus> FAILED_STATUSES = List.of(BatchStatus.FAILED, BatchStatus.ABANDONED, BatchStatus.STOPPED, BatchStatus.STOPPING, BatchStatus.UNKNOWN);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobExecution run(Job job, ScheduledJobDetail scheduledJobDetail, Set<JobParameterDTO> jobParameterDTOSet, String tenantIdentifier) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException, JobExecutionException {
        boolean contextInitialized = false;
        FineractPlatformTenant existingTenant = ThreadLocalContextUtil.getTenant();
        try {
            if (existingTenant == null) {
                contextInitialized = true;
                FineractPlatformTenant tenant = this.tenantDetailsService.loadTenantById(tenantIdentifier);
                ThreadLocalContextUtil.setTenant((FineractPlatformTenant)tenant);
                AppUser user = this.userRepository.fetchSystemUser();
                UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
                SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
                HashMap businessDates = this.businessDateReadPlatformService.getBusinessDates();
                ThreadLocalContextUtil.setActionContext((ActionContext)ActionContext.DEFAULT);
                ThreadLocalContextUtil.setBusinessDates((HashMap)businessDates);
            }
            Map jobParameterMap = this.getJobParameter(scheduledJobDetail);
            JobParameters jobParameters = new JobParametersBuilder(this.jobExplorer).getNextJobParameters(job).addJobParameters(new JobParameters(jobParameterMap)).addJobParameters(new JobParameters(this.provideCustomJobParameters(this.jobNameService.getJobByHumanReadableName(scheduledJobDetail.getJobName()).getEnumStyleName(), jobParameterDTOSet))).toJobParameters();
            JobExecution result = this.jobLauncher.run(job, jobParameters);
            if (FAILED_STATUSES.contains(result.getStatus())) {
                throw new JobExecutionException(result.getExitStatus().toString());
            }
            JobExecution jobExecution = result;
            return jobExecution;
        }
        finally {
            if (contextInitialized) {
                ThreadLocalContextUtil.reset();
            }
        }
    }

    protected Map<String, JobParameter<?>> getJobParameter(ScheduledJobDetail scheduledJobDetail) {
        List jobParameterList = this.jobParameterRepository.findJobParametersByJobId((Long)scheduledJobDetail.getId());
        HashMap jobParameterMap = new HashMap();
        for (org.apache.fineract.infrastructure.jobs.domain.JobParameter jobParameter : jobParameterList) {
            jobParameterMap.put(jobParameter.getParameterName(), new JobParameter((Object)jobParameter.getParameterValue(), String.class));
        }
        return jobParameterMap;
    }

    protected Map<String, JobParameter<?>> provideCustomJobParameters(String jobName, Set<JobParameterDTO> jobParameterDTOSet) {
        Optional<JobParameterProvider> jobParameterProvider = this.jobParameterProviders.stream().filter(provider -> provider.canProvideParametersForJob(jobName)).findFirst();
        Map map = jobParameterProvider.map(parameterProvider -> parameterProvider.provide(jobParameterDTOSet)).orElse(Collections.emptyMap());
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Generated
    public JobStarter(JobExplorer jobExplorer, JobLauncher jobLauncher, JobParameterRepository jobParameterRepository, List<JobParameterProvider<?>> jobParameterProviders, JobNameService jobNameService, TenantDetailsService tenantDetailsService, AppUserRepositoryWrapper userRepository, BusinessDateReadPlatformService businessDateReadPlatformService) {
        this.jobExplorer = jobExplorer;
        this.jobLauncher = jobLauncher;
        this.jobParameterRepository = jobParameterRepository;
        this.jobParameterProviders = jobParameterProviders;
        this.jobNameService = jobNameService;
        this.tenantDetailsService = tenantDetailsService;
        this.userRepository = userRepository;
        this.businessDateReadPlatformService = businessDateReadPlatformService;
    }
}

