/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.cob.conditions.LoanCOBEnabledCondition;
import org.apache.fineract.cob.loan.RetrieveLoanIdService;
import org.apache.fineract.cob.service.InlineLoanCOBExecutorServiceImpl;
import org.apache.fineract.cob.service.LoanAccountLockService;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.http.BodyCachingHttpServletRequestWrapper;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.jobs.exception.LoanIdsHardLockedException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.portfolio.loanaccount.domain.GLIMAccountInfoRepository;
import org.apache.fineract.portfolio.loanaccount.domain.GroupLoanIndividualMonitoringAccount;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepository;
import org.apache.fineract.portfolio.loanaccount.rescheduleloan.domain.LoanRescheduleRequestRepository;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Conditional;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={LoanCOBEnabledCondition.class})
public class LoanCOBFilterHelper
implements InitializingBean {
    private final GLIMAccountInfoRepository glimAccountInfoRepository;
    private final LoanAccountLockService loanAccountLockService;
    private final PlatformSecurityContext context;
    private final InlineLoanCOBExecutorServiceImpl inlineLoanCOBExecutorService;
    private final LoanRepository loanRepository;
    private final FineractProperties fineractProperties;
    private final RetrieveLoanIdService retrieveLoanIdService;
    private final LoanRescheduleRequestRepository loanRescheduleRequestRepository;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final List<HttpMethod> HTTP_METHODS = List.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE);
    public static final Pattern IGNORE_LOAN_PATH_PATTERN = Pattern.compile("/v[1-9][0-9]*/loans/catch-up");
    public static final Pattern LOAN_PATH_PATTERN = Pattern.compile("/v[1-9][0-9]*/(?:reschedule)?loans/(?:external-id/)?([^/?]+).*");
    public static final Pattern LOAN_GLIMACCOUNT_PATH_PATTERN = Pattern.compile("/v[1-9][0-9]*/loans/glimAccount/(\\d+).*");
    private static final Predicate<String> URL_FUNCTION = s -> LOAN_PATH_PATTERN.matcher((CharSequence)s).find() || LOAN_GLIMACCOUNT_PATH_PATTERN.matcher((CharSequence)s).find();
    private static final String JOB_NAME = "INLINE_LOAN_COB";

    private Long getLoanId(boolean isGlim, String pathInfo) {
        if (!isGlim) {
            String id = LOAN_PATH_PATTERN.matcher(pathInfo).replaceAll("$1");
            if (this.isExternal(pathInfo)) {
                String externalId = id;
                return this.loanRepository.findIdByExternalId(new ExternalId(externalId));
            }
            if (this.isRescheduleLoans(pathInfo)) {
                return this.loanRescheduleRequestRepository.getLoanIdByRescheduleRequestId(Long.valueOf(id)).orElse(null);
            }
            if (StringUtils.isNumeric((CharSequence)id)) {
                return Long.valueOf(id);
            }
            return null;
        }
        return Long.valueOf(LOAN_GLIMACCOUNT_PATH_PATTERN.matcher(pathInfo).replaceAll("$1"));
    }

    private boolean isExternal(String pathInfo) {
        return LOAN_PATH_PATTERN.matcher(pathInfo).matches() && pathInfo.contains("external-id");
    }

    private boolean isRescheduleLoans(String pathInfo) {
        return LOAN_PATH_PATTERN.matcher(pathInfo).matches() && pathInfo.contains("/v1/rescheduleloans/");
    }

    public boolean isOnApiList(BodyCachingHttpServletRequestWrapper request) throws IOException {
        String pathInfo = request.getPathInfo();
        String method = request.getMethod();
        if (StringUtils.isBlank((CharSequence)pathInfo)) {
            return false;
        }
        if (this.isBatchApi(pathInfo)) {
            return this.isBatchApiMatching(request);
        }
        return this.isApiMatching(method, pathInfo);
    }

    private boolean isBatchApiMatching(BodyCachingHttpServletRequestWrapper request) throws IOException {
        for (BatchRequest batchRequest : this.getBatchRequests(request)) {
            String pathInfo;
            String method = batchRequest.getMethod();
            if (!this.isApiMatching(method, pathInfo = batchRequest.getRelativeUrl())) continue;
            return true;
        }
        return false;
    }

    private List<BatchRequest> getBatchRequests(BodyCachingHttpServletRequestWrapper request) throws IOException {
        List batchRequests = (List)this.objectMapper.readValue((InputStream)request.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        request.resetStream();
        for (BatchRequest batchRequest : batchRequests) {
            String pathInfo = "/" + batchRequest.getRelativeUrl();
            if (!CommandStrategyUtils.isRelativeUrlVersioned((String)batchRequest.getRelativeUrl())) {
                pathInfo = "/v1/" + batchRequest.getRelativeUrl();
            }
            batchRequest.setRelativeUrl(pathInfo);
        }
        return batchRequests;
    }

    private boolean isApiMatching(String method, String pathInfo) {
        return HTTP_METHODS.contains(HttpMethod.valueOf((String)method)) && !IGNORE_LOAN_PATH_PATTERN.matcher(pathInfo).find() && URL_FUNCTION.test(pathInfo);
    }

    private boolean isBatchApi(String pathInfo) {
        return pathInfo.startsWith("/v1/batches");
    }

    private boolean isGlim(String pathInfo) {
        return LOAN_GLIMACCOUNT_PATH_PATTERN.matcher(pathInfo).matches();
    }

    public boolean isBypassUser() {
        return this.context.authenticatedUser().isBypassUser();
    }

    private List<Long> getGlimChildLoanIds(Long loanIdFromRequest) {
        GroupLoanIndividualMonitoringAccount glimAccount = this.glimAccountInfoRepository.findOneByIsAcceptingChildAndApplicationId(true, BigDecimal.valueOf(loanIdFromRequest));
        if (glimAccount != null) {
            return glimAccount.getChildLoan().stream().map(AbstractPersistableCustom::getId).toList();
        }
        return Collections.emptyList();
    }

    private boolean isLoanHardLocked(Long ... loanIds) {
        return this.isLoanHardLocked(Arrays.asList(loanIds));
    }

    private boolean isLoanHardLocked(List<Long> loanIds) {
        return loanIds.stream().anyMatch(arg_0 -> ((LoanAccountLockService)this.loanAccountLockService).isLoanHardLocked(arg_0));
    }

    private boolean isLockOverrulable(Long ... loanIds) {
        return this.isLockOverrulable(Arrays.asList(loanIds));
    }

    private boolean isLockOverrulable(List<Long> loanIds) {
        return loanIds.stream().anyMatch(arg_0 -> ((LoanAccountLockService)this.loanAccountLockService).isLockOverrulable(arg_0));
    }

    public boolean isLoanBehind(List<Long> loanIds) {
        ArrayList loanIdAndLastClosedBusinessDates = new ArrayList();
        List partitions = Lists.partition(loanIds, (int)this.fineractProperties.getQuery().getInClauseParameterSizeLimit());
        partitions.forEach(partition -> loanIdAndLastClosedBusinessDates.addAll(this.retrieveLoanIdService.retrieveLoanIdsBehindDate(ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.COB_DATE), partition)));
        return CollectionUtils.isNotEmpty(loanIdAndLastClosedBusinessDates);
    }

    public List<Long> calculateRelevantLoanIds(BodyCachingHttpServletRequestWrapper request) throws IOException {
        String pathInfo = request.getPathInfo();
        if (this.isBatchApi(pathInfo)) {
            return this.getLoanIdsFromBatchApi(request);
        }
        return this.getLoanIdsFromApi(pathInfo);
    }

    private List<Long> getLoanIdsFromBatchApi(BodyCachingHttpServletRequestWrapper request) throws IOException {
        ArrayList<Long> loanIds = new ArrayList<Long>();
        for (BatchRequest batchRequest : this.getBatchRequests(request)) {
            Long loanId;
            String relativeUrl = batchRequest.getRelativeUrl();
            if (!relativeUrl.contains("$.resourceId")) {
                loanIds.addAll(this.getLoanIdsFromApi(relativeUrl));
            }
            if ((loanId = this.getTopLevelLoanIdFromBatchRequest(batchRequest)) == null) continue;
            if (this.isLoanHardLocked(new Long[]{loanId}) && !this.isLockOverrulable(new Long[]{loanId})) {
                throw new LoanIdsHardLockedException(loanId);
            }
            loanIds.add(loanId);
        }
        return loanIds;
    }

    private Long getTopLevelLoanIdFromBatchRequest(BatchRequest batchRequest) throws JsonProcessingException {
        JsonNode jsonNode;
        String body = batchRequest.getBody();
        if (StringUtils.isNotBlank((CharSequence)body) && (jsonNode = this.objectMapper.readTree(body)).has("loanId")) {
            return jsonNode.get("loanId").asLong();
        }
        return null;
    }

    private List<Long> getLoanIdsFromApi(String pathInfo) {
        List loanIds = this.getLoanIdList(pathInfo);
        if (this.isLoanHardLocked(loanIds) && !this.isLockOverrulable(loanIds)) {
            throw new LoanIdsHardLockedException((Long)loanIds.get(0));
        }
        return loanIds;
    }

    private List<Long> getLoanIdList(String pathInfo) {
        boolean isGlim = this.isGlim(pathInfo);
        Long loanIdFromRequest = this.getLoanId(isGlim, pathInfo);
        if (loanIdFromRequest == null) {
            return Collections.emptyList();
        }
        if (isGlim) {
            return this.getGlimChildLoanIds(loanIdFromRequest);
        }
        return Collections.singletonList(loanIdFromRequest);
    }

    public void executeInlineCob(List<Long> loanIds) {
        this.inlineLoanCOBExecutorService.execute(loanIds, JOB_NAME);
    }

    public void afterPropertiesSet() throws Exception {
        this.objectMapper.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
    }

    @Generated
    public LoanCOBFilterHelper(GLIMAccountInfoRepository glimAccountInfoRepository, LoanAccountLockService loanAccountLockService, PlatformSecurityContext context, InlineLoanCOBExecutorServiceImpl inlineLoanCOBExecutorService, LoanRepository loanRepository, FineractProperties fineractProperties, RetrieveLoanIdService retrieveLoanIdService, LoanRescheduleRequestRepository loanRescheduleRequestRepository) {
        this.glimAccountInfoRepository = glimAccountInfoRepository;
        this.loanAccountLockService = loanAccountLockService;
        this.context = context;
        this.inlineLoanCOBExecutorService = inlineLoanCOBExecutorService;
        this.loanRepository = loanRepository;
        this.fineractProperties = fineractProperties;
        this.retrieveLoanIdService = retrieveLoanIdService;
        this.loanRescheduleRequestRepository = loanRescheduleRequestRepository;
    }
}

