/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.api.IdTypeResolver;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.data.ApiGlobalErrorResponse;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.ToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.SearchParameters;
import org.apache.fineract.infrastructure.jobs.api.SchedulerJobApiConstants;
import org.apache.fineract.infrastructure.jobs.api.SchedulerJobApiResourceSwagger;
import org.apache.fineract.infrastructure.jobs.data.JobDetailData;
import org.apache.fineract.infrastructure.jobs.data.JobDetailHistoryData;
import org.apache.fineract.infrastructure.jobs.service.JobRegisterService;
import org.apache.fineract.infrastructure.jobs.service.SchedulerJobRunnerReadService;
import org.apache.fineract.infrastructure.security.exception.NoAuthorizationException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.springframework.stereotype.Component;

@Path(value="/v1/jobs")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
@Tag(name="SCHEDULER JOB", description="Batch jobs (also known as cron jobs on Unix-based systems) are a series of back-end jobs executed on a computer at a particular time defined in job's cron expression.\n\n At any point, you can view the list of batch jobs scheduled to run along with other details specific to each job. Manually you can execute the jobs at any point of time.\n\n The scheduler status can be either \"Active\" or \"Standby\". If the scheduler status is Active, it indicates that all batch jobs are running/ will run as per the specified schedule.If the scheduler status is Standby, it will ensure all scheduled batch runs are suspended.")
public class SchedulerJobApiResource {
    private final SchedulerJobRunnerReadService schedulerJobRunnerReadService;
    private final JobRegisterService jobRegisterService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final ToApiJsonSerializer<JobDetailData> toApiJsonSerializer;
    private final ToApiJsonSerializer<JobDetailHistoryData> jobHistoryToApiJsonSerializer;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final PlatformSecurityContext context;
    private final FineractProperties fineractProperties;
    private final SqlValidator sqlValidator;

    @GET
    @Operation(summary="Retrieve Scheduler Jobs", description="Returns the list of jobs.\n\nExample Requests:\n\njobs")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SchedulerJobApiResourceSwagger.GetJobsResponse.class)))})})
    public String retrieveAll(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("SCHEDULER");
        List jobDetailDatas = this.schedulerJobRunnerReadService.findAllJobDetails();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Collection)jobDetailDatas, SchedulerJobApiConstants.JOB_DETAIL_RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{jobId}")
    @Operation(summary="Retrieve a Job", description="Returns the details of a Job.\n\nExample Requests:\n\njobs/5")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SchedulerJobApiResourceSwagger.GetJobsResponse.class))})})
    public String retrieveOne(@PathParam(value="jobId") @Parameter(description="jobId") Long jobId, @Context UriInfo uriInfo) {
        return this.retrieveOne(IdTypeResolver.resolveDefault(), Objects.toString(jobId, null), uriInfo);
    }

    @GET
    @Path(value="short-name/{shortName}")
    @Operation(summary="Retrieve a Job", description="Returns the details of a Job bu shortName.\n\nExample Requests:\n\njobs/short-name/SA_PINT")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SchedulerJobApiResourceSwagger.GetJobsResponse.class))})})
    public String retrieveByShortName(@PathParam(value="shortName") @Parameter(required=true, description="short-name") String shortName, @Context UriInfo uriInfo) {
        return this.retrieveOne(IdTypeResolver.resolve((String)"short-name"), shortName, uriInfo);
    }

    @GET
    @Path(value="{jobId}/runhistory")
    @Operation(summary="Retrieve Job Run History", description="Example Requests:\n\njobs/5/runhistory?offset=0&limit=200")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SchedulerJobApiResourceSwagger.GetJobsJobIDJobRunHistoryResponse.class))})})
    public String retrieveHistory(@Context UriInfo uriInfo, @PathParam(value="jobId") @Parameter(description="jobId") Long jobId, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder) {
        return this.retrieveHistory(IdTypeResolver.resolveDefault(), Objects.toString(jobId, null), offset, limit, orderBy, sortOrder, uriInfo);
    }

    @GET
    @Path(value="short-name/{shortName}/runhistory")
    @Operation(summary="Retrieve Job Run History", description="Example Requests:\n\njobs/short-name/SA_PINT/runhistory?offset=0&limit=200")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SchedulerJobApiResourceSwagger.GetJobsJobIDJobRunHistoryResponse.class))})})
    public String retrieveHistoryByShortName(@Context UriInfo uriInfo, @PathParam(value="shortName") @Parameter(required=true, description="short-name") String shortName, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder) {
        return this.retrieveHistory(IdTypeResolver.resolve((String)"short-name"), shortName, offset, limit, orderBy, sortOrder, uriInfo);
    }

    @POST
    @Path(value="{jobId}")
    @Operation(summary="Run a Job", description="Manually Execute Specific Job.")
    @RequestBody(content={@Content(schema=@Schema(implementation=SchedulerJobApiResourceSwagger.ExecuteJobRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="POST: jobs/1?command=executeJob")})
    public Response executeJob(@PathParam(value="jobId") @Parameter(description="jobId") Long jobId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String jsonRequestBody) {
        return this.executeJob(IdTypeResolver.resolveDefault(), Objects.toString(jobId, null), commandParam, jsonRequestBody);
    }

    @POST
    @Path(value="short-name/{shortName}")
    @Operation(summary="Run a Job", description="Manually Execute Specific Job.")
    @RequestBody(content={@Content(schema=@Schema(implementation=SchedulerJobApiResourceSwagger.ExecuteJobRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="POST: jobs/short-name/SA_PINT?command=executeJob")})
    public Response executeJobByShortName(@PathParam(value="shortName") @Parameter(required=true, description="short-name") String shortName, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String jsonRequestBody) {
        return this.executeJob(IdTypeResolver.resolve((String)"short-name"), shortName, commandParam, jsonRequestBody);
    }

    @PUT
    @Path(value="{jobId}")
    @Operation(summary="Update a Job", description="Updates the details of a job.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SchedulerJobApiResourceSwagger.PutJobsJobIDRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public String updateJobDetail(@PathParam(value="jobId") @Parameter(description="jobId") Long jobId, @Parameter(hidden=true) String jsonRequestBody) {
        return this.updateJobDetail(IdTypeResolver.resolveDefault(), Objects.toString(jobId, null), jsonRequestBody);
    }

    @PUT
    @Path(value="short-name/{shortName}")
    @Operation(summary="Update a Job", description="Updates the details of a job.")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=SchedulerJobApiResourceSwagger.PutJobsJobIDRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public String updateJobDetailByShortName(@PathParam(value="shortName") @Parameter(required=true, description="short-name") String shortName, @Parameter(hidden=true) String jsonRequestBody) {
        return this.updateJobDetail(IdTypeResolver.resolve((String)"short-name"), shortName, jsonRequestBody);
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    private String retrieveOne(@NotNull IdTypeResolver.IdType idType, String identifier, UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("SCHEDULER");
        JobDetailData jobDetailData = this.schedulerJobRunnerReadService.retrieveOne(idType, identifier);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)jobDetailData, SchedulerJobApiConstants.JOB_DETAIL_RESPONSE_DATA_PARAMETERS);
    }

    private String retrieveHistory(@NotNull IdTypeResolver.IdType idType, String identifier, Integer offset, Integer limit, String orderBy, String sortOrder, UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission("SCHEDULER");
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        SearchParameters searchParameters = SearchParameters.builder().limit(limit).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        Page jobHistoryData = this.schedulerJobRunnerReadService.retrieveJobHistory(idType, identifier, searchParameters);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.jobHistoryToApiJsonSerializer.serialize(settings, jobHistoryData, SchedulerJobApiConstants.JOB_HISTORY_RESPONSE_DATA_PARAMETERS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Response executeJob(@NotNull IdTypeResolver.IdType idType, String identifier, String commandParam, String jsonRequestBody) {
        if (this.fineractProperties.getMode().isBatchManagerEnabled()) {
            boolean hasNotPermission = this.context.authenticatedUser().hasNotPermissionForAnyOf(new String[]{"ALL_FUNCTIONS", "EXECUTEJOB_SCHEDULER"});
            if (hasNotPermission) {
                String authorizationMessage = "User has no authority to execute scheduler jobs";
                throw new NoAuthorizationException("User has no authority to execute scheduler jobs");
            }
            Response response = Response.status((int)400).build();
            if (!this.is(commandParam, "executeJob")) throw new UnrecognizedQueryParamException("command", commandParam, new Object[0]);
            Long jobId = this.schedulerJobRunnerReadService.retrieveId(idType, identifier);
            this.jobRegisterService.executeJobWithParameters(jobId, jsonRequestBody);
            return Response.status((int)202).build();
        }
        ApiGlobalErrorResponse errorResponse = ApiGlobalErrorResponse.invalidInstanceTypeMethod((String)"Batch");
        return Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)errorResponse).build();
    }

    private String updateJobDetail(@NotNull IdTypeResolver.IdType idType, String identifier, String jsonRequestBody) {
        Long jobId = this.schedulerJobRunnerReadService.retrieveId(idType, identifier);
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateJobDetail(jobId).withJson(jsonRequestBody).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        if (result.getChanges() != null && (result.getChanges().containsKey("active") || result.getChanges().containsKey("cronExpression"))) {
            this.jobRegisterService.rescheduleJob(jobId);
        }
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @Generated
    public SchedulerJobApiResource(SchedulerJobRunnerReadService schedulerJobRunnerReadService, JobRegisterService jobRegisterService, ApiRequestParameterHelper apiRequestParameterHelper, ToApiJsonSerializer<JobDetailData> toApiJsonSerializer, ToApiJsonSerializer<JobDetailHistoryData> jobHistoryToApiJsonSerializer, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, PlatformSecurityContext context, FineractProperties fineractProperties, SqlValidator sqlValidator) {
        this.schedulerJobRunnerReadService = schedulerJobRunnerReadService;
        this.jobRegisterService = jobRegisterService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.jobHistoryToApiJsonSerializer = jobHistoryToApiJsonSerializer;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.context = context;
        this.fineractProperties = fineractProperties;
        this.sqlValidator = sqlValidator;
    }
}

