/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.handler;

import lombok.Generated;
import org.apache.fineract.commands.handler.NewCommandSourceHandler;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableWriteService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UpdateDatatableCommandHandler
implements NewCommandSourceHandler {
    private final DatatableWriteService datatableWriteService;

    @Transactional
    public CommandProcessingResult processCommand(JsonCommand command) {
        String datatableName = command.getUrl().replaceAll("/datatables/", "");
        this.datatableWriteService.updateDatatable(datatableName, command);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withResourceIdAsString(datatableName).build();
    }

    @Generated
    public UpdateDatatableCommandHandler(DatatableWriteService datatableWriteService) {
        this.datatableWriteService = datatableWriteService;
    }
}

