/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.domain;

import com.google.gson.JsonArray;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.dataqueries.domain.ReportParameterUsage;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="stretchy_report", uniqueConstraints={@UniqueConstraint(columnNames={"report_name"}, name="unq_report_name")})
public final class Report
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @Column(name="report_name", nullable=false, unique=true)
    private String reportName;
    @Column(name="report_type", nullable=false)
    private String reportType;
    @Column(name="report_subtype")
    private String reportSubType;
    @Column(name="report_category")
    private String reportCategory;
    @Column(name="description")
    private String description;
    @Column(name="core_report", nullable=false)
    private boolean coreReport;
    @Column(name="use_report", nullable=false)
    private boolean useReport;
    @Column(name="report_sql")
    private String reportSql;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="report", orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<ReportParameterUsage> reportParameterUsages;
    @Column(name="self_service_user_report")
    private boolean isSelfServiceUserReport;
    static final long serialVersionUID = -5670010466242542481L;

    public static Report fromJson(JsonCommand command, Collection<String> reportTypes) {
        String reportName = null;
        String reportType = null;
        String reportSubType = null;
        String reportCategory = null;
        String description = null;
        boolean useReport = false;
        String reportSql = null;
        if (command.parameterExists("reportName")) {
            reportName = command.stringValueOfParameterNamed("reportName");
        }
        if (command.parameterExists("reportType")) {
            reportType = command.stringValueOfParameterNamed("reportType");
        }
        if (command.parameterExists("reportSubType")) {
            reportSubType = command.stringValueOfParameterNamed("reportSubType");
        }
        if (command.parameterExists("reportCategory")) {
            reportCategory = command.stringValueOfParameterNamed("reportCategory");
        }
        if (command.parameterExists("description")) {
            description = command.stringValueOfParameterNamed("description");
        }
        if (command.parameterExists("useReport")) {
            useReport = command.booleanPrimitiveValueOfParameterNamed("useReport");
        }
        if (command.parameterExists("reportSql")) {
            reportSql = command.stringValueOfParameterNamed("reportSql");
        }
        return new Report(reportName, reportType, reportSubType, reportCategory, description, useReport, reportSql, reportTypes);
    }

    Report() {
        this.reportParameterUsages = new HashSet();
    }

    public Report(String reportName, String reportType, String reportSubType, String reportCategory, String description, boolean useReport, String reportSql, Collection<String> reportTypes) {
        this.reportParameterUsages = new HashSet();
        this.reportName = reportName;
        this.reportType = reportType;
        this.reportSubType = reportSubType;
        this.reportCategory = reportCategory;
        this.description = description;
        this.coreReport = false;
        this.useReport = useReport;
        this.reportSql = reportSql;
        this.validate(reportTypes);
    }

    public Map<String, Object> update(JsonCommand command, Collection<String> reportTypes) {
        JsonArray jsonArray;
        String newValue;
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(8);
        String paramName = "reportName";
        if (command.isChangeInStringParameterNamed(paramName, this._persistence_get_reportName())) {
            newValue = command.stringValueOfParameterNamed(paramName);
            actualChanges.put(paramName, newValue);
            this._persistence_set_reportName((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        if (command.isChangeInStringParameterNamed(paramName = "reportType", this._persistence_get_reportType())) {
            newValue = command.stringValueOfParameterNamed(paramName);
            actualChanges.put(paramName, newValue);
            this._persistence_set_reportType((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        if (command.isChangeInStringParameterNamed(paramName = "reportSubType", this._persistence_get_reportSubType())) {
            newValue = command.stringValueOfParameterNamed(paramName);
            actualChanges.put(paramName, newValue);
            this._persistence_set_reportSubType((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        if (command.isChangeInStringParameterNamed(paramName = "reportCategory", this._persistence_get_reportCategory())) {
            newValue = command.stringValueOfParameterNamed(paramName);
            actualChanges.put(paramName, newValue);
            this._persistence_set_reportCategory((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        if (command.isChangeInStringParameterNamed(paramName = "description", this._persistence_get_description())) {
            newValue = command.stringValueOfParameterNamed(paramName);
            actualChanges.put(paramName, newValue);
            this._persistence_set_description((String)StringUtils.defaultIfEmpty((CharSequence)newValue, null));
        }
        if (command.isChangeInBooleanParameterNamed(paramName = "useReport", Boolean.valueOf(this._persistence_get_useReport()))) {
            boolean newValue2 = command.booleanPrimitiveValueOfParameterNamed(paramName);
            actualChanges.put(paramName, newValue2);
            this._persistence_set_useReport(newValue2);
        }
        if (command.isChangeInStringParameterNamed(paramName = "reportSql", this._persistence_get_reportSql())) {
            String newValue3 = command.stringValueOfParameterNamed(paramName);
            actualChanges.put(paramName, newValue3);
            this._persistence_set_reportSql((String)StringUtils.defaultIfEmpty((CharSequence)newValue3, null));
        }
        String reportParametersParamName = "reportParameters";
        if (command.hasParameter("reportParameters") && (jsonArray = command.arrayOfParameterNamed("reportParameters")) != null) {
            actualChanges.put("reportParameters", command.jsonFragment("reportParameters"));
        }
        this.validate(reportTypes);
        if (!actualChanges.isEmpty() && this.isCoreReport()) {
            for (String key : actualChanges.keySet()) {
                if (key.equals("useReport")) continue;
                throw new PlatformDataIntegrityException("error.msg.only.use.report.can.be.updated.for.core.report", "Only the Use Report field can be updated for Core Reports", key, new Object[0]);
            }
        }
        return actualChanges;
    }

    public boolean isCoreReport() {
        return this._persistence_get_coreReport();
    }

    public ReportParameterUsage findReportParameterById(Long reportParameterId) {
        ReportParameterUsage reportParameterUsage = null;
        for (ReportParameterUsage rpu : this._persistence_get_reportParameterUsages()) {
            if (!rpu.hasIdOf(reportParameterId)) continue;
            reportParameterUsage = rpu;
            break;
        }
        return reportParameterUsage;
    }

    private void validate(Collection<String> reportTypes) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("report");
        baseDataValidator.reset().parameter("reportName").value((Object)this._persistence_get_reportName()).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        baseDataValidator.reset().parameter("reportType").value((Object)this._persistence_get_reportType()).notBlank().isOneOfTheseValues(reportTypes.toArray());
        baseDataValidator.reset().parameter("reportSubType").value((Object)this._persistence_get_reportSubType()).notExceedingLengthOf(Integer.valueOf(20));
        if (StringUtils.isNotBlank((CharSequence)this._persistence_get_reportType())) {
            if (this._persistence_get_reportType().equals("Chart")) {
                baseDataValidator.reset().parameter("reportSubType").value((Object)this._persistence_get_reportSubType()).cantBeBlankWhenParameterProvidedIs("reportType", (Object)this._persistence_get_reportType()).isOneOfTheseValues(new Object[]{"Bar", "Pie"});
            } else {
                baseDataValidator.reset().parameter("reportSubType").value((Object)this._persistence_get_reportSubType()).mustBeBlankWhenParameterProvidedIs("reportType", (Object)this._persistence_get_reportType());
            }
        }
        baseDataValidator.reset().parameter("reportCategory").value((Object)this._persistence_get_reportCategory()).notExceedingLengthOf(Integer.valueOf(45));
        if (StringUtils.isNotBlank((CharSequence)this._persistence_get_reportType())) {
            if (this._persistence_get_reportType().equals("Table") || this._persistence_get_reportType().equals("Chart")) {
                baseDataValidator.reset().parameter("reportSql").value((Object)this._persistence_get_reportSql()).cantBeBlankWhenParameterProvidedIs("reportType", (Object)this._persistence_get_reportType());
            } else {
                baseDataValidator.reset().parameter("reportSql").value((Object)this._persistence_get_reportSql()).mustBeBlankWhenParameterProvidedIs("reportType", (Object)this._persistence_get_reportType());
            }
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public String getReportName() {
        return this._persistence_get_reportName();
    }

    public boolean update(Set<ReportParameterUsage> newReportParameterUsages) {
        if (newReportParameterUsages == null) {
            return false;
        }
        boolean updated = false;
        if (this.changeInReportParameters(newReportParameterUsages)) {
            updated = true;
            this._persistence_get_reportParameterUsages().clear();
            this._persistence_get_reportParameterUsages().addAll(newReportParameterUsages);
        }
        return updated;
    }

    private boolean changeInReportParameters(Set<ReportParameterUsage> newReportParameterUsages) {
        return !this._persistence_get_reportParameterUsages().equals(newReportParameterUsages);
    }

    public Set<ReportParameterUsage> getReportParameterUsages() {
        return this._persistence_get_reportParameterUsages();
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new Report(persistenceObject);
    }

    public Report(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "reportType") {
            return this.reportType;
        }
        if (string == "reportName") {
            return this.reportName;
        }
        if (string == "reportSubType") {
            return this.reportSubType;
        }
        if (string == "isSelfServiceUserReport") {
            return this.isSelfServiceUserReport;
        }
        if (string == "reportCategory") {
            return this.reportCategory;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "reportSql") {
            return this.reportSql;
        }
        if (string == "coreReport") {
            return this.coreReport;
        }
        if (string == "reportParameterUsages") {
            return this.reportParameterUsages;
        }
        if (string == "useReport") {
            return this.useReport;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "reportType") {
            this.reportType = (String)object;
            return;
        }
        if (string == "reportName") {
            this.reportName = (String)object;
            return;
        }
        if (string == "reportSubType") {
            this.reportSubType = (String)object;
            return;
        }
        if (string == "isSelfServiceUserReport") {
            this.isSelfServiceUserReport = (Boolean)object;
            return;
        }
        if (string == "reportCategory") {
            this.reportCategory = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "reportSql") {
            this.reportSql = (String)object;
            return;
        }
        if (string == "coreReport") {
            this.coreReport = (Boolean)object;
            return;
        }
        if (string == "reportParameterUsages") {
            this.reportParameterUsages = (Set)object;
            return;
        }
        if (string == "useReport") {
            this.useReport = (Boolean)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public String _persistence_get_reportType() {
        this._persistence_checkFetched("reportType");
        return this.reportType;
    }

    public void _persistence_set_reportType(String string) {
        this._persistence_checkFetchedForSet("reportType");
        this.reportType = string;
    }

    public String _persistence_get_reportName() {
        this._persistence_checkFetched("reportName");
        return this.reportName;
    }

    public void _persistence_set_reportName(String string) {
        this._persistence_checkFetchedForSet("reportName");
        this.reportName = string;
    }

    public String _persistence_get_reportSubType() {
        this._persistence_checkFetched("reportSubType");
        return this.reportSubType;
    }

    public void _persistence_set_reportSubType(String string) {
        this._persistence_checkFetchedForSet("reportSubType");
        this.reportSubType = string;
    }

    public boolean _persistence_get_isSelfServiceUserReport() {
        this._persistence_checkFetched("isSelfServiceUserReport");
        return this.isSelfServiceUserReport;
    }

    public void _persistence_set_isSelfServiceUserReport(boolean bl) {
        this._persistence_checkFetchedForSet("isSelfServiceUserReport");
        this.isSelfServiceUserReport = bl;
    }

    public String _persistence_get_reportCategory() {
        this._persistence_checkFetched("reportCategory");
        return this.reportCategory;
    }

    public void _persistence_set_reportCategory(String string) {
        this._persistence_checkFetchedForSet("reportCategory");
        this.reportCategory = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this.description = string;
    }

    public String _persistence_get_reportSql() {
        this._persistence_checkFetched("reportSql");
        return this.reportSql;
    }

    public void _persistence_set_reportSql(String string) {
        this._persistence_checkFetchedForSet("reportSql");
        this.reportSql = string;
    }

    public boolean _persistence_get_coreReport() {
        this._persistence_checkFetched("coreReport");
        return this.coreReport;
    }

    public void _persistence_set_coreReport(boolean bl) {
        this._persistence_checkFetchedForSet("coreReport");
        this.coreReport = bl;
    }

    public Set _persistence_get_reportParameterUsages() {
        this._persistence_checkFetched("reportParameterUsages");
        return this.reportParameterUsages;
    }

    public void _persistence_set_reportParameterUsages(Set set) {
        this._persistence_checkFetchedForSet("reportParameterUsages");
        this.reportParameterUsages = set;
    }

    public boolean _persistence_get_useReport() {
        this._persistence_checkFetched("useReport");
        return this.useReport;
    }

    public void _persistence_set_useReport(boolean bl) {
        this._persistence_checkFetchedForSet("useReport");
        this.useReport = bl;
    }
}

