/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.service.migration;

import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.database.DatabaseIndependentQueryService;
import org.apache.fineract.infrastructure.core.service.database.DatabaseTypeResolver;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class TenantDatabaseStateVerifier {
    private static final int TENANT_STORE_LATEST_FLYWAY_VERSION = 6;
    private static final String TENANT_STORE_LATEST_FLYWAY_SCRIPT_NAME = "V6__add_unique_tenant_identifier.sql";
    private static final int TENANT_STORE_LATEST_FLYWAY_SCRIPT_CHECKSUM = -43094919;
    private static final int TENANT_LATEST_FLYWAY_VERSION = 392;
    private static final String TENANT_LATEST_FLYWAY_SCRIPT_NAME = "V392__interest_recovery_conf_for_rescedule.sql";
    private static final int TENANT_LATEST_FLYWAY_SCRIPT_CHECKSUM = 1102395052;
    private final LiquibaseProperties liquibaseProperties;
    private final DatabaseIndependentQueryService dbQueryService;
    private final DatabaseTypeResolver databaseTypeResolver;

    public boolean isFirstLiquibaseMigration(DataSource dataSource) {
        String tableName = "DATABASECHANGELOG";
        return !this.dbQueryService.isTablePresent(dataSource, this.databaseTypeResolver.isPostgreSQL() ? tableName.toLowerCase() : tableName);
    }

    public boolean isFlywayPresent(DataSource dataSource) {
        return this.dbQueryService.isTablePresent(dataSource, "schema_version");
    }

    public boolean isLiquibaseDisabled() {
        return !this.liquibaseProperties.isEnabled();
    }

    public boolean isTenantStoreOnLatestUpgradableVersion(DataSource dataSource) {
        return this.isOnLatestFlywayVersion(6, TENANT_STORE_LATEST_FLYWAY_SCRIPT_NAME, -43094919, dataSource);
    }

    public boolean isTenantOnLatestUpgradableVersion(DataSource dataSource) {
        return this.isOnLatestFlywayVersion(392, TENANT_LATEST_FLYWAY_SCRIPT_NAME, 1102395052, dataSource);
    }

    private boolean isOnLatestFlywayVersion(int version, String scriptName, int checksum, DataSource dataSource) {
        Map<String, Integer> paramMap = Map.of("latestFlywayVersion", version, "latestFlywayScriptName", scriptName, "latestFlywayScriptChecksum", checksum);
        NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
        Integer result = (Integer)jdbcTemplate.queryForObject("SELECT COUNT(script) FROM schema_version WHERE version = :latestFlywayVersion AND script = :latestFlywayScriptName AND checksum = :latestFlywayScriptChecksum AND success = 1", paramMap, Integer.class);
        return Objects.equals(result, 1);
    }

    @Generated
    public TenantDatabaseStateVerifier(LiquibaseProperties liquibaseProperties, DatabaseIndependentQueryService dbQueryService, DatabaseTypeResolver databaseTypeResolver) {
        this.liquibaseProperties = liquibaseProperties;
        this.dbQueryService = dbQueryService;
        this.databaseTypeResolver = databaseTypeResolver;
    }
}

