/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.http;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.fineract.infrastructure.core.http.BodyCachingHttpServletRequestWrapper;

public class BodyCachingHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] cachedBody;
    private ByteArrayInputStream inputStream;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public BodyCachingHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.cachedBody = IOUtils.toByteArray((InputStream)request.getInputStream());
        this.inputStream = new ByteArrayInputStream(this.cachedBody);
    }

    public ServletInputStream getInputStream() throws IOException {
        return new CachedBodyServletInputStream(this.inputStream);
    }

    public BufferedReader getReader() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.cachedBody);
        return new BufferedReader(new InputStreamReader((InputStream)byteArrayInputStream, StandardCharsets.UTF_8));
    }

    public void resetStream() {
        this.inputStream = new ByteArrayInputStream(this.cachedBody);
    }
}

